<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::group(['middleware' => 'web'], function() {
//
//    Route::get('/{any}', function () {
//        return view('app');
//    })->where('any', '.*');;
//
//});

Route::group(['middleware' => 'web', "namespace"=>"App\Http\Controllers\API\V1"], function() {

    Route::get('/accept_purchase_order_mail/{lang}/{id?}/{encryptedParameter}', "Purchases\PurchasesOrderController@accept_purchase_order");
    Route::get('/decline_purchase_order_mail/{lang}/{id?}/{encryptedParameter}', "Purchases\PurchasesOrderController@decline_purchase_order");


    Route::get('/export_sales_invoice/{id}', "POS\SalesInvoiceController@print_invoice");
    Route::get('/export_notice_debtor/{id}', "POS\NoticeDebtorController@print_invoice");
    Route::get('/export_notice_creditor/{id}', "POS\NoticeCreditorController@print_invoice");
    Route::get('/export_expense/{id}', "POS\ExpenseController@print_invoice");

    Route::get('/print_quotation/{id}', "Sales\QuotationController@print_invoice");
    Route::get('/print_proforma_invoice/{id}', "Sales\ProformaInvoiceController@print_invoice");
    Route::get('/print_delivery_note/{id}', "Sales\DeliveryNoteController@print_invoice");
    Route::get('/print_sales_invoice/{id}', "Sales\SalesInvoiceController@print_invoice");

    Route::get('/print_purchases_order/{id}', "Purchases\PurchasesOrderController@print_invoice");
    Route::get('/print_purchases_note/{id}', "Purchases\PurchasesNoteController@print_invoice");
    Route::get('/print_purchases_invoice/{id}', "Purchases\PurchasesInvoiceController@print_invoice");

});
