<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class SalesAgent extends Model
{
    protected $primaryKey     = 'sales_agent_id';
    public static $main_table = 'sales_agents';
    public $table             = 'sales_agents';

    public static $rules = array(
        'name_en'         => 'required|string|unique:sales_agents',
        'name_ar'         => 'required|string|unique:sales_agents',
        'phone'           => 'required|string',
        'commission_rate' => 'required|numeric',
        'max_discount'    => 'required|numeric',
    );

    public static function all_sales_agents($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.sales_agent_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                sales_agent_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.phone ,'.
                self::$main_table.'.commission_rate,'.
                self::$main_table.'.max_discount,'.
                self::$main_table.'.sales_agent_status,'.
                self::$main_table.'.sales_agent_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('sales_agent_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table . '.sales_agent_id', $params['word']);

            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_sales_agent($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('sales_agent_id', $id);

        $query->selectRaw('
            sales_agent_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.phone ,'.
            self::$main_table.'.commission_rate,'.
            self::$main_table.'.max_discount,'.
            self::$main_table.'.sales_agent_status,'.
            self::$main_table.'.sales_agent_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_sales_agent($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_sales_agent($seed, $id)
    {
        return DB::table(self::$main_table)->where('sales_agent_id', $id)->update($seed);
    }

    public static function delete_sales_agent($id)
    {
        return DB::table(self::$main_table)->where('sales_agent_id', $id)->update(array('sales_agent_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
