<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class DeliveryNote extends Model
{
    protected $primaryKey     = 'delivery_note_m_id';
    public static $main_table = 'delivery_note_m';
    public $table             = 'delivery_note_m';

    public static $master_rules = array(
        'customer_id'               => 'required|numeric',
       'proforma_invoice_id'       => 'required|numeric',
//        'driver_id'                 => 'required|numeric',
//        'car_number'                => 'required|numeric',
        'delivery_note_date'        => 'required|date',
//        'delivery_note_description' => 'required',
        'sales_agent_id'            => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'        => 'required|numeric',
        'warehouse_id'   => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_delivery_notes($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id')
            ->leftjoin('proforma_invoice_m' , self::$main_table.'.proforma_invoice_id' , '=' , 'proforma_invoice_m.proforma_invoice_m_id')
            ->orderBy(self::$main_table.'.delivery_note_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                delivery_note_m_id as m_id ,
                delivery_note_date ,
                delivery_note_time ,
                delivery_note_description ,
                driver_id ,
                car_number ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$params['lang'].' as sales_agent_name ,
                proforma_invoice_m.quotation_id ,
                proforma_invoice_m.purchase_order_id ,'.
                self::$main_table.'.proforma_invoice_id ,'.
                self::$main_table.'.branch_id ,'.
                self::$main_table.'.finance_year_id ,
                delivery_note_status ,
                delivery_note_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_vat ,'.
                self::$main_table.'.total_without_vat ,'.
                self::$main_table.'.total_with_vat
            ');
        }

        if(isset($params['active']))
            $query->where('delivery_note_active', $params['active']);

        if(isset($params['status']))
            $query->where('delivery_note_status', $params['status']);

        if(isset($params['customer_id']))
            $query->where(self::$main_table.'.customer_id', $params['customer_id']);

        if(isset($params['proforma_invoice_id']))
            $query->where(self::$main_table.'.proforma_invoice_id', $params['proforma_invoice_id']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('delivery_note_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('proforma_invoice_m.quotation_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('proforma_invoice_m.purchase_order_id', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_delivery_note_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id')
            ->leftjoin('proforma_invoice_m' , self::$main_table.'.proforma_invoice_id' , '=' , 'proforma_invoice_m.proforma_invoice_m_id')
            ->where('delivery_note_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                delivery_note_m_id as m_id ,
                delivery_note_date ,
                delivery_note_time ,
                delivery_note_description ,
                driver_id ,
                car_number ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$lang.' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$lang.' as sales_agent_name ,
                proforma_invoice_m.quotation_id ,
                proforma_invoice_m.purchase_order_id ,'.
                self::$main_table.'.proforma_invoice_id ,'.
                self::$main_table.'.branch_id ,'.
                self::$main_table.'.finance_year_id ,
                delivery_note_status ,
                users.user_full_name as added_by ,
                users.mobile as added_mobile ,
                users.email as added_email ,
                delivery_note_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_vat ,'.
                self::$main_table.'.total_without_vat ,'.
                self::$main_table.'.total_with_vat
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_delivery_note_d($id, $lang = null)
    {
        $query = DB::table('delivery_note_d')
            ->leftjoin('items' , 'delivery_note_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('warehouses' , 'delivery_note_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements' , 'delivery_note_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'delivery_note_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->where('delivery_note_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                delivery_note_m_id as m_id ,
                delivery_note_d_id as d_id ,
                delivery_note_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.price_include_vat ,
                delivery_note_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                delivery_note_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                delivery_note_d.quantity ,
                delivery_note_d.price ,
                delivery_note_d.item_price ,
                delivery_note_d.total_price ,
                delivery_note_d.currency_id ,
                delivery_note_d.foreign_currency ,
                delivery_note_d.equivalent_value ,

                delivery_note_d.item_discount ,
                delivery_note_d.total_discount ,

                delivery_note_d.tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                delivery_note_d.total_vat ,
                delivery_note_d.total_without_vat ,
                delivery_note_d.total_with_vat
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_delivery_note_files($id)
    {
        return DB::table('delivery_note_files')
            ->where('delivery_note_m_id', $id)
            ->get();
    }

    public static function add_delivery_note_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_delivery_note_d($seed)
    {
        return DB::table('delivery_note_d')->insertGetId($seed);
    }

    public static function update_delivery_note_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('delivery_note_m_id', $id)->update($seed);
    }

    public static function delete_delivery_note_m($id)
    {
        return DB::table(self::$main_table)->where('delivery_note_m_id', $id)->update(array('delivery_note_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_delivery_note_d($id)
    {
        return DB::table('delivery_note_d')->where('delivery_note_m_id', $id)->delete();
    }
}
