<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use DB;

class PurchasesNote extends Model
{
    protected $primaryKey     = 'purchases_note_m_id';
    public static $main_table = 'purchases_note_m';
    public $table             = 'purchases_note_m';

    public static $master_rules = array(
        'purchases_note_date'         => 'required|date',
        'purchases_note_no'           => 'required|numeric',
        'purchases_vendor_id'         => 'required|numeric',
//        'purchases_order_id'          => 'required|numeric',
        'purchases_order_id'          => 'nullable',
        'purchases_vendor_invoice_no' => 'required|numeric',
//        'purchases_note_description'  => 'required',
    );

    public static $details_rules = array(
        'warehouse_id'   => 'required|numeric',
        'item_id'        => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_purchases_notes($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->orderBy(self::$main_table.'.purchases_note_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                purchases_note_m_id as m_id ,
                purchases_note_date ,
                purchases_note_no ,
                purchases_vendor_invoice_no ,
                purchases_order_id ,
                purchases_note_description ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$params['lang'].' as purchases_vendor_name ,
                branch_id ,
                finance_year_id ,
                purchases_note_status ,
                purchases_note_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat
            ');
        }

        if(isset($params['active']))
            $query->where('purchases_note_active', $params['active']);

        if(isset($params['status']))
            $query->where('purchases_note_status', $params['status']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('purchases_note_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_en', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_purchases_note_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->where('purchases_note_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                purchases_note_m_id as m_id ,
                purchases_note_date ,
                purchases_note_no ,
                purchases_vendor_invoice_no ,
                purchases_order_id ,
                purchases_note_description ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                branch_id ,
                finance_year_id ,
                purchases_note_status ,
                purchases_note_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_purchases_note_d($id, $lang = null)
    {
        $query = DB::table('purchases_note_d')
            ->leftjoin('warehouses' , 'purchases_note_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('items' , 'purchases_note_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('unit_measurements' , 'purchases_note_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'purchases_note_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->leftjoin('receiving_locations' , 'purchases_note_d.receiving_location_id' , '=' , 'receiving_locations.receiving_location_id')
            ->where('purchases_note_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                purchases_note_m_id as m_id ,
                purchases_note_d_id as d_id ,
                purchases_note_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                purchases_note_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.location,
                purchases_note_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                purchases_note_d.quantity ,
                purchases_note_d.price ,
                purchases_note_d.total_price ,

                purchases_note_d.currency_id ,
                purchases_note_d.foreign_currency ,
                purchases_note_d.equivalent_value ,

                purchases_note_d.tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                purchases_note_d.total_vat ,
                purchases_note_d.total_without_vat ,
                purchases_note_d.total_with_vat ,
                purchases_note_d.receiving_location_id ,
                receiving_locations.name_'.$lang.' as receiving_location_name
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_purchases_note_files($id)
    {
        return DB::table('purchases_note_files')
            ->where('purchases_note_m_id', $id)
            ->get();
    }

    public static function add_purchases_note_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_purchases_note_d($seed)
    {
        return DB::table('purchases_note_d')->insertGetId($seed);
    }

    public static function update_purchases_note_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('purchases_note_m_id', $id)->update($seed);
    }

    public static function delete_purchases_note_m($id)
    {
        return DB::table(self::$main_table)->where('purchases_note_m_id', $id)->update(array('purchases_note_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_purchases_note_d($id)
    {
        return DB::table('purchases_note_d')->where('purchases_note_m_id', $id)->delete();
    }
}
