<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Model;
use DB;

class SalesOrder extends Model
{
    protected $primaryKey = 'sales_order_m_id';

    public static $main_table = 'sales_order_m';

    public static function all_sales_orders($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('sales_agents', self::$main_table.'.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('sales_invoice_types', self::$main_table.'.sales_order_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->where('sales_order_status', 1)
            ->orderBy(self::$main_table.'.sales_order_m_id', 'desc')
            ->groupBy(self::$main_table.'.sales_order_m_id');

        if($params['lang'] != null){
            $query->selectRaw('
                sales_order_m_id as m_id ,
                sales_order_date ,
                sales_order_description ,'.
                self::$main_table.'.sales_order_type_id ,
                sales_invoice_types.sales_invoice_type_title_'.$params['lang'].' as type_title ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,
                customers.phone as customer_phone ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$params['lang'].' as sales_agent_name ,
                supply_order ,
                branch_id ,
                finance_year_id ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                discount ,
                items_count ,
                sales_order_status ,
                sales_order_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount
            ');
        }

        if(isset($params['active'])){
            $query->where('sales_order_active', $params['active']);
        }

        if(isset($params['status'])){
            $query->where('sales_order_status', $params['status']);
        }

        if(isset($params['from_date'])){
            $query->where(self::$main_table.'.sales_order_date', '>=', $params['from_date'].' 00:00:00');
        }

        if(isset($params['to_date'])){
            $query->where(self::$main_table.'.sales_order_date', '<=', $params['to_date'].' 23:59:59');
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.sales_order_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.phone', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_sales_order_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('sales_agents', self::$main_table.'.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('sales_invoice_types', self::$main_table.'.sales_order_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->where('sales_order_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                sales_order_m_id as m_id ,
                sales_order_date ,
                sales_order_description ,'.
                self::$main_table.'.sales_order_type_id ,
                sales_invoice_types.sales_invoice_type_title_'.$lang.' as type_title ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$lang.' as customer_name ,
                customers.phone as customer_phone ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$lang.' as sales_agent_name ,
                supply_order ,
                branch_id ,
                finance_year_id ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                discount ,
                items_count ,
                sales_order_status ,
                sales_order_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_sales_order_d($id, $lang = null)
    {
        $query = DB::table('sales_order_d')
            ->leftjoin('items', 'sales_order_d.item_id', '=', 'items.item_id')
            ->leftjoin('warehouses', 'sales_order_d.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements', 'sales_order_d.unit_id', '=', 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes', 'sales_order_d.tax_percent_id', '=', 'taxes.tax_id')
            ->where('sales_order_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                sales_order_m_id as m_id ,
                sales_order_d_id as d_id ,
                sales_order_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.image as item_image ,
                sales_order_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                sales_order_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                quantity ,
                price ,
                total_price ,
                tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                total_vat ,
                total_without_vat ,
                total_with_vat
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_sales_order_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_sales_order_d($seed)
    {
        return DB::table('sales_order_d')->insertGetId($seed);
    }

    public static function update_sales_order_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('sales_order_m_id', $id)->update($seed);
    }

    public static function update_sales_order_d($seed, $id)
    {
        return DB::table('sales_order_d')->where('sales_order_d_id', $id)->update($seed);
    }

    public static function delete_sales_order_m($id)
    {
        return DB::table(self::$main_table)->where('sales_order_m_id', $id)->update(array('sales_order_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_sales_order_d($id)
    {
        return DB::table('sales_order_d')->where('sales_order_d_id', $id)->delete();
    }
}
