<?php

namespace App\Models\Manufacturing;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Manufacturings extends Model
{
    protected $primaryKey     = 'manufacturing_m_id';
    public static $main_table = 'manufacturing_m';
    public $table             = 'manufacturing_m';

    public static $rules = array(

    );

    public static function all_manufacturing($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftJoin('work_orders_m', 'work_orders_m.order_m_id','manufacturing_m.order_m_id')
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id' , 'work_orders_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->groupBy(self::$main_table.'.manufacturing_m_id');

        if(isset($params['lang']))
            $query->selectRaw('
                manufacturing_m.manufacturing_m_id ,
                manufacturing_m.order_m_id ,
                manufacturing_m.action_date ,
                elevators_quotations.invoice_code as contract_number,
                customers.name_'.$params['lang'].' as customer_name,
                customers.phone ,
                customers.customer_id ,
                manufacturing_m.status ,
                manufacturing_m.active ,
                manufacturing_m.add_date ,
                manufacturing_m.add_user ,
                manufacturing_m.hold_date ,
                DATEDIFF(COALESCE(manufacturing_m.end_date, CURDATE()), manufacturing_m.action_date) as duration,
                manufacturing_m.end_date

            ');

        if(isset($params['active']))
            $query->where('manufacturing_m.active', $params['active']);

        if(isset($params['status']))
            $query->where('manufacturing_m.status', $params['status']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('customers.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('elevators_quotations.invoice_code' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.phone' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_manufacturing_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftJoin('work_orders_m', 'work_orders_m.order_m_id','manufacturing_m.order_m_id')
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id' , 'work_orders_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->where('manufacturing_m.manufacturing_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                manufacturing_m.manufacturing_m_id ,
                manufacturing_m.order_m_id ,
                manufacturing_m.action_date ,
                customers.name_'.$lang.' as customer_name,
                elevators_quotations.invoice_code as contract_number ,
                customers.phone ,
                customers.customer_id ,
                manufacturing_m.status ,
                manufacturing_m.active ,
                manufacturing_m.add_date ,
                manufacturing_m.add_user ,
                11 as duration ,
                manufacturing_m.hold_date ,
                manufacturing_m.end_date
            ');

        $data = $query->first();
        return $data;
    }

    public static function get_manufacturing_d($id, $lang = null)
    {
        $query = DB::table('manufacturing_d')
            ->leftJoin('warehouses', 'warehouses.warehouse_id','manufacturing_d.warehouse_id')
            ->leftJoin('unit_measurements', 'unit_measurements.unit_measurement_id','manufacturing_d.unit_id')
            ->leftJoin('items', 'items.item_id','manufacturing_d.item_id')
            ->where('manufacturing_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                manufacturing_d.manufacturing_d_id as d_id ,
                manufacturing_d.manufacturing_m_id as m_id,
                manufacturing_d.exchange_date ,
                manufacturing_d.item_id ,
                items.name_'.$lang.' as item_name ,
                manufacturing_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                manufacturing_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                manufacturing_d.quantity ,
                manufacturing_d.description

            ');

        $data = $query->get();
        return $data;
    }
    public static function get_attachments($id, $lang = null)
    {
        $query = DB::table('manufacturing_attachments')
            ->where('manufacturing_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                *
            ');

        $data = $query->get();
        return $data;
    }
    public static function delete_attachments($id, $lang = null)
    {
        return DB::table('manufacturing_attachments')->where('attachment_id', $id)->delete();

    }
    public static function add_manufacturing_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }
    public static function add_manufacturing_d($seed)
    {
        return DB::table('manufacturing_d')->insertGetId($seed);
    }
    public static function update_manufacturing($seed, $id)
    {
        return DB::table(self::$main_table)->where('manufacturing_m_id', $id)->update($seed);
    }

    public static function delete_manufacturing($id)
    {
        return DB::table(self::$main_table)->where('manufacturing_m_id', $id)->update( array('active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
