<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Title extends Model
{
    protected $primaryKey     = 'title_id';
    public static $main_table = 'title';
    public $table             = 'title';

    public static $rules = array(
        'title_name_en' => 'required|string',
        'title_name_ar' => 'required|string',
    );

    public static function all_titles($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.title_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                title_id as id ,
                title_name_'.$params['lang'].' as title_name ,
                title_name_en ,
                title_name_ar ,
                title_active ,
                add_date ,
                add_user
            ');

        if(isset($params['active']))
            $query->where('title_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.title_name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.title_name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_title($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('title_id', $id);

        $query->selectRaw('
            title_id as id ,
            title_name_'.$lang.' as title_name ,
            title_name_en ,
            title_name_ar ,
            title_active ,
            add_date ,
            add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function get_title_permission($id, $lang = null, $codes = null, $type = null)
    {
        $query = DB::table('title_permissions')
            ->join('screen_subs' , 'title_permissions.screen_sub_id' , '=' , 'screen_subs.screen_sub_id')
            ->join('screen_cats' , 'screen_subs.screen_cat_id' , '=' , 'screen_cats.screen_cat_id')
            ->join('screen_mains' , 'screen_cats.screen_main_id' , '=' , 'screen_mains.screen_main_id')
            ->orderBy('screen_mains.screen_main_order')
            ->orderBy('screen_cats.screen_cat_order')
            ->orderBy('screen_sub_order')
            ->where('screen_sub_active', 1)
            ->where('title_id', $id);

        if($lang != null){
            $query->selectRaw('
                screen_code ,
                permission ,
                url ,
                actions ,
                screen_cats.screen_cat_id as cat_id ,
                screen_cat_title_'.$lang.' as cat_title ,
                screen_subs.screen_sub_id as sub_id ,
                screen_sub_title_'.$lang.' as sub_title ,
                screen_mains.screen_main_id as main_id ,
                screen_main_title_'.$lang.' as main_title ,
                screen_main_image as main_image
            ');
        }elseif ($codes != null) {
            $query->selectRaw('screen_subs.screen_sub_id as id , screen_code , permission');
        }

        if ($type != null) {
            $query->whereRaw('FIND_IN_SET('.$type.' ,  stock_type )');
        }
        $data = $query->get();
        return $data;
    }

    public static function add_title($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_title($seed, $id)
    {
        return DB::table(self::$main_table)->where('title_id', $id )->update($seed);
    }

    public static function delete_title($id)
    {
        return DB::table(self::$main_table)->where('title_id', $id)->update(array('title_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
