<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Supplier extends Model
{

    protected $primaryKey = 'supplier_id';

    public static $main_table = 'suppliers';

    public static $rules = array(
        'name_en'      => 'required|string' ,
        'name_ar'      => 'required|string' ,
        'mobile'         => 'required|string' ,
        'address'=> 'required|string',
        'vat'      => 'required' ,
        'vat_register_number'      => 'required|numeric' ,
        'location'      => 'required' ,
        'delegate_id'      => 'required' ,
        'account_tree_id'      => 'required' ,
        'in_vat'      => 'required' ,
    );



    public static function all_suppliers($params = null)
    {
        $query =  DB::table(self::$main_table);

        if( isset($params['lang']) )
            $query->selectRaw('supplier_id as id , name_'.$params['lang'].' as name  , mobile , address , vat, vat_register_number , location , delegate_id , account_tree_id , in_vat');

        if(isset($params['active']))
            $query->where('supplier_active' , $params['active'] );


        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });

        }


        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_supplier($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('supplier_id' , $id);

        if($lang != null){
            $query->selectRaw('supplier_id as id , name_'.$lang.' as name  , mobile , address , vat, vat_register_number , location , delegate_id , account_tree_id , in_vat');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_supplier($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_supplier($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('supplier_id' , $id )->update($seed);
    }

    public static function delete_supplier($id)
    {
        return DB::table(self::$main_table)->where('supplier_id' , $id )->update( array('supplier_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
