<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Machine extends Model
{

    protected $primaryKey = 'machine_id';

    public static $main_table = 'machines';

    public static function active_machines($lang = null , $branch_id = null , $all = null)
    {
        $query = DB::table(self::$main_table);

        if($lang != null){
            $query->selectRaw('machine_id as id , name_'.$lang.' as name , bank_id , account_tree_id , branch_id , add_date');
        }

        if($branch_id != null){
            $query->where('branch_id' , $branch_id);
        }

        if($all == null){
            $query->where('machine_id' , '>' , 1);
        }

        $data = $query->get();
        return $data;
    }

    public static function get_machine($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('machine_id' , $id);

        if($lang != null){
            $query->selectRaw('machine_id as id , name_'.$lang.' as name , bank_id , account_tree_id , branch_id , add_date');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_machine($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_machine($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('machine_id' , $id )->update($seed);
    }

    public static function delete_machine($id)
    {
        return DB::table(self::$main_table)->where('machine_id' , $id )->update( array('machine_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    }
}
