<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class DaliyClose extends Model
{

    protected $primaryKey = 'daliy_close_id';

    public static $main_table = 'daliy_closes';

    public static function active_daliy_closes($lang = null , $branch_id = null , $rows = null)
    {
        $query = DB::table(self::$main_table)
            ->where('daliy_closes_active' , 1)
            ->orderBy('daliy_close_id' , 'desc');

        if($lang != null){
            $query->selectRaw('daliy_close_id as id , start_cash , total_cash , current_cash , diff_cash , branch_id , add_date');
        }

        if($branch_id != null){
            $query->where('branch_id' , $branch_id);
        }

        if($rows != null){
            $data = $query->paginate( $rows );
        }else{
            $data = $query->get();
        }
        return $data;
    }

    public static function get_daliy_close($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('branchs' , self::$main_table.'.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('finance_years' , self::$main_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->where('daliy_close_id' , $id);

        if($lang != null){
            $query->selectRaw(
                self::$main_table.'.daily_journal_id ,
                journal_code ,
                finance_years.finance_year_id , 
                finance_years.name as finance_year_name , 
                branchs.branch_id  , 
                branchs.name_'.$lang.' as branch_name ,
                daliy_close_id as id , 
                daily_close_code,'.
                self::$main_table.'.month_ser,'.
                self::$main_table.'.branch_ser,'.
                self::$main_table.'.gold_sales_cash,
                gold_sales_bank,
                gold_sales,
                gold_purchases_cash,
                gold_purchases_bank,
                gold_purchases,
                diamond_sales_cash,
                diamond_sales_bank,
                diamond_sales,
                diamond_purchases_cash,
                diamond_purchases_bank,
                diamond_purchases,
                used_purchases_cash,
                start_cash,
                start_bank,
                total_cash,
                total_bank,
                current_cash,
                current_bank,
                diff_cash,
                diff_bank,'.
                self::$main_table.'.add_date'
            );
        }
            
        $data = $query->first();
        return $data;
    }

    public static function get_next($id , $branch){
        return DB::table(self::$main_table)
            ->where('daliy_close_id' , '>' , $id)
            ->where('daliy_closes_active' , 1)
            ->where(self::$main_table.'.branch_id' , $branch )
            // ->where('confirmed' , 1)
            ->selectRaw('daliy_close_id as m_id')
            ->first();
    }

    public static function get_previous($id , $branch){
        return DB::table(self::$main_table)
            ->where('daliy_close_id' , '<' , $id)
            ->where('daliy_closes_active' , 1)
            ->where(self::$main_table.'.branch_id' , $branch )
            // ->where('confirmed' , 1)
            ->selectRaw('daliy_close_id as m_id')
            ->orderBy('daliy_close_id' , 'desc')
            ->first();
    }


    public static function get_last($branch){
        return DB::table(self::$main_table)
            ->where('daliy_closes_active' , 1)
            ->where(self::$main_table.'.branch_id' , $branch )
            ->selectRaw('daliy_close_id as m_id')
            ->orderBy('daliy_close_id' , 'desc')
            ->first();
    }


    public static function add_daliy_close($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_daliy_close($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('daliy_close_id' , $id )->update($seed);
    }

    public static function delete_daliy_close($id)
    {
        return DB::table(self::$main_table)->where('daliy_close_id' , $id )->update( array('daliy_closes_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}
