<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class StockInitialBalance extends Model
{
    protected $primaryKey     = 'stock_initial_balance_m_id';
    public static $main_table = 'stock_initial_balance_m';
    public $table             = 'stock_initial_balance_m';

    public static $master_rules = array(
        'stock_initial_balance_date'        => 'required|date',
        'stock_initial_balance_description' => 'required',
        'warehouse_id'                      => 'required|numeric|unique:stock_initial_balance_m',
        'branch_id'                         => 'required|numeric',
        'finance_year_id'                   => 'required|numeric',
        'year_ser'                          => 'required|numeric',
        'month_ser'                         => 'required|numeric',
        'branch_ser'                        => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'  => 'required|numeric',
        'unit_id'  => 'required|numeric',
        'quantity' => 'required|numeric',
        'price'    => 'required',
    );

    public static function all_stock_initial_balances($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftJoin('warehouses',self::$main_table.'.warehouse_id','warehouses.warehouse_id')
            ->orderBy(self::$main_table.'.stock_initial_balance_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                stock_initial_balance_m.stock_initial_balance_m_id as m_id ,
                stock_initial_balance_m.stock_initial_balance_date ,
                stock_initial_balance_m.stock_initial_balance_description ,
                warehouses.warehouse_id ,
                warehouses.name_'.$params['lang'].' as warehouse_name,
                stock_initial_balance_m.branch_id ,
                stock_initial_balance_m.finance_year_id ,
                stock_initial_balance_m.stock_initial_balance_status ,
                stock_initial_balance_m.stock_initial_balance_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        if(isset($params['active']))
            $query->where('stock_initial_balance_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('stock_initial_balance_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('users.username', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_stock_initial_balance_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->where('stock_initial_balance_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
                stock_initial_balance_m_id as m_id ,
                stock_initial_balance_date ,
                stock_initial_balance_description ,
                warehouse_id ,
                branch_id ,
                finance_year_id ,
                stock_initial_balance_status ,
                stock_initial_balance_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_stock_initial_balance_d($id, $lang = null)
    {
        $query = DB::table('stock_initial_balance_d')
            ->where('stock_initial_balance_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stock_initial_balance_m_id as m_id ,
                stock_initial_balance_d_id as d_id ,
                item_id ,
                unit_id ,
                quantity ,
                price ,
                total_price ,
                add_date ,
                add_user
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_stock_initial_balance_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_stock_initial_balance_d($seed)
    {
        return DB::table('stock_initial_balance_d')->insertGetId($seed);
    }

    public static function update_stock_initial_balance_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('stock_initial_balance_m_id', $id)->update($seed);
    }
    public static function update_stock_initial_balance_d($seed, $id)
    {
        return DB::table('stock_initial_balance_d')->where('stock_initial_balance_d_id', $id)->update($seed);
    }

    public static function delete_stock_initial_balance_m($id)
    {
        return DB::table(self::$main_table)->where('stock_initial_balance_m_id', $id)->update(array('stock_initial_balance_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_stock_initial_balance_d($id)
    {
        return DB::table('stock_initial_balance_d')->where('stock_initial_balance_m_id', $id)->delete();
    }
}
