<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ItemType extends Model
{
    protected $primaryKey     = 'item_type_id';
    public static $main_table = 'item_types';
    public $table             = 'item_types';

    public static $rules = array(
        'name_en' => 'required|string|unique:item_types',
        'name_ar' => 'required|string|unique:item_types',
    );

    public static function all_item_types($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.item_type_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                item_type_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.item_type_status,'.
                self::$main_table.'.item_type_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('item_type_active' , $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_item_type($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('item_type_id' , $id);

        if($lang != null)
            $query->selectRaw('
                item_type_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.item_type_status,'.
                self::$main_table.'.item_type_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        $data = $query->first();

        return $data;
    }

    public static function add_item_type($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_item_type($seed, $id)
    {
        return DB::table(self::$main_table)->where('item_type_id', $id)->update($seed);
    }

    public static function delete_item_type($id)
    {
        return DB::table(self::$main_table)->where('item_type_id', $id )->update(array('item_type_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
