<?php

namespace App\Models\FinancialStatements;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class FinancialStatements extends Model
{
    protected $primaryKey = 'statement_id';

    public static $main_table = 'financial_statements';

    public static $rules = array(
        'name_en' => 'required|string|min:3|unique:financial_statements',
        'name_ar' => 'required|string|min:3|unique:financial_statements',
    );

    public static function financial_statements($params = null)
    {
        $query =  DB::table(self::$main_table)
        ->orderby('statement_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                statement_id as id  ,
                name_'.$params['lang'].' as name ,
                name_ar ,
                name_en,
                add_user,
                add_date,
                active
            ');
        }

        if(isset($params['active']))
            $query->where('active' , $params['active']);

        if(isset($params['lookup']))
            $query->selectRaw('statement_id as id, name_'.$params['lang'].' as name ');

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_en' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_financial_statement($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('statement_id' , $id);

        if($lang != null){
            $query->selectRaw('
                statement_id as id  ,
                name_'.$lang.' as name ,
                name_ar ,
                name_en,
                add_user,
                add_date,
                active
            ');
        }

        $data = $query->first();
        return $data;

    }
    public static function get_report($params = null)
    {
        // $years = array('2020','2021','2022','2023');
        // $months = array('1','2','3','4','5','6','7','8','9','10','11','12');
        // $result = DB::select('CALL get_financial_data(?, ?)', [$params['statement_id'], $params['lang']]);

        // // Process the result
        // foreach ($result as $row) {
        //     // Access the fields using $row->field_name
        //     $collectionId = $row->collection_id;
        //     $statementId = $row->statement_id;
        //     $name = $row->name;
        //     $factor = $row->factor;
        //     $parentId = $row->parent_id;
        //     $type = $row->type;

        //     // ... Process the data as needed ...
        // }
        // return $result;
        $query = DB::table('financial_collections')
            ->leftjoin('financial_statements','financial_statements.statement_id','financial_collections.statement_id')
            ->leftjoin('daily_journal_d','daily_journal_d.account_tree_id','financial_collections.account_id')
            ->leftjoin('daily_journal_m','daily_journal_d.daily_journal_m_id','daily_journal_m.daily_journal_m_id')
            ->leftjoin('account_tree','account_tree.account_tree_id','financial_collections.account_id')
            ->where('financial_collections.type',2)
            ->where('financial_collections.statement_id',$params['statement_id'])
            // ->where('daily_journal_m.branch_id',$params['branch_id'])
            ->whereIn(DB::raw('YEAR(daily_journal_m.journal_date)'),$params['years'])
            ->whereIn(DB::raw('MONTH(daily_journal_m.journal_date)'),$params['months'])
            ->where('financial_statements.active' , 1)
            ->orderBy('financial_collections.collection_id','desc');
            if($params['lang'] != null){
                $query->selectRaw('
                    financial_collections.collection_id,
                    financial_collections.statement_id,
                    YEAR(daily_journal_m.journal_date) as year,
                    MONTH(daily_journal_m.journal_date) as month,
                    financial_collections.name_'.$params['lang'].' as name ,
                    financial_collections.factor,
                    daily_journal_m.branch_id,
                    financial_collections.parent_id,
                    account_tree.name_'.$params['lang'].' as account_name ,
                    ((SUM(daily_journal_d.debit)) - (SUM(daily_journal_d.credit))) as amount,
                    financial_collections.type
                    ');
            }
        $data = $query->get()->groupby(['year','month']);

        return $data;

    }

    public static function add_financial_statement($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_financial_statement($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('statement_id' , $id )->update($seed);
    }

    public static function delete_financial_statement($id)
    {
        return DB::table(self::$main_table)->where('statement_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    }




}
