<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class Receipt extends Model
{

    protected $primaryKey = 'id';

    public static $main_table = 'receipt';
    

    public static $rules = array(
        'user_id' => 'required|numeric',
        'delegate_id' => 'required|numeric',
        'value' => 'required',
        'description' => 'required|string|min:3',
        'date' => 'required',
    );

    public static function active_receipt($lang = null , $params = null)
    {
        $query =  DB::table(self::$main_table);

        if($lang != null){
            $query->selectRaw('
            id  , 
            annual_serial ,
            monthly_serial , 
            branch_serial ,
            book_serial ,
            date ,
            from_type ,
            user_id ,
            delegate_id , 
            value , 
            description , 
            advance_payment ,
            cost_center_id ,
            cost_center ,
            collection_method ,
            bank_id 
            ');
        }

        if(isset($params['active']))
            $query->where('active' , $params['active']);
        
        $data = $query->get();
    return $data;
    }

    public static function get_receipt($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('id' , $id);

        if($lang != null){
            $query->selectRaw('
            id  , 
            annual_serial ,
            monthly_serial , 
            branch_serial ,
            book_serial ,
            date ,
            from_type ,
            user_id ,
            delegate_id , 
            value , 
            description , 
            advance_payment ,
            cost_center_id ,
            cost_center ,
            collection_method ,
            bank_id 
            ');
        }
        
        $data = $query->first();
        return $data;

    }

    public static function add_receipt($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_receipt($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->update($seed);
    }

    public static function delete_receipt($id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->delete();
    }

    public static function count_annual($id)
    {
        return DB::table(self::$main_table)->where('annual_serial' , 'like', $id. '%' )->count();
    }
}
