<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class PaymentVoucher extends Model
{

    protected $primaryKey       = 'payment_voucher_id';
    public static $main_table   = 'payment_vouchers';
    public $table               = 'payment_vouchers';


    public static $rules = array(
        'branch_id'         => 'required|numeric' ,
        'finance_year_id'   => 'required|numeric' ,
        'from_type'         => 'required|numeric' ,
        'to_type'           => 'required|numeric' ,
        'amount'            => 'required|numeric',
        'description'       => 'required|string',
        'action_date'       => 'required|date',
    );

    public static function all_payment_voucher( $params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->orderBy('payment_voucher_id' , 'desc');

        if($params['lang'] != null){
            $query
                ->leftjoin('account_tree as account_tree_to' ,  'payment_vouchers.to_account_tree_id' , '=' , 'account_tree_to.account_tree_id')
                ->leftjoin('purchases_vendors' ,  'payment_vouchers.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
                ->leftjoin('customers' ,  'payment_vouchers.to_customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('account_tree as account_tree_from' ,  'payment_vouchers.from_account_tree_id' , '=' , 'account_tree_from.account_tree_id')
                ->leftjoin('treasurys' ,  'payment_vouchers.from_treasury_id' , '=' , 'treasurys.treasury_id')
                ->leftjoin('banks' ,  'payment_vouchers.from_bank_id' , '=' , 'banks.bank_id')
                ->selectRaw('
                    payment_voucher_id as id  ,
                    payment_vouchers.year_ser ,
                    payment_vouchers.month_ser ,
                    payment_vouchers.branch_ser ,
                    payment_vouchers.action_date ,
                    payment_vouchers.daily_journal_id ,
                    daily_journal_m.year_ser as journal_code ,
                    payment_vouchers.cost_center_id ,
                    payment_vouchers.delegate_id ,
                    payment_vouchers.amount ,
                    payment_vouchers.invoice_type ,
                    payment_vouchers.description ,

                    to_type ,
                    to_account_tree_id ,
                    to_supplier_id ,
                    to_customer_id ,

                    CASE
                        WHEN to_type = 1 THEN account_tree_to.name_'.$params['lang'].'
                        WHEN to_type = 2 THEN purchases_vendors.name_'.$params['lang'].'
                        WHEN to_type = 3 THEN customers.name_'.$params['lang'].'
                        ELSE ""
                    END as to_type_name ,

                    from_type ,
                    from_account_tree_id ,
                    from_treasury_id ,
                    from_bank_id ,

                    CASE
                        WHEN from_type = 1 THEN account_tree_from.name_'.$params['lang'].'
                        WHEN from_type = 2 THEN treasurys.treasury_name_'.$params['lang'].'
                        WHEN from_type = 3 THEN banks.name_'.$params['lang'].'
                        WHEN from_type = 4 THEN cheque_number
                        ELSE ""
                    END as payment_type ,

                    due_date ,
                    cheque_number ,
                    expense_code_id ,
                    pay_for ,

                    purchases_agent_id ,
                    payment_vouchers.sales_agent_id

                ');
        }


        if(isset($params['active']))
            $query->where('payment_voucher_active' , $params['active'] );

        if(isset($params['branch'])){
            $query->where('payment_vouchers.branch_id' , $params['branch']);
        }

        if(isset($params['finance_year'])){
            $query->where('payment_vouchers.finance_year_id' , $params['finance_year']);
        }

        if(isset($params['from_date'])){
            $query->where('payment_vouchers.action_date', '>=', $params['from_date'].' 00:00:00');
        }

        if(isset($params['to_date'])){
            $query->where('payment_vouchers.action_date', '<=', $params['to_date'].' 23:59:59');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('payment_vouchers.description' , 'LIKE' , "%".$params['word']."%")
                ->orWhere('pay_for' , 'LIKE' , "%".$params['word']."%")
                ->orWhere('account_tree_from.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('treasurys.treasury_name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('banks.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('account_tree_to.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('purchases_vendors.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('customers.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%");
            });

        }


        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }


    return $data;
    }

    public static function get_payment_voucher($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('expense_codes' , 'payment_vouchers.expense_code_id' , '=' , 'expense_codes.expense_code_id')
            ->leftjoin('users' , 'payment_vouchers.add_user' , '=' , 'users.id')
            ->where('payment_voucher_id' , $id);

        if($lang != null){
            $query
                ->leftjoin('account_tree as account_tree_to' ,  'payment_vouchers.to_account_tree_id' , '=' , 'account_tree_to.account_tree_id')
                ->leftjoin('purchases_vendors' ,  'payment_vouchers.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
                ->leftjoin('customers' ,  'payment_vouchers.to_customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('account_tree as account_tree_from' ,  'payment_vouchers.from_account_tree_id' , '=' , 'account_tree_from.account_tree_id')
                ->leftjoin('treasurys' ,  'payment_vouchers.from_treasury_id' , '=' , 'treasurys.treasury_id')
                ->leftjoin('banks' ,  'payment_vouchers.from_bank_id' , '=' , 'banks.bank_id')
                ->selectRaw('
                    payment_voucher_id as id  ,
                    finance_year_id ,
                    branch_id ,
                    year_ser ,
                    month_ser ,
                    branch_ser ,
                    action_date ,
                    daily_journal_id ,
                    payment_vouchers.cost_center_id ,
                    delegate_id ,
                    amount ,
                    invoice_type ,
                    description ,
                    payment_voucher_active as active ,
                    to_type ,
                    to_account_tree_id ,
                    account_tree_to.name_'.$lang.' as account_tree_to_name ,
                    to_supplier_id ,
                    purchases_vendors.purchases_vendor_id ,
                    purchases_vendors.name_'.$lang.' as purchases_vendors_name ,
                    to_customer_id ,
                    customers.name_'.$lang.' as customer_name ,

                    from_type ,
                    from_account_tree_id ,
                    account_tree_from.name_'.$lang.' as account_tree_from_name ,
                    from_treasury_id ,
                    treasurys.treasury_name_'.$lang.' as treasury_name ,
                    from_bank_id ,
                    banks.name_'.$lang.' as bank_name ,

                    due_date ,
                    cheque_number ,
                    expense_codes.expense_code_id ,
                    expense_codes.name_'.$lang.' as  expense_name ,
                    expense_codes.account_tree_id as expense_code_account_tree_id ,

                    users.user_full_name ,
                    pay_for ,

                    purchases_agent_id ,
                    payment_vouchers.sales_agent_id ,


                    payment_vouchers.add_date ,
                    payment_vouchers.add_user
                ');
        }

        $data = $query->first();
        return $data;

    }


    public static function get_attachs($id)
    {
        return DB::table('payment_voucher_attachments')
            ->where('payment_voucher_id' , $id)
            ->selectRaw('
                attachment_id as id ,
                payment_voucher_id ,
                file_name ,
                file_path ,
                file_ext ,
                add_date ,
                add_user
        ')->get();
    }


    public static function add_payment_voucher($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_payment_voucher($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('payment_voucher_id' , $id )->update($seed);
    }

    public static function delete_payment_voucher($id)
    {
        return DB::table(self::$main_table)->where('payment_voucher_id' , $id )->update( array('payment_voucher_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

    public static function count_annual($id)
    {
    }
}
