<?php

namespace App\Models\Elevators;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ElevatorTypes extends Model
{
    protected $primaryKey     = 'type_id';
    public static $main_table = 'elevators_types';
    public $table             = 'elevators_types';

    public static $master_rules = array(
        'name_en' => 'required|string|unique:elevators_types',
        'name_ar' => 'required|string|unique:elevators_types',
    );

    public static function all_types($params = null)
    {
        $query = DB::table(self::$main_table)

            ->orderBy(self::$main_table.'.type_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                type_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.disable_date ,'.
                self::$main_table.'.disable_user ,'.
                self::$main_table.'.active
            ');
        }

        if(isset($params['active']))
            $query->where('active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_type($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('type_id', $id);

        if($lang != null){
            $query->selectRaw('
                type_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.disable_date ,'.
                self::$main_table.'.disable_user ,'.
                self::$main_table.'.active
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_type_lookup($lang = null)
    {
        $query = DB::table('elevators_types')
        ->where('active' , 1 )
        ->orderBy('type_id', 'desc');

        if($lang != null){
            $query->selectRaw('type_id as id ,name_ar,name_en, name_'.$lang.' as name ');
        }

        $data = $query->get();

        return $data;
    }

    public static function add_type($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_type($seed, $id)
    {
        return DB::table(self::$main_table)->where('type_id', $id)->update($seed);
    }

    public static function delete_type($id)
    {
        return DB::table(self::$main_table)->where('type_id', $id)->update(array('active' => '0'));
    }

}
