<?php

namespace App\Models\Elevators;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ElevatorModels extends Model
{
    protected $primaryKey     = 'model_m_id';
    public static $main_table = 'elevators_models_m';
    public $table             = 'elevators_models_m';

    public static $master_rules = array(
        'name_en' => 'required|string',
        'name_ar' => 'required|string',
    );

    public static $details_rules = array(
        'model_m_id'        => 'required|numeric',
        'item_name'         => 'required|string',
        'description'       => 'required|string',
    );

    public static function all_models($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_types','elevators_types.type_id' , 'elevators_models_m.elevator_type_id')
            ->orderBy(self::$main_table.'.model_m_id', 'asc');

        if($params['lang'] != null){
            $query->selectRaw('
                model_m_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.elevator_type_id ,
                elevators_types.name_'.$params['lang'].' as type_name,'.
                self::$main_table.'.active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }


        if(isset($params['active']))
            $query->where('elevators_models_m.active', $params['active']);

        if(isset($params['type_id']))
            $query->where('elevators_models_m.elevator_type_id', $params['type_id']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
            foreach($data as $item){
                $item->items = DB::table('elevators_models_d')->where('model_m_id',$item->id)
                ->selectRaw('
                    model_m_id as m_id ,
                    model_d_id as d_id ,
                    item_name ,
                    description
                ')->get()->toArray();
            }

        return $data;
    }

    public static function get_model_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_types','elevators_types.type_id' , 'elevators_models_m.elevator_type_id')
            ->where('model_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                model_m_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.elevator_type_id ,
                elevators_types.name_'.$lang.' as type_name,'.
                self::$main_table.'.active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_model_d($id, $lang = null)
    {
        $query = DB::table('elevators_models_d')
            ->where('model_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                model_m_id as m_id ,
                model_d_id as d_id ,
                item_name ,
                description
            ');
        }

        $data = $query->get();
        return $data;
    }
    public static function get_model_lookup($lang = null, $type  = null)
    {
        $query = DB::table('elevators_models_m')
        ->where('active' , 1 )
        ->orderBy('model_m_id', 'asc');

        if($lang != null){
            $query->selectRaw('model_m_id as id ,name_ar,name_en, name_'.$lang.' as name ');
        }
        if(isset($type)){
            $query->where('elevator_type_id' , $type);
        }
        $data = $query->get();
        foreach($data as $item){
            $item->items = DB::table('elevators_models_d')->where('model_m_id',$item->id)
            ->selectRaw('model_m_id as m_id ,
            model_d_id as d_id ,
            item_name ,
            description')->get()->toArray();
        }

        return $data;
    }

    public static function add_model_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_model_d($seed)
    {
        return DB::table('elevators_models_d')->insertGetId($seed);
    }

    public static function update_model_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('model_m_id', $id)->update($seed);
    }

    public static function delete_model_m($id)
    {
        return DB::table(self::$main_table)->where('model_m_id', $id)->update(array('active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_model_d($id)
    {
        return DB::table('elevators_models_d')->where('model_m_id', $id)->delete();
    }
}
