<?php

namespace App\Models\Contracts;

use Illuminate\Database\Eloquent\Model;
use DB;

class ContractType extends Model
{
    protected $primaryKey       = 'contract_type_id';
    public static $main_table   = 'contract_types';
    public $table               = 'contract_types';

    public static $rules = array(
        'name_en' => 'required|string',
        'name_ar' => 'required|string',
    );

    public static function all_contract_types($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->orderBy(self::$main_table.'.contract_type_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                contract_type_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.contract_type_active,'.
                self::$main_table.'.add_date,
                user_full_name as added_by , '.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('contract_type_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_contract_type($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->where('contract_type_id' , $id);

        if($lang != null)
            $query->selectRaw('
                contract_type_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.contract_type_active,'.
                self::$main_table.'.add_date,
                user_full_name as added_by , '.
                self::$main_table.'.add_user
            ');

        $data = $query->first();

        return $data;
    }

    public static function add_contract_type($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_contract_type($seed, $id)
    {
        return DB::table(self::$main_table)->where('contract_type_id', $id)->update($seed);
    }

    public static function delete_contract_type($id)
    {
        return DB::table(self::$main_table)->where('contract_type_id', $id )->update(array('contract_type_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
