<?php

namespace App\Models\Barbers;

use Illuminate\Database\Eloquent\Model;
use DB;

class BarberVacation extends Model
{
    protected $primaryKey     = 'barber_vacation_id';
    public static $main_table = 'barber_vacations';
    public $table             = 'barber_vacations';

    public static $rules = array(
        'barber_id' => 'required|numeric',
        'from_date' => 'required|date',
        'to_date'   => 'required|date',
    );

    public static function all_barber_vacations($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->orderBy(self::$main_table.'.barber_vacation_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                barber_vacation_id as id ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$params['lang'].' as barber_name ,
                barber_m.image as barber_image ,'.
                self::$main_table.'.from_date ,'.
                self::$main_table.'.to_date ,'.
                self::$main_table.'.days_count ,'.
                self::$main_table.'.barber_vacation_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active']))
            $query->where('barber_vacation_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('barber_m.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('barber_m.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_barber_vacation($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->where('barber_vacation_id', $id);

        if($lang != null){
            $query->selectRaw('
                barber_vacation_id as id ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$lang.' as barber_name ,
                barber_m.image as barber_image ,'.
                self::$main_table.'.from_date ,'.
                self::$main_table.'.to_date ,'.
                self::$main_table.'.days_count ,'.
                self::$main_table.'.barber_vacation_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_barber_vacation($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_barber_vacation($seed, $id)
    {
        return DB::table(self::$main_table)->where('barber_vacation_id', $id)->update($seed);
    }

    public static function delete_barber_vacation($id)
    {
        return DB::table(self::$main_table)->where('barber_vacation_id', $id)->update(array('barber_vacation_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
