<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AssetsDevelop extends Model
{
    protected $primaryKey = 'assets_develop_id';

    public static $main_table = 'assets_develop';

    public static $rules = array(

    );

    public static function all_assets_develop($params = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_develop.asset_m_id')
        ->orderBy('assets_develop_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                assets_develop_id as id  ,
                assets_m.name_'.$params['lang'].' as name ,
                assets_m.asset_code ,
                assets_develop.asset_m_id ,
                assets_develop.doc_date,
                assets_develop.price,
                assets_develop.value_added,
                assets_develop.payment_method,
                assets_develop.account_number,
                assets_develop.doc_number,
                assets_develop.notes,
                assets_develop.add_user ,
                assets_develop.add_date
            ');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('assets_m.name_'.$params['lang'] , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('assets_m.asset_code' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_develop($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_develop.asset_m_id')
        ->where('assets_develop_id',$id);

        if($lang != null){
            $query->selectRaw('
                assets_develop.assets_develop_id as id  ,
                assets_m.name_'.$lang.' as name ,
                assets_m.asset_code ,
                assets_develop.asset_m_id ,
                assets_develop.doc_date,
                assets_develop.price,
                assets_develop.value_added,
                assets_develop.payment_method,
                assets_develop.account_number,
                assets_develop.doc_number,
                assets_develop.notes,
                assets_develop.add_user ,
                assets_develop.add_date
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function get_assets_develop_attachments($lang,$m_id){
        $query =  DB::table('assets_develop_attachments')
            ->where('assets_develop_id' , $m_id);

        if($lang != null){
            $query->selectRaw('
                assets_develop_attachments.attachment_id as id ,
                assets_develop_attachments.assets_develop_id,
                assets_develop_attachments.file_name ,
                assets_develop_attachments.file_url as file_path ,
                assets_develop_attachments.add_user ,
                assets_develop_attachments.add_date
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_assets_develop($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_develop_attachments($seed)
    {
        return DB::table('assets_develop_attachments')->insertGetId($seed);
    }
    public static function delete_develop_attachments($id)
    {
        return DB::table('assets_develop_attachments')->where('attachment_id' , $id)->delete();
    }

    public static function update_assets_develop($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('assets_develop_id' , $id )->update($seed);
    }

}
