<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    public $view;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data , $view)
    {
        $this->data = $data;
        $this->view = $view;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // Get the PDF file contents from the URL
        return $this->view($this->view,['data'=>$this->data])->subject('Purchase Order');
    }
}
