<?php

namespace App\Http\Middleware;

use App\Classes\General\ClientIDCheck;
use Closure;



class ClientIDFilter {

    protected $excepts = [
        'login'
    ];

    public function handle($request, Closure $next)
    {
        $check = ( new ClientIDCheck )->check( $request );

        if($request->wantsJson() && !$check)
            return response()->json(['msg' => 'Client ID not found.'.$check ], 403);
        elseif( !in_array( $request->segment(1) , $this->excepts)  && !$check)
            return redirect()->to('login')->withErrors('Client ID not found');
        else
            return $next($request);
    }
}
?>
