<?php

namespace App\Http\Controllers\API\Website\Frontend;

use App\Classes\General\Upload;
use App\Classes\RealTime\NotificationHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Main\Setting;
use App\Models\Sales\Customer;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class GeneralController extends BaseController
{
    protected $return = array();

    public function get_user_profile($lang, $customer_id = null)
    {
        $customer = DB::table('customers')->where('customer_id', $customer_id ?? auth('customer')->user()->customer_id)->first();
        $nameColumn = 'name_' . $lang;

        $data['user_id']     = $customer->customer_id;
        $data['api_token']   = $customer->api_token;
        $data['first_name']  = $customer->$nameColumn;
        $data['last_name']   = $customer->$nameColumn;
        $data['full_name']   = $customer->$nameColumn;
        $data['username']    = $customer->phone;
        $data['email']       = $customer->email;
        $data['mobile']      = $customer->phone;
        $data['title']       = $customer->job_title ?? '';
        $data['image']       = $customer->image_url ?? '';
        $data['user_active'] = $customer->customer_active; 
        $data['wallet_points']  = $customer->wallet_points;
        $data['gift_total_invoices'] = DB::table('customers')->where('customer_id', $customer_id ?? auth('customer')->user()->customer_id)->first()->gift_total_invoices ?? 0;
        $data['invoices_needed_for_gift'] = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;

        return $data;
    }
    public function get_my_profile($lang, $customer_id = null)
    {
        $customer = DB::table('customers')->where('customer_id', $customer_id ?? auth('customer')->user()->customer_id)->first();
        $nameColumn = 'name_' . $lang;
        $disscount_points_per_one   = boolval(Setting::get_main_setting_by_code('disscount_points_per_one')->value ?? 0);
                
        $data['user_id']        = $customer->customer_id;
        $data['api_token']      = $customer->api_token;
        $data['first_name']     = $customer->$nameColumn;
        $data['last_name']      = $customer->$nameColumn;
        $data['full_name']      = $customer->$nameColumn; 
        $data['username']       = $customer->phone;
        $data['email']          = $customer->email;
        $data['mobile']         = $customer->phone;
        $data['title']          = $customer->job_title ?? '';
        $data['image']          = $customer->image_url ?? '';
        $data['user_active']    = $customer->customer_active;
        $data['wallet_points']  = $customer->wallet_points;
        $data['gift_total_invoices'] = DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->first()->gift_total_invoices ?? 0;
        $data['invoices_needed_for_gift'] = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;

        return $this->sendResponse($data, '');
    }

    public function update_profile($lang, Request $request)
    {
        $inputs = $request->only(['first_name', 'last_name', 'email', 'mobile']);
        $update = [
            'name_en' => $inputs['first_name'] . ' ' . $inputs['last_name'],
            'name_ar' => $inputs['first_name'] . ' ' . $inputs['last_name'],
            'email' => $inputs['email'],
            'phone' => $inputs['mobile'],
        ];
        $user = Customer::find(auth('customer')->user()->customer_id);

        // check if provided email already exists
        if ($request->filled('email')) {
            $emailExists = Customer::where('email', $inputs['email'])->where('customer_id', '!=', $user->customer_id)->exists();

            if ($emailExists) {
                return $this->sendError(trans('error.Email Already Exists'));
            }
            //validate email
            if (!filter_var($inputs['email'], FILTER_VALIDATE_EMAIL)) {
                return $this->sendError(trans('error.Invalid Email'));
            }
            $update['email'] = $inputs['email'];
        }


        // if (isset($request['password']) && !is_null($request['password'])) {
        //     if (strlen($request['password']) < 1) {
        //         return $this->sendError(trans('error.Password Must Bigger Than Or Equal 1 Numbers'));
        //     }

        //     if ($request['password'] !== $request['confirm_password']) {
        //         return $this->sendError('error.Password and Confirm Password Does Not Match');
        //     }

        //     $update['password'] = Hash::make($request['password']);
        // } else {
        //     $update['password'] = $user->password;
        // }

        // if (isset($request['full_name'])) {
        //     $update['full_name_en'] = $request['full_name'];
        //     $update['full_name_ar'] = $request['full_name'];
        // }

        if (isset($request['image']) && strlen($request['image']) > 0) {
            if (!is_null($user->image_url) && file_exists(public_path() . $user->image_url)) {
                unlink(public_path() . $user->image_url);
            }

            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['image'], 'users_images');
            if (!$check['check'])
                return $this->sendError(trans('error.Error In User Image'), $check['msg']);
            else
                $update['image_url'] = $check['url'];
        }

        if (count($update) > 0) {
            Customer::update_customer($update, $user->customer_id);
        }

        return $this->sendResponse($this->get_my_profile($lang), trans('main.update_success'));
    }
    public function get_available_times($booking_date, $barber_id, $services, $lang, $is_start = false)
    {

        $services       = DB::table('items')->whereIn('item_id', $services)->get();
        $chairs_number  = 1;
        $needed_blocks  = collect($services)->sum('time_blocks') / 5;


        // Check Barbers Vacation
        $barber_in_vacation_count = DB::table('barber_vacations')
            ->where('barber_id', $barber_id)
            ->whereDate('from_date', '>=', $booking_date)
            ->whereDate('to_date', '<=', $booking_date)
            ->count();

        if ($barber_in_vacation_count > 0) {
            return [];
        }
        // $barber = DB::table('barber_m')
        //     ->where('barber_active' , 1 )
        //     ->select('barber_m_id as id', 'name_'.$lang.' as name', 'image' )
        //     ->where('barber_m_id', $barber_id)
        //     ->orderBy('barber_m.barber_m_id', 'desc')
        //     ->first();

        // Get Barber Day Times
        $day_name = date('l', strtotime($booking_date));

        $barber_work_times = DB::table('barber_d')
            ->select('barber_d_id', 'beginning_work', 'end_work', 'is_day_off')
            ->where('barber_m_id', $barber_id)
            ->where('day_name_en', $day_name)
            ->get();

        if (!isset($barber_work_times[0]) || $barber_work_times[0]->is_day_off == 1) {
            return [];
        }



        // Check If Day is Off Or Not and Get Day Times
        $checkDateWorkTime = DB::table('barber_shop_times')->where('day_name_en', $day_name)->first();
        $this->return['is_day_off'] = ($checkDateWorkTime->is_day_off == 1) ? true : false;

        // Return Times Based On Day Times
        $beginning_work = $checkDateWorkTime->beginning_work;
        $end_work       = $checkDateWorkTime->end_work;
        $current_time   = $checkDateWorkTime->beginning_work;
        if ($booking_date == date("Y-m-d")) {
            $current_time = date("H:i:s", strtotime("+20 minutes"));
        }

        $aval_times = [];
        $times          = DB::table('b_times')
            ->where('time_title', '>=', $beginning_work)
            ->where('time_title', '<=', $end_work)
            ->where('time_title', '>=', $current_time);

        $times->where(function ($where) use ($barber_work_times) {
            foreach ($barber_work_times as $item) {
                if ($item->is_day_off == 1) {
                    continue;
                }
                $where->orWhere(function ($where2) use ($item) {
                    $where2->where('time_title', '>=', $item->beginning_work)
                        ->where('time_title', '<=', $item->end_work);
                });
            }
        });

        $times = $times->get();

        $bookings       = DB::table('barber_bookings')
            ->where('barber_booking_date', $booking_date)
            ->where('barber_id', $barber_id)
            ->where('barber_booking_status', 1)
            ->where('barber_booking_active', 1)
            ->get();

        if (count($bookings) > 0) {
            foreach ($times as $key => $value) {
                $bookingsCount = DB::table('barber_bookings')
                    ->where('barber_booking_date', $booking_date)
                    ->where('barber_id', $barber_id)
                    ->where('barber_booking_status', 1)
                    ->where('barber_booking_active', 1)
                    ->whereRaw('find_in_set(' . $value->time_id . ', time_blocks_ids)')
                    ->count();
                if ($bookingsCount >= $chairs_number) {
                    unset($times[$key]);
                    if ($is_start) {
                        for ($i = 1; $i < $needed_blocks; $i++) {
                            unset($times[$key - $i]);
                        }
                    }
                }
            }
            $times = collect($times)->toArray();
            $times = array_values($times);
        }

        return $times;
    }
    public function send_notification_to_all($lang, Request $request)
    {

        $this->return['notifications'] = (new NotificationHelper('the_concept'))->sendNotification($request['body']);

        return $this->sendResponse($this->return);
    }
}
