<?php

namespace App\Http\Controllers\API\Website\Frontend\Booking;


class FcmController
{

    // This function is needed, because php doesn't have support for base64UrlEncoded strings
    public function base64UrlEncode($text)
    {
        return str_replace(
            ['+', '/', '='],
            ['-', '_', ''],
            base64_encode($text)
        );
    }
    
    public function getToken()
    {
        // Read service account details
        $authConfigString = file_get_contents(base_path() . '/the_concept.json');

        // Parse service account details
        $authConfig = json_decode($authConfigString);

        // Read private key from service account details
        $secret = openssl_get_privatekey($authConfig->private_key);

        // Create the token header
        $header = json_encode([
            'typ' => 'JWT',
            'alg' => 'RS256'
        ]);

        // Get seconds since 1 January 1970
        $time = time();

        // Allow 1 minute time deviation between client en server (not sure if this is necessary)
        $start = $time - 60;
        $end = $start + 3600;

        // Create payload
        $payload = json_encode([
            "iss" => $authConfig->client_email,
            "scope" => "https://www.googleapis.com/auth/firebase.messaging",
            "aud" => "https://oauth2.googleapis.com/token",
            "exp" => $end,
            "iat" => $start
        ]);

        // Encode Header
        $base64UrlHeader = $this->base64UrlEncode($header);

        // Encode Payload
        $base64UrlPayload = $this->base64UrlEncode($payload);

        // Create Signature Hash
        $result = openssl_sign($base64UrlHeader . "." . $base64UrlPayload, $signature, $secret, OPENSSL_ALGO_SHA256);

        // Encode Signature to Base64Url String
        $base64UrlSignature = $this->base64UrlEncode($signature);

        // Create JWT
        $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

        //-----Request token, with an http post request------
        $options = array('http' => array(
            'method'  => 'POST',
            'content' => 'grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=' . $jwt,
            'header'  => "Content-Type: application/x-www-form-urlencoded"
        ));
        $context  = stream_context_create($options);
        $responseText = file_get_contents("https://oauth2.googleapis.com/token", false, $context);

        $response = json_decode($responseText);

        return $response->access_token;
    }


    public function notify($token, $title, $message, $action = null)
    {
        $API_ACCESS_KEY = $this->getToken();
        $fcmMsg = [
            'title' => $title,
            'body' => $message
        ];

        $fcmFields = [
            'message' => [
                'token' => $token,
                'notification' => $fcmMsg,
                'data' => null,
                'android' => [
                    'notification' => [
                        'channel_id' => 'default'
                    ]
                ],
                'apns' => [
                    'payload' => [
                        'aps' => [
                            'sound' => 'default',
                            'badge' => 1,
                            'content-available' => 1
                        ]
                    ],
                    'headers' => [
                        'apns-priority' => '10'
                    ]
                ]
            ]
        ];

        $headers = array(
            'Authorization: Bearer ' . $API_ACCESS_KEY,
            'Content-Type: application/json'
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/v1/projects/the-concept-sa/messages:send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmFields));
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }


}
