<?php

namespace App\Http\Controllers\API\V1\Sales;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Sales\CustomerStatmentReportHelper;

use App\Classes\Excel\InvoicesExport;
use App\Classes\General\Tafqeet\Tafqeet;
use App\Classes\General\General;
use App\Classes\ItemStock;
use App\Classes\Sales\SalesInvoiceHelper;
use App\Classes\Sales\DeliveryNoteHelper;
use App\Classes\Sales\ProformaInvoiceHelper;


use App\Models\Finance\CostCenter;
use App\Models\Finance\Tax;
use App\Models\Inventory\Item;
use App\Models\Inventory\UnitMeasurement;
use App\Models\Inventory\Warehouse;
use App\Models\Main\Branch;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use App\Models\Sales\Customer;
use App\Models\Sales\DeliveryNote;
use App\Models\Sales\ProformaInvoice;
use App\Models\Sales\SalesAgent;
use App\Models\Sales\SalesInvoice;
use App\Models\Main\NetworkMachine;
use App\Models\Finance\Treasury;

use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

use Illuminate\Support\Facades\DB;
use Auth;
use Str;
use App;
use App\Models\Barbers\Barber;
use App\Models\Finance\Currency;
use App\Models\POS\Coupons;
use PDF;
use Excel;
use DNS2D;

class SalesInvoiceController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('06-008','view');

        $this->filter = array(
            'lang'         => $lang,
            'date'         => $request['date'] ?? null,
            'type'         => $request['type'] ?? null,
            'active'       => $request['active'] ?? 1,
            'status'       => $request['status'] ?? 1,
            'rows'         => $request['rows'] ?? 20,
            'page'         => $request['page'] ?? 1,
            'word'         => $request['word'] ?? null,
            'from'         => $request['from'] ?? null,
            'to'           => $request['to'] ?? null,
            'branch'       => $this->data['current_branch'],
            'finance_year' => $this->data['current_year']
        );

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['items']          = SalesInvoice::all_sales_invoices($this->filter);
        $this->return['prints']         = Setting::get_code_settings('sales_print', $lang);


        // if(request()->header('clientID') == '808'){
        //     $this->return['ids'] = [];

        //     $all = DB::table('sales_invoice_m')
        //         ->where('sales_invoice_m_id' , '>' , 1047 )
        //         ->get();
        // $all = SalesInvoice::all_sales_invoices(['lang' => $lang , 'active' => 1 ]);
        // foreach ($all as $key => $value) {
        // (new SalesInvoiceHelper)->send_zatca($value->sales_invoice_m_id);

        //     //     // if($value->m_id != 5222218){
        //     //     //     continue;
        //     //     // }

        //     //     DB::beginTransaction();

        //     //     $payments   = SalesInvoice::get_payments($value->m_id, $lang);
        //     //     $totalCash  = doubleval( collect($payments)->where('payment_type' , 1)->sum('amount') );
        //     //     $totalBank  = doubleval( collect($payments)->where('payment_type' , 2)->sum('amount') );

        //     //     if( $value->sales_invoice_type_id == 2 && $totalCash <= 0 )
        //     //     {
        //     //         DB::table('sales_invoice_payments')
        //     //             ->insert([
        //     //                 'sales_invoice_m_id'    => $value->m_id ,
        //     //                 'machine_id'            => 0 ,
        //     //                 'treasury_id'           => 1 ,
        //     //                 'card_type'             => 0 ,
        //     //                 'payment_type'          => 1 ,
        //     //                 'amount'                => $value->total_with_vat ,
        //     //                 'payment_text'          => 'Cash'
        //     //             ]);
        //     //     }

        //     //     if( $value->sales_invoice_type_id == 3 && $totalBank <= 0 )
        //     //     {
        //     //         DB::table('sales_invoice_payments')
        //     //             ->insert([
        //     //                 'sales_invoice_m_id'    => $value->m_id ,
        //     //                 'machine_id'            => 1 ,
        //     //                 'treasury_id'           => 0 ,
        //     //                 'card_type'             => 4 ,
        //     //                 'payment_type'          => 2 ,
        //     //                 'amount'                => $value->total_with_vat ,
        //     //                 'payment_text'          => 'network'
        //     //             ]);
        //     //     }

        //         $daily_journal = (new SalesInvoiceHelper)->generate_daily_journal($value->m_id);

        //         if(!$daily_journal[0]){
        //             DB::rollback();
        //             return response()->json( array('check' => 0 , 'data' => $daily_journal[3] ?? [] , 'msg' => 'Error in createing journal code '.$daily_journal[1] ) );
        //         }else{
        //             DB::table('sales_invoice_m')
        //                 ->where('sales_invoice_m_id' , $value->m_id)
        //                 ->update( ['daily_journal_m_id' => $daily_journal[2]] );
        //         }

        //     //     DB::commit();
        // }

        // }


        return $this->sendResponse($this->return);
    }

    public function get_pending_delivery_notes($lang, Request $request)
    {
        $this->checkPermission('06-008', 'view');

        $this->filter = array(
            'lang'         => $lang,
            'active'       => $request['active'] ?? 1,
            'status'       => $request['status'] ?? 1,
            'rows'         => $request['rows'] ?? 20,
            'page'         => $request['page'] ?? 1,
            'word'         => $request['word'] ?? null,
            'branch'       => $this->data['current_branch'],
            'finance_year' => $this->data['current_year']
        );


        $this->return['items']          = DeliveryNote::all_delivery_notes($this->filter);
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('06-008', 'add');

        $this->return['screen_name']         = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['sales_invoice_types'] = DB::table('sales_invoice_types')->select('sales_invoice_type_id as id', 'sales_invoice_type_title_' . $lang . ' as type_title')->get();
        $this->return['coupons']             = Coupons::all_coupons(array('active' => 1, 'lang' => $lang));
        $this->return['barbers']             = Barber::all_barbers(array('active' => 1, 'lang' => $lang));
        $this->return['customers']           = Customer::all_customers(array('active' => 1, 'lang' => $lang, 'is_search' => 1));
        // $this->return['proforma_invoices']   = ProformaInvoice::all_proforma_invoices(array('active' => 1, 'lang' => $lang));
        $this->return['cost_centers']        = CostCenter::active_cost_centers($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['sales_agents']        = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['items']               = Item::all_items(array('active' => 1, 'lang' => $lang, 'is_search' => 1));
        $this->return['warehouses']          = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements']   = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));
        $this->return['taxes']               = Tax::all_taxes(array('active' => 1, 'lang' => $lang));
        $this->return['network_machines']    = NetworkMachine::all_network_machines(array('active' => 1, 'lang' => $lang, 'branch' => $this->data['current_branch']));
        $this->return['treasurys']           = Treasury::all_treasury(array('active' => 1, 'lang' => $lang, 'user' => auth()->user()->id));
        $this->return['default_customer']    = Customer::get_customer(Setting::get_main_setting_by_code('default_customer')->value ?? 0, $lang);
        $this->return['width_height']        = boolval(Setting::get_main_setting_by_code('width_height')->value ?? false);
        $this->return['stock_watch']         = intval(Setting::get_main_setting_by_code('stock_watch')->value ?? 0);
        $this->return['currencies']          = Currency::all_currency(array('active' => 1, 'lang' => $lang));
        $this->return['defaults']            = (object) [];



        $extra_inputs = (new General)->get_extra_inputs(92, $lang);
        $this->return['master_inputs']     = $extra_inputs['master'];
        $this->return['detail_inputs']     = $extra_inputs['detail'];

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('06-008','add');

        $insert = $request->only(['customer_id', 'barber_id', 'proforma_invoice_id', 'delivery_notes', 'link_cost_center', 'cost_center_id', 'sales_invoice_type_id', 'sales_invoice_date', 'sales_invoice_description', 'sales_agent_id', 'supply_order', 'invoice_discount', 'discount_type', 'discount', 'items', 'extra_inputs']);
        $year   = array_search(date("Y", strtotime($insert['sales_invoice_date'])), $this->data['years']);

        if ($year == '') {
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        if (!isset($request['items']) || !is_array($request['items']) || count($request['items']) < 1) {
            return $this->sendError('Erro In Items');
        }

        $insert['proforma_invoice_id']  = $insert['proforma_invoice_id'] ?? 0;
        $insert['delivery_notes']       = (isset($insert['delivery_notes']) && is_array($insert['delivery_notes'])) ? $insert['delivery_notes'] : [];

        if ($insert['proforma_invoice_id'] > 0) {

            $check = DB::table('proforma_invoice_m')
                ->where('proforma_invoice_m_id', $insert['proforma_invoice_id'])
                ->where('proforma_invoice_status', 1) // 1 => proforma, 2 => invoiced
                ->where('sales_invoice_id', 0)
                ->where('total_delivered', 0)
                ->first();
            if (!isset($check->proforma_invoice_m_id)) {
                return $this->sendError('Error in proforma invoice');
            }
        }

        if (count($insert['delivery_notes']) > 0) {

            $check = DB::table('delivery_note_m')
                ->whereIn('delivery_note_m_id', $insert['delivery_notes'])
                ->where('delivery_note_status', 1)
                ->where('sales_invoice_id', 0)
                ->count();
            if ($check != count($insert['delivery_notes'])) {
                return $this->sendError('Error in delivery notes');
            }
        }
        $customer   = Customer::get_customer($insert['customer_id'], 'en');
        $codes      = (new SalesInvoiceHelper)->get_next_codes($insert['sales_invoice_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'branch_id'                 => $this->data['current_branch'],
            'finance_year_id'           => $year,
            'year_ser'                  => $codes['year_ser'],
            'month_ser'                 => $codes['month_ser'],
            'branch_ser'                => $codes['branch_ser'],
            'extra_inputs'              => json_encode($insert['extra_inputs'] ?? []),
            'daily_journal_m_id'        => 0,
            'customer_id'               => $insert['customer_id'],
            'invoice_cust_type'         => $customer->customer_invoice_type ?? 0,
            'proforma_invoice_id'       => $insert['proforma_invoice_id'],
            'delivery_notes'            => implode(',', $insert['delivery_notes']),
            'link_cost_center'          => $insert['link_cost_center'] ?? 0,
            'cost_center_id'            => $insert['cost_center_id'] ?? 0,
            'sales_invoice_type_id'     => $insert['sales_invoice_type_id'],
            'sales_invoice_date'        => $insert['sales_invoice_date'],
            'sales_invoice_description' => $insert['sales_invoice_description'],
            'sales_agent_id'            => $insert['sales_agent_id'],
            'supply_order'              => $insert['supply_order'],
            'invoice_discount'          => $insert['invoice_discount'] ?? 0,
            'discount_type'             => $insert['discount_type'] ?? 0,
            'discount'                  => $insert['discount'] ?? 0,
            'barber_id'                 => $insert['barber_id'] ?? 0,
            'coupon_id'                 => $insert['coupon_id'] ?? 0,
            'invoice_uuid'              => Str::uuid(),
            'items_count'               => count($insert['items']),
            'add_user'                  => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, SalesInvoice::$master_rules);
        if ($validator->fails()) {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $source = ItemStock::Sales_source;

        DB::beginTransaction();

        DB::table('sales_invoice_m')->lockForUpdate()->get();
        $sales_invoice_m_id = intval(DB::table('sales_invoice_m')->max('sales_invoice_m_id')) + 1;
        $master_seed['sales_invoice_m_id'] = $sales_invoice_m_id;
        $m_id   = SalesInvoice::add_sales_invoice_m($master_seed);
        $items  = (new SalesInvoiceHelper)->prepare_details($m_id, $insert['proforma_invoice_id'], $insert['delivery_notes'], $request['items'], 0);
        if (count($items) < 1) {
            DB::rollback();
            return $this->sendError(trans('error.add_fails'), []);
        }

        foreach ($items as $item) {

            $validator = validator()->make($item, SalesInvoice::$details_rules);
            if ($validator->fails()) {
                return $this->sendError(trans('error.add_fails'), $validator->errors());
            }

            if (isset($item['unit_id']) && !is_null($item['unit_id'])) {
                $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
                if ($item['unit_id'] == $selectedItem->big_unit_id) {
                    $item['unit_type'] = 3;
                } elseif ($item['unit_id'] == $selectedItem->mid_unit_id) {
                    $item['unit_type'] = 2;
                } elseif ($item['unit_id'] == $selectedItem->small_unit_id) {
                    $item['unit_type'] = 1;
                } else {
                    $item['unit_type'] = 3;
                }
            }

            unset($item['d_id']);
            $d_id = SalesInvoice::add_sales_invoice_d($item);
            $qty = $item['quantity'];
            (new ItemStock)->update_item_stock($this->data['current_branch'], $item['item_id'], $item['warehouse_id'], $source, $m_id, $d_id, $qty, 0, $item['unit_id'], $item['unit_type'], 0);
        }


        $payments = $request['payments'] ?? [];

        foreach ($payments as $payment) {
            DB::table('sales_invoice_payments')->insert(array(
                'sales_invoice_m_id' => $m_id,
                'machine_id'         => $payment['machine_id'] ?? 0,
                'treasury_id'        => $payment['treasury_id'] ?? 0,
                'payment_type'       => $payment['payment_type'] ?? 1,
                'payment_text'       => $payment['payment_text'],
                'card_type'          => $payment['cart_type'] ?? $payment['card_type']  ?? 1,
                'amount'             => $payment['amount']
            ));
        }


        $updateMasterValues   = (new SalesInvoiceHelper)->update_master_values($m_id);

        if ($insert['proforma_invoice_id'] > 0) {

            DB::table('proforma_invoice_m')
                ->where('proforma_invoice_m_id', $insert['proforma_invoice_id'])
                ->update(['proforma_invoice_status' => 4, 'sales_invoice_id' =>  $m_id]);

            (new ProformaInvoiceHelper)->update_master_values($insert['proforma_invoice_id']);
        } elseif (count($insert['delivery_notes']) > 0) {


            DB::table('delivery_note_m')
                ->whereIn('delivery_note_m_id', $insert['delivery_notes'])
                ->update(['delivery_note_status' => 2, 'sales_invoice_id' =>  $m_id]);


            (new DeliveryNoteHelper)->update_master_values($insert['delivery_notes']);
        }

        (new SalesInvoiceHelper)->generate_daily_journal($m_id);
        (new SalesInvoiceHelper)->send_zatca($m_id);

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('06-008','view');

        $this->return['screen_name']         = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['master']              = SalesInvoice::get_sales_invoice_m($id, $lang);
        $this->return['details']             = SalesInvoice::get_sales_invoice_d($id, $lang);
        $this->return['customers']           = Customer::all_customers(array('active' => 1, 'lang' => $lang,  'is_search' => 1));
        // $this->return['proforma_invoices']   = ProformaInvoice::all_proforma_invoices(array('active' => 1, 'lang' => $lang));
        $this->return['cost_centers']        = CostCenter::active_cost_centers($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['sales_agents']        = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['items']               = Item::all_items(array('active' => 1, 'lang' => $lang, 'is_search' => 1));
        $this->return['payments']            = SalesInvoice::get_payments($id, $lang);
        $this->return['warehouses']          = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements']   = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));
        $this->return['taxes']               = Tax::all_taxes(array('active' => 1, 'lang' => $lang));
        $this->return['sales_invoice_types'] = DB::table('sales_invoice_types')->select('sales_invoice_type_id as id', 'sales_invoice_type_title_' . $lang . ' as type_title')->get();
        $this->return['network_machines']    = NetworkMachine::all_network_machines(array('active' => 1, 'lang' => $lang, 'branch' => $this->data['current_branch']));
        $this->return['treasurys']           = Treasury::all_treasury(array('active' => 1, 'lang' => $lang, 'user' => auth()->user()->id));
        $this->return['width_height']        = boolval(Setting::get_main_setting_by_code('width_height')->value ?? false);
        $this->return['currencies']          = Currency::all_currency(array('active' => 1, 'lang' => $lang));
        $this->return['defaults']            = (object) [];


        $this->return['master']->extra_inputs = json_decode($this->return['master']->extra_inputs);
        foreach ($this->return['details'] as $key => $value) {
            $this->return['details'][$key]->extra_inputs = json_decode($this->return['details'][$key]->extra_inputs);
        }

        $extra_inputs = (new General)->get_extra_inputs(92, $lang);
        $this->return['master_inputs']     = $extra_inputs['master'];
        $this->return['detail_inputs']     = $extra_inputs['detail'];



        // if($id == 2023014){
        //     $daily_journal = (new SalesInvoiceHelper)->generate_daily_journal($id);
        //     $this->return['dasds'] ='asd';
        // }
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('06-008','edit');
        if (auth()->user()->super_admin == 0) {
            return $this->sendError('permission needed #06-008', [], 200)->send();
        }
        $inputs = $request->all();
        $inputs['proforma_invoice_id']  = $inputs['proforma_invoice_id'] ?? 0;
        $inputs['delivery_notes']       = (isset($inputs['delivery_notes']) && is_array($inputs['delivery_notes'])) ? $inputs['delivery_notes'] : [];
        $update_m = [
            'customer_id'                   => $inputs['customer_id'],
            'proforma_invoice_id'           => $inputs['proforma_invoice_id'],
            'link_cost_center'              => $inputs['link_cost_center'],
            'cost_center_id'                => $inputs['cost_center_id'],
            'sales_invoice_type_id'         => $inputs['sales_invoice_type_id'],
            'extra_inputs'                  => json_encode($inputs['extra_inputs'] ?? []),
            'delivery_notes'                => implode(',', $inputs['delivery_notes']),
            'sales_invoice_date'            => $inputs['sales_invoice_date'],
            'sales_invoice_description'     => $inputs['sales_invoice_description'],
            'sales_agent_id'                => $inputs['sales_agent_id'],
            'supply_order'                  => $inputs['supply_order'],
            'invoice_discount'              => $inputs['invoice_discount'] ?? 0,
            'discount_type'                 => $inputs['discount_type'] ?? 0,
            'discount'                      => $inputs['discount'] ?? 0,
            'barber_id'                     => $inputs['barber_id'] ?? 0,
            'coupon_id'                     => $inputs['coupon_id'] ?? 0,
            'items_count'                   => count($inputs['items'])
        ];
        $validator = validator()->make($update_m, SalesInvoice::$master_rules);
        if ($validator->fails()) {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        DB::beginTransaction();

        // update item stock exists in old invoice
        $old_items = SalesInvoice::get_sales_invoice_d($id, $lang)->pluck('quantity', 'item_id')->toArray();
        $new_items = collect($request->items)->pluck('quantity', 'item_id')->toArray();
        foreach ($new_items as $item_id => $new_quantity) {
            $old_quantity = $old_items[$item_id] ?? 0;
            $source_m_id = SalesInvoice::get_sales_invoice_d($id, $lang)->pluck('m_id')->first();
            $source_d_id = SalesInvoice::get_sales_invoice_d($id, $lang)->pluck('d_id')->first();
            $selectedItem = DB::table('items')->where('item_id', $item_id)->first();
            if ($request->items[0]['unit_id'] == $selectedItem->big_unit_id) {
                $item['unit_type'] = 3;
            } elseif ($request->items[0]['unit_id'] == $selectedItem->mid_unit_id) {
                $item['unit_type'] = 2;
            } elseif ($request->items[0]['unit_id'] == $selectedItem->small_unit_id) {
                $item['unit_type'] = 1;
            } else {
                $item['unit_type'] = 3;
            }

            if ($new_quantity > $old_quantity) {

                $diff = $new_quantity - $old_quantity;

                // outcoming stock log
                DB::table('stocks')
                    ->where('item_id', $item_id)
                    ->decrement('stock', $diff);

                DB::table('stock_logs')->insert([
                    'branch_id'       => $request->branch_id,
                    'item_id'         => $item_id,
                    'warehouse_id'    => $request->items[0]['warehouse_id'],
                    'purchase_cost'   => 0,
                    'stock'           => -$diff,
                    'source'          => ItemStock::Sales_source,
                    'source_m_id'     => $source_m_id,
                    'source_d_id'     => $source_d_id,
                    'source_quantity' => $diff,
                    'unit_id'         => $request->items[0]['unit_id'],
                    'unit_type'       => $item['unit_type'],
                    'add_user'        => auth()->id(),
                ]);
            } elseif ($new_quantity < $old_quantity) {

                $diff = $old_quantity - $new_quantity;
                DB::table('stocks')
                    ->where('item_id', $item_id)
                    ->increment('stock', $diff);

                // incoming stock log
                DB::table('stock_logs')->insert([
                    'branch_id'       => $request->branch_id,
                    'item_id'         => $item_id,
                    'warehouse_id'    => $request->items[0]['warehouse_id'],
                    'purchase_cost'   => 0,
                    'stock'           => $diff,
                    'source'          => ItemStock::Sales_source,
                    'source_m_id'     => $source_m_id,
                    'source_d_id'     => $source_d_id,
                    'source_quantity' => $diff,
                    'unit_id'         => $request->items[0]['unit_id'],
                    'unit_type'       => $item['unit_type'],
                    'add_user'        => auth()->id(),
                ]);
            }

            // remove old items exists in invoice
            unset($old_items[$item_id]);
        }


        // update item stock dosnt exists in old invoice
        foreach ($old_items as $old_item_id => $old_quantity) {
            DB::table('stocks')
                ->where('item_id', $old_item_id)
                ->increment('stock', $old_quantity);
        }

        $m_id = SalesInvoice::update_sales_invoice_m($update_m, $id);
        $items  = (new SalesInvoiceHelper)->prepare_update_details($id, $inputs['items'], 0);

        $new_details = collect($inputs['items'])->pluck('d_id')->toArray();
        $details = SalesInvoice::get_sales_invoice_d($id, $lang)->pluck('d_id')->toArray();

        foreach ($details as $detail) {
            if (!in_array($detail, $new_details)) {
                DB::table('sales_invoice_d')->where('sales_invoice_d_id', $detail)->delete();
            }
        }
        foreach ($items as $item) {

            $validator = validator()->make($item, SalesInvoice::$details_rules);
            if ($validator->fails()) {
                return $this->sendError(trans('error.add_fails'), $validator->errors());
            }

            if (isset($item['unit_id']) && !is_null($item['unit_id'])) {
                $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
                if ($item['unit_id'] == $selectedItem->big_unit_id) {
                    $item['unit_type'] = 3;
                } elseif ($item['unit_id'] == $selectedItem->mid_unit_id) {
                    $item['unit_type'] = 2;
                } elseif ($item['unit_id'] == $selectedItem->small_unit_id) {
                    $item['unit_type'] = 1;
                } else {
                    $item['unit_type'] = 3;
                }
            }

            if ($item['d_id'] == 0) {
                unset($item['d_id']);
                $insert_d = $item;
                SalesInvoice::add_sales_invoice_d($insert_d);
            } else {
                $d_id = $item['d_id'];
                unset($item['d_id']);
                $update_d = $item;
                SalesInvoice::update_sales_invoice_d($update_d, $d_id);
            }
        }
        $payments = $inputs['payments'] ?? [];
        if (isset($inputs['payments'])) {
            DB::table('sales_invoice_payments')
                ->where('sales_invoice_m_id', $id)->delete();

            foreach ($payments as $payment) {

                DB::table('sales_invoice_payments')
                    ->insert(array(
                        'sales_invoice_m_id' => $id,
                        'machine_id'         => $payment['machine_id'] ?? 0,
                        'treasury_id'        => $payment['treasury_id'] ?? 0,
                        'payment_type'       => $payment['payment_type'] ?? 1,
                        'payment_text'       => $payment['payment_text'],
                        'card_type'          => $payment['cart_type'] ?? $payment['card_type']  ?? 1,
                        'amount'             => $payment['amount']
                    ));
            }
        }
        (new SalesInvoiceHelper)->update_master_values($id);
        (new SalesInvoiceHelper)->generate_daily_journal($id);

        DB::commit();

        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function get_customer_proforma_completed($lang, Request $request)
    {

        $this->return['balance'] = CustomerStatmentReportHelper::get_account_customer_statment($request['customer_id'], $lang, array('total' => true, 'before' => date("Y-m-d", strtotime("+1 days")), 'first' => 1));
        $this->return['items'] = DB::table('proforma_invoice_m')
            ->leftjoin('proforma_invoice_d', 'proforma_invoice_m.proforma_invoice_m_id', '=', 'proforma_invoice_d.proforma_invoice_m_id')
            ->leftjoin('customers', 'proforma_invoice_m.customer_id', '=', 'customers.customer_id')
            ->where('proforma_invoice_m.customer_id', $request['customer_id'])
            ->where('proforma_invoice_status', 1)
            ->where('sales_invoice_id', 0)
            ->where('proforma_invoice_active', 1)
            ->groupBy('proforma_invoice_m.proforma_invoice_m_id')
            ->selectRaw('proforma_invoice_m.proforma_invoice_m_id as id , customers.name_ar as customer_name , purchase_order_id , proforma_invoice_m.proforma_invoice_date , proforma_invoice_m.sales_agent_id , sum(delivered_quantity) as delivered_quantity')
            ->having('delivered_quantity', '=', 0)

            ->get();

        return $this->sendResponse($this->return, trans('main.Data Retrieved Successfully'));
    }

    public function get_delivery_note_data($lang, Request $request)
    {
        // If Request From Group Of Delivery Notes
        if (isset($request['delivery_notes']) && !is_null($request['delivery_notes']) && is_array($request['delivery_notes'])) {
            $delivery_notes = DB::table('delivery_note_m')
                ->whereIn('delivery_note_m_id', $request['delivery_notes'])
                ->pluck('delivery_note_m_id');

            $proforma_invoice_id = DB::table('delivery_note_m')
                ->whereIn('delivery_note_m_id', $request['delivery_notes'])
                ->pluck('proforma_invoice_id');


            $this->return['master'] = ProformaInvoice::get_proforma_invoice_m($proforma_invoice_id, $lang);
            $this->return['items']  = DB::table('delivery_note_d')
                ->leftjoin('delivery_note_m', 'delivery_note_d.delivery_note_m_id', '=', 'delivery_note_m.delivery_note_m_id')
                ->leftjoin('items', 'delivery_note_d.item_id', '=', 'items.item_id')
                ->leftjoin('warehouses', 'delivery_note_d.warehouse_id', '=', 'warehouses.warehouse_id')
                ->leftjoin('unit_measurements', 'delivery_note_d.unit_id', '=', 'unit_measurements.unit_measurement_id')
                ->leftjoin('taxes', 'delivery_note_d.tax_percent_id', '=', 'taxes.tax_id')
                ->whereIn('delivery_note_m.delivery_note_m_id', $delivery_notes)
                ->selectRaw('
                    items.price_include_vat ,
                    delivery_note_m.delivery_note_m_id as m_id ,
                    delivery_note_d_id as d_id ,
                    delivery_note_d.item_id ,
                    items.name_' . $lang . ' as item_name ,
                    delivery_note_d.warehouse_id ,
                    warehouses.name_' . $lang . ' as warehouse_name ,
                    delivery_note_d.unit_id ,
                    unit_measurements.name_' . $lang . ' as unit_name ,
                    delivery_note_d.quantity ,
                    delivery_note_d.price ,
                    delivery_note_d.item_price ,
                    delivery_note_d.item_discount ,
                    delivery_note_d.total_discount ,
                    delivery_note_d.total_price ,
                    delivery_note_d.tax_percent_id ,
                    taxes.tax_percentage as tax_percent ,
                    delivery_note_d.total_vat ,
                    delivery_note_d.total_without_vat ,
                    delivery_note_d.total_with_vat
                ')
                ->get();


            $this->return['master']->discount       = collect($this->return['items'])->sum('total_discount');
            if ($this->return['master']->discount > 0)
                $this->return['master']->discount_type  = 1;
        } else {


            $this->return['master']     = ProformaInvoice::get_proforma_invoice_m($request['proforma_invoice_id'], $lang);
            $this->return['items']      = ProformaInvoice::get_proforma_invoice_d($request['proforma_invoice_id'], $lang);
            // If Request From Proforma Invoice
            // $delivery_notes = DB::table('delivery_note_m')->where('proforma_invoice_id', $request['proforma_invoice_id'])->pluck('delivery_note_m_id');
            // $this->return['master'] = ProformaInvoice::get_proforma_invoice_m($request['proforma_invoice_id'], $lang);
        }



        return $this->sendResponse($this->return, trans('main.Data Retrieved Successfully'));
    }

    public function print_invoice($id, Request $request)
    {
        $input = $request->all();


        $this->data['lang']        = $request['lang'] ?? 'ar';
        $this->data['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $this->data['lang']);
        $this->data['master']      = SalesInvoice::get_sales_invoice_m($id, $this->data['lang']);
        $this->data['details']     = SalesInvoice::get_sales_invoice_d($id, $this->data['lang'], 1);
        $this->data['customer']    = Customer::get_customer($this->data['master']->customer_id, $this->data['lang']);
        $this->data['logo']        = get_logo($this->data['master']->branch_id);
        $this->data['branch_data'] = Branch::get_branch($this->data['master']->branch_id, $this->data['lang']);

        $temp_name                 = $input['print_temp'] ?? Setting::get_main_setting_by_code('sales_print')->value ?? 'temp_1';
        $print_temp                = 'Print.Sales.sales_invoice.' . $temp_name;


        if (strlen($this->data['master']->invoice_qrcode) > 10) {

            $this->data['qrcode'] = "data:image/png;base64," . DNS2D::getBarcodePNG(($this->data['master']->invoice_qrcode), 'QRCODE', 10, 10);
        } else {


            $this->data['qrcode']      = GenerateQrCode::fromArray([
                new Seller($this->data['branch_data']->vat_register_name), // Seller Name
                new TaxNumber($this->data['branch_data']->vat_number), // Seller Tax Number
                new InvoiceDate(date('Y-m-d\TH:i:s', strtotime($this->data['master']->add_date))),
                new InvoiceTotalAmount($this->data['master']->total_with_vat), // Invoice Total Amount
                new InvoiceTaxAmount(round($this->data['master']->total_vat, 2)) // Invoice Tax Amount
            ])->render();
        }
        $this->data['master']->tafqeet = (new General)->numberToText($this->data['lang'], $this->data['master']->total_with_vat, $this->data['customer']->currency_code, $this->data['customer']->big_sign, $this->data['customer']->small_sign);
        $this->data['master']->tafqeet_ar = (new General)->numberToText('ar', $this->data['master']->total_with_vat, $this->data['customer']->currency_code, $this->data['customer']->big_sign, $this->data['customer']->small_sign);
        $this->data['master']->tafqeet_en = (new General)->numberToText('en', $this->data['master']->total_with_vat, $this->data['customer']->currency_code, $this->data['customer']->big_sign, $this->data['customer']->small_sign);

        switch (@$input['type']) {
            case 'excel':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $export = new InvoicesExport($this->data, $print_temp);
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $pdf = PDF::loadView($print_temp, array('data' => $this->data));
                return $pdf->stream();
                break;
            case 'image':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp, array('data' => $this->data));
                return $image->stream();
                break;
            case 'print':
                return view($print_temp)->with('data', $this->data);
                break;
        }
    }
}
