<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\General\General;
use App\Classes\Sales\CustomerStatmentReportHelper;
use App\Classes\Purchases\PurchaseVendorStatmentReportHelper;
use App\Classes\Sales\DeptAgeReportHelper;
use App\Classes\Excel\InvoicesExport;
use App\Classes\Sales\CustomerHelper;


use App\Models\Inventory\Item;
use App\Models\Main\Branch;
use App\Models\Sales\CustomerType;
use App\Models\Sales\SalesAgent;
use App\Models\Sales\SalesArea;
use App\Models\Sales\ProformaInvoice;
use App\Models\Finance\AccountTree;
use App\Models\Sales\Customer;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Sales\SalesInvoice;
use App\Models\Main\ScreenSub;
use App\Models\Barbers\Barber;


use DB;
use PDF;
use Str;
use Excel;
use App;
use App\Classes\Sales\DailyReportHelper;
use App\Models\Finance\Treasury;
use Carbon\Carbon;

class ReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function proformas_report_get($lang , Request $request ){

        $this->checkPermission('06-023','view');
        $this->filter['lang']           = $lang;
        // $this->filter['from']           = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
        // $this->filter['to']             = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
        $this->return['invoices']       = ProformaInvoice::all_proforma_invoices($this->filter);
        return $this->sendResponse( $this->return );

    }

    public function proformas_report_post($lang , Request $request ){
        $this->checkPermission('06-023','print');

        $this->return['master']             = ProformaInvoice::get_proforma_invoice_m($request['id'], $lang);
        $this->return['details']            = ProformaInvoice::get_proforma_invoice_d($request['id'], $lang);
        $this->return['customer']           = Customer::get_customer($this->return['master']->customer_id, $lang);
        $this->return['logo']               = get_logo($this->return['master']->branch_id);
        $this->return['branch_data']        = Branch::get_branch($this->return['master']->branch_id);
        $this->return['master']->tafqeet    = ( new General )->numberToText($lang, $this->return['master']->total_with_vat , $this->return['customer']->currency_code , $this->return['customer']->big_sign , $this->return['customer']->small_sign );

        return $this->sendResponse( $this->return );

    }

    public function sales_items_report_get($lang , Request $request ){

        $this->checkPermission('06-022','view');
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-022' , $lang)->sub_title ?? '';
        $this->return['items']          = Item::all_items(array('active' => 1, 'lang' => $lang));
        $this->return['customers']      = Customer::all_customers(array('lang' => $lang , 'active' => 1  ,  'is_search' => 1));
        $this->return['barbers']        = Barber::all_barbers(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse( $this->return );
    }

    public function sales_items_report_post($lang , Request $request)
    {
        $this->checkPermission('06-022','view');
        App::setLocale($lang);
        $this->return['from']           = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
        $this->return['to']             = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
        $this->return['items']          = $request['items'] ?? [];
        $this->return['payment_type']   = $request['payment_type'] ?? 0;
        $this->return['sales_agent_id'] = $request['sales_agent_id'] ?? 0 ;
        $this->return['customer_id']    = $request['customer_id'] ?? 0 ;
        $this->return['invoice_code']   = $request['invoice_code'] ?? 0 ;
        $this->return['branch_id']      = $request['branch_id'] ?? 0 ;
        $this->return['barber_id']      = $request['barber_id'] ?? 0 ;
        $this->return['item_id']        = $request['item_id'] ?? 0 ;
        $this->return['lang']           = $lang ;

        if (isset($this->return['items']) && !is_array($this->return['items'])) {
            $this->return['items'] = explode(',' , $this->return['items']);
        }


        $query = DB::table('sales_invoice_m')
            ->leftjoin('sales_invoice_d', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
            ->leftjoin('items', 'sales_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('users', 'sales_invoice_m.add_user' , '=' , 'users.id')
            ->leftjoin('branchs', 'sales_invoice_m.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
            ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
            ->groupBy('sales_invoice_d.sales_invoice_d_id')
            // ->where('sales_invoice_m.branch_id', '=', $this->return['branch_id'])
            ->where('sales_invoice_m.sales_invoice_date' , '>=' , $this->return['from']." 00:00:00")
            ->where('sales_invoice_m.sales_invoice_date' , '<=' , $this->return['to']." 23:59:59")
            ->where('sales_invoice_active' , '=' , 1)

            ->selectRaw('
                sales_invoice_m.sales_invoice_m_id as s_m_id  ,
                0 as r_m_id ,
                sales_invoice_m.sales_invoice_m_id as invoice_code ,
                sales_invoice_m.sales_invoice_date as invoice_date ,
                branchs.name_'.$lang.' as branch_name ,
                sales_agents.name_'.$lang.' as  sales_agent_name ,
                sales_invoice_m.customer_id as customer_id  ,
                customers.name_'.$lang.' as customer_name ,
                sales_invoice_m.sales_invoice_description as description ,
                sales_invoice_m.supply_order ,
                sales_invoice_d.area_width ,
                sales_invoice_d.area_height ,
                sales_invoice_d.area_quantity ,

                users.user_full_name as user_full_name ,
                sales_invoice_d.extra_inputs ,
                sales_invoice_d.item_id as item_id  ,
                items.name_'.$lang.' as  items_name,
                sales_invoice_d.quantity as total_quantity ,
                sales_invoice_d.price as item_price ,
                sales_invoice_d.total_price as total_price ,
                sales_invoice_d.discount as discount ,
                sales_invoice_d.total_price_after_discount as total_price_after_discount ,
                sales_invoice_d.total_vat as total_vat ,
                sales_invoice_d.total_without_vat as total_without_vat ,
                sales_invoice_d.total_with_vat as total_with_vat ,

                payment_methods.payment_method_id as payment_type_id ,
                payment_methods.name_'.$lang.' as payment_type ,

                sum( case when sales_invoice_payments.payment_type = 1 then sales_invoice_payments.amount end ) as paid_cash ,
                sum( case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end ) as paid_bank ,
                sum( case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end ) as paid_trans
            ');

        if(count($this->return['items']) > 0){
            $query->whereIn('items.item_id', $this->return['items']);
        }

        if( $this->return['branch_id'] > 0  ){
            $query->where('sales_invoice_m.branch_id' , '=' , $this->return['branch_id'] );
        }else{
            $query->whereIn('sales_invoice_m.branch_id' , array_keys($this->data['branchs']) );
        }

        if( $this->return['sales_agent_id'] != 0 ){
            $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
        }

        if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
            $query->where('sales_invoice_d.sales_invoice_m_id' , $this->return['invoice_code'] );
        }

        if(isset($this->return['item_id']) && ($this->return['item_id']) > 0){
            $query->where('sales_invoice_d.item_id' , $this->return['item_id'] );
        }

        if(isset($this->return['customer_id']) && ($this->return['customer_id']) > 0){
            $query->where('sales_invoice_m.customer_id' , $this->return['customer_id'] );
        }

        if(isset($this->return['barber_id']) && ($this->return['barber_id']) > 0){
            $query->where('sales_invoice_m.barber_id' , $this->return['barber_id'] );
        }

        if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
            $query->where('sales_invoice_payments.payment_type' , $this->return['payment_type']);
        }

        $this->return['report'] = $query->get()->toArray();
        foreach ($this->return['report'] as $key => $row) {
            $this->return['report'][$key]->extra_inputs = json_decode($this->return['report'][$key]->extra_inputs);
        }


        $extra_inputs = (new General)->get_extra_inputs(92 , $lang);
        $this->return['detail_inputs']     = $extra_inputs['detail'];

        return $this->sendResponse( $this->return  );
    }

    public function customer_statment_get($lang , Request $request)
    {
        $this->checkPermission('03-010','view');
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('03-010' , $lang)->sub_title ?? '';

        return $this->sendResponse( $this->return );

    }

    public function customer_statment_post($lang , Request $request)
    {
        $this->checkPermission('03-010','print');
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('03-010' , $lang)->sub_title ?? '';
        $this->data['from']             = $request['from'];
        $this->data['to']               = $request['to'];
        $this->return['lang']           = $lang;


        $first = DB::table('users')
            ->whereNull('first_name');

        $users = DB::table('users')
            ->whereNull('last_name')
            ->union($first)
            ->get();


        $this->return['category_id']      = $request['category_id'] ?? [] ;
        $this->return['sub_category_id']  = $request['sub_category_id'] ?? [] ;
        $this->return['branch_id']        = $request['branch_id'] ?? array_keys($this->data['branchs']) ;
        $this->return['lang']             = $lang;

        if($this->return['branch_id'] == 0 ){
            $this->return['branch_id'] = array_keys($this->data['branchs']);
        }

        if (isset($this->return['category_id']) && !is_array($this->return['category_id']) ) {
            $this->return['category_id'] = explode(',' , $this->return['category_id']);
        }

        $branch = Branch::get_branch($this->data['current_branch'] , 'en');

        $this->return['report']           = ( new GoldStock )->get_stock_by_piece( array('branch' => $this->return['branch_id'] , 'category' => $this->return['category_id'] , 'sub_category' => $this->return['sub_category_id'] , 'lang' => $lang ) );

        $this->return['logo']           = get_logo($this->data['current_branch']);
        $this->return['params_text']    = '';
        $this->return['branch_data']    = Branch::get_branch($this->data['current_branch'] );

        if(isset( $this->return['category_id']) && count($this->return['category_id']))
            $this->return['params_text']  .= " - ".trans('main.caliber')." ".implode(',' , $this->return['category_id']);

        switch (@$request['type']) {
            case 'excel':
                $this->return['logo']     = public_path().$this->return['logo'];
                $export = new InvoicesExport($this->return , 'Print/Store/Report/item_balance');
                return Excel::download($export, 'balances.xlsx');
            break;
            case 'pdf':
                $this->return['logo']     = public_path().$this->return['logo'];
                $pdf = PDF::loadView('Print/Store/Report/item_balance', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
                return $pdf->stream();
            break;

            case 'print':
                return view('Print/Store/Report/item_balance')->with('data' , $this->return);
            break;
            case 'json':
                return $this->sendResponse( $this->return  );
                // return view('finance/report/account_statment_anal_p')->with('data' , $this->data);
            break;
        }
    }

    public function full_report_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-012'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-012', $this->data, 200);
        }

        App::setLocale($lang);

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-012' , $lang)->sub_title ?? '';
        $this->return['branchs'] = Branch::all_branchs(array('active' => 1, 'lang' => $lang));
        $this->return['items']   = Item::all_items(array('active' => 1, 'lang' => $lang));

        $this->return['types']              = array(
            array(
                'id'    => 0 ,
                'title' => trans('main.all')
            ),array(
                'id'    => 1 ,
                'title' => trans('main.sales')
            ),array(
                'id'    => 2 ,
                'title' => trans('main.notice_creditor')
            ),array(
                'id'    => 3 ,
                'title' => trans('main.notice_debtor')
            )
        );

        return $this->sendResponse($this->return);
    }

    public function full_report_post($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-012'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-012', $this->data, 200);
        }

        App::setLocale($lang);

        $this->return['from']         = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
        $this->return['to']           = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
        $this->return['report_type']  = $request['report_type'] ?? 0;
        $this->return['items']        = $request['items'] ?? [];
        $this->return['payment_type'] = $request['payment_type'] ?? 0;

        $this->return['sales_agent_id'] = $request['sales_agent_id'] ?? 0 ;
        $this->return['customer_id']    = $request['customer_id'] ?? 0 ;

        $this->return['invoice_code']   = $request['invoice_code'] ?? 0 ;

        $this->return['branch_id']    = intval( $request['branch_id'] ?? 0 );
        $this->return['lang']         = $lang ;

        if (isset($this->return['items']) && !is_array($this->return['items'])) {
            $this->return['items'] = explode(',' , $this->return['items']);
        }

        $branch = Branch::get_branch($this->data['current_branch'] , 'en');

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 1){
            $query = DB::table('sales_invoice_m')
                ->leftjoin('sales_invoice_d', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
                ->leftjoin('items', 'sales_invoice_d.item_id' , '=' , 'items.item_id')
                ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('users', 'sales_invoice_m.add_user' , '=' , 'users.id')
                ->leftjoin('branchs', 'sales_invoice_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
                ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
                ->groupBy('sales_invoice_d.sales_invoice_d_id')
                // ->where('sales_invoice_m.branch_id', '=', $this->return['branch_id'])
                ->where('sales_invoice_m.sales_invoice_date' , '>=' , $this->return['from']." 00:00:00")
                ->where('sales_invoice_m.sales_invoice_date' , '<=' , $this->return['to']." 23:59:59")
                ->where('sales_invoice_active' , '=' , 1)

                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id  ,
                    0 as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    sales_invoice_m.sales_invoice_date as invoice_date ,
                    branchs.name_'.$lang.' as branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,
                    sales_invoice_m.customer_id as customer_id  ,
                    customers.name_'.$lang.' as customer_name ,

                    users.user_full_name as user_full_name ,

                    sales_invoice_d.item_id as item_id  ,
                    items.name_'.$lang.' as  items_name,
                    sales_invoice_d.quantity as total_quantity ,
                    sales_invoice_d.price as item_price ,
                    sales_invoice_d.total_price as total_price ,
                    sales_invoice_d.discount as discount ,
                    sales_invoice_d.total_price_after_discount as total_price_after_discount ,
                    sales_invoice_d.total_vat as total_vat ,
                    sales_invoice_d.total_without_vat as total_without_vat ,
                    sales_invoice_d.total_with_vat as total_with_vat ,

                    payment_methods.payment_method_id as payment_type_id ,
                    payment_methods.name_'.$lang.' as payment_type ,

                    sum( case when sales_invoice_payments.payment_type = 1 then sales_invoice_payments.amount end ) as paid_cash ,
                    sum( case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end ) as paid_bank ,
                    sum( case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end ) as paid_trans
                ');

            if(count($this->return['items']) > 0){
                $query->whereIn('items.item_id', $this->return['items']);
            }

            if( $this->return['branch_id'] > 0  ){
                $query->where('sales_invoice_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $query->whereIn('sales_invoice_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if( $this->return['sales_agent_id'] != 0 ){
                $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $query->where('sales_invoice_d.sales_invoice_m_id' , $this->return['invoice_code'] );
            }

            if(isset($this->return['customer_id']) && ($this->return['customer_id']) > 0){
                $query->where('sales_invoice_m.customer_id' , $this->return['customer_id'] );
            }


            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $query->where('sales_invoice_payments.payment_type' , $this->return['payment_type']);
            }

            $sales = $query->get()->toArray();

            foreach ($sales as $key => $row) {
                $sales[$key]->type = 1;
                $sales[$key]->sumtion = 1;
            }
        }else{
            $sales = array();
        }

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 2){
            $returns2 = DB::table('notice_creditors_m')
                ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
                ->leftjoin('items', 'notice_creditors_d.item_id' , '=' , 'items.item_id')
                ->leftjoin('taxes', 'items.tax_id' , '=' , 'taxes.tax_id')
                ->leftjoin('branchs' , 'notice_creditors_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('customers' , 'notice_creditors_m.customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id ,
                    notice_creditors_m.notice_creditor_m_id as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    notice_creditors_m.invoice_date ,

                    notice_creditors_d.item_id as item_id ,
                    items.name_'.$lang.' as  items_name ,
                    taxes.tax_percentage as tax_percentage ,

                    notice_creditors_d.new_price as item_price ,new_price ,
                    notice_creditors_d.new_quantity as item_quantity ,

                    branchs.name_'.$lang.' as  branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,

                    notice_creditors_m.customer_id as customer_id  ,
                    customers.name_'.$lang.' as customer_name ,

                    sum(notice_creditors_d.new_total_without_vat) as total_price ,
                    sum(notice_creditors_d.new_total_with_vat) as total_with_vat ,
                    sum(notice_creditors_d.new_total_without_vat) as total_without_vat ,
                    sum(notice_creditors_d.new_total_vat) as total_vat ,
                    sum(notice_creditors_d.new_quantity) as total_quantity ,


                    sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
                    sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
                    sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
                ')
                ->groupBy('items.item_id')
                ->where('notice_creditors_m.invoice_date' , '>=' , $this->return['from'] )
                ->where('notice_creditors_m.invoice_date' , '<=' , $this->return['to'] )
                ->where('notice_creditor_active' , '=' , 1);

            if(count($this->return['items']) > 0){
                $returns2->whereIn('items.item_id', $this->return['items']);
            }

            if( $this->return['branch_id'] > 0  ){
                $returns2->where('notice_creditors_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $returns2->whereIn('notice_creditors_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $returns2->where('notice_creditors_d.notice_creditor_m_id' ,  $this->return['invoice_code'] );
            }

            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $returns2->where('notice_payments.payment_type' , $this->return['payment_type'] );
            }

            if( $this->return['sales_agent_id'] != "0" ){
                $returns2->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            $returns2 = $returns2->get()->toArray();

            foreach ($returns2 as $key => $row) {
                $returns2[$key]->type = 2;
                $returns2[$key]->sumtion = 2;
            }
        }else{
            $returns2 = array();
        }

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 3){
            $returns3 = DB::table('notice_debtors_m')
                ->leftjoin('notice_debtors_d' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_debtors_d.notice_debtor_m_id')
                ->leftjoin('items', 'notice_debtors_d.item_id' , '=' , 'items.item_id')
                ->leftjoin('taxes', 'items.tax_id' , '=' , 'taxes.tax_id')
                ->leftjoin('branchs' , 'notice_debtors_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('sales_invoice_m' , 'notice_debtors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('customers' , 'notice_debtors_m.customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('notice_payments' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_payments.notice_debtor_m_id')
                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id ,
                    notice_debtors_m.notice_debtor_m_id as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    notice_debtors_m.invoice_date ,

                    notice_debtors_d.item_id as item_id ,
                    items.name_'.$lang.' as  items_name ,
                    taxes.tax_percentage as tax_percentage ,

                    notice_debtors_d.new_price as item_price ,
                    notice_debtors_d.new_quantity as item_quantity ,

                    branchs.name_'.$lang.' as  branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,

                    notice_debtors_m.customer_id as customer_id  ,
                    customers.name_'.$lang.' as customer_name ,

                    sum(notice_debtors_d.new_total_without_vat) as total_price ,
                    sum(notice_debtors_d.new_total_with_vat) as total_with_vat ,
                    sum(notice_debtors_d.new_total_without_vat) as total_without_vat ,
                    sum(notice_debtors_d.new_total_vat) as total_vat ,
                    sum(notice_debtors_d.new_quantity) as total_quantity ,

                    sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
                    sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
                    sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
                ')
                ->groupBy('items.item_id')
                ->where('notice_debtors_m.invoice_date' , '>=' , $this->return['from'] )
                ->where('notice_debtors_m.invoice_date' , '<=' , $this->return['to'] )
                ->where('notice_debtor_active' , '=' , 1);

            if(count($this->return['items']) > 0){
                $returns3->whereIn('items.item_id', $this->return['items']);
            }

            if( $this->return['branch_id'] > 0  ){
                $returns3->where('notice_debtors_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $returns3->whereIn('notice_debtors_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $returns3->where('notice_debtors_d.notice_debtor_m_id' ,  $this->return['invoice_code'] );
            }

            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $returns3->where('notice_payments.payment_type' , $this->return['payment_type'] );
            }

            if( $this->return['sales_agent_id'] != "0" ){
                $returns3->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            $returns3 = $returns3->get()->toArray();

            foreach ($returns3 as $key => $row) {
                $returns3[$key]->type = 3;
                $returns3[$key]->sumtion = 1;
            }
        }else{
            $returns3 = array();
        }

        $this->return['data']           = array_merge($sales  ,$returns2 , $returns3);
        $this->return['data']           = collect( $this->return['data'])->sortByDesc('s_m_id')->values()->all();

        $this->return['chart']          = collect($this->return['data'])->groupBy('items_name')->map(function ($group) {
            return [
                'total_with_vat' => $group->sum('item_price'),
                'quantity' => $group->sum('item_quantity'),
            ];
        });

        $this->return['logo']           = get_logo($this->data['current_branch']);
        $this->return['params_text']    = trans('main.from').":".$this->return['from']." - ".trans('main.to').":".$this->return['to'];

        if(strlen($this->return['invoice_code']))
            $this->return['params_text']  .= trans('main.invoice_code')." ".$this->return['invoice_code'];

        if($this->return['sales_agent_id'] > 0 )
            $this->return['params_text']  .= " - ".trans('main.sales_agent')." ".SalesAgent::get_sales_agent( $this->return['sales_agent_id'] , $this->return['lang'] )->name ?? '';

        switch (@$request['type']) {
            case 'excel':
                $this->return['logo']     = public_path().$this->return['logo'];
                $export = new InvoicesExport($this->return , 'Print/Sales/report/full_report');
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $this->return['logo']     = public_path().$this->return['logo'];
                $pdf = PDF::loadView('Print/Sales/report/full_report', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
                return $pdf->stream();
                break;

            case 'print':
                return view('Print/Sales/report/full_report')->with('data' , $this->return);
                break;
            case 'json':
                return $this->sendResponse( $this->return  );
                // return view('finance/report/account_statment_anal_p')->with('data' , $this->data);
                break;
        }
    }

    public function sales_report_get($lang, Request $request)
    {
        $this->checkPermission('06-013','view');

        App::setLocale($lang);

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-013' , $lang)->sub_title ?? '';
        $this->return['branchs']        = Branch::all_branchs(array('active' => 1, 'lang' => $lang));
        $this->return['barbers']        = Barber::all_barbers(array('active' => 1, 'lang' => $lang));

        $this->return['types']              = array(
            array(
                'id'    => 0 ,
                'title' => trans('main.all')
            ),array(
                'id'    => 1 ,
                'title' => trans('main.sales')
            ),array(
                'id'    => 2 ,
                'title' => trans('main.notice_creditor')
            ),array(
                'id'    => 3 ,
                'title' => trans('main.notice_debtor')
            )
        );

        return $this->sendResponse($this->return);
    }

    public function sales_report_post($lang, Request $request)
    {
        $this->checkPermission('06-013','print');
        App::setLocale($lang);
        $this->return['from']           = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
        $this->return['to']             = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
        $this->return['report_type']    = $request['report_type'] ?? 0;
        $this->return['payment_type']   = $request['payment_type'] ?? 0;
        $this->return['sales_agent_id'] = $request['sales_agent_id'] ?? 0 ;
        $this->return['customer_id']    = $request['customer_id'] ?? 0 ;
        $this->return['invoice_code']   = $request['invoice_code'] ?? 0 ;
        $this->return['barber_id']      = $request['barber_id'] ?? 0 ;
        $this->return['branch_id']      = intval( $request['branch_id'] ?? 0 );
        $this->return['lang']           = $lang ;

        if (isset($this->return['items']) && !is_array($this->return['items'])) {
            $this->return['items'] = explode(',' , $this->return['items']);
        }

        $branch = Branch::get_branch($this->data['current_branch'] , 'en');

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 1){
            $query = DB::table('sales_invoice_m')
                // ->leftjoin('sales_invoice_d', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
                ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
                ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
                ->leftjoin('users', 'sales_invoice_m.add_user' , '=' , 'users.id')
                ->leftjoin('branchs', 'sales_invoice_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
                ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
                ->leftjoin('barber_m', 'sales_invoice_m.barber_id', '=', 'barber_m.barber_m_id')

                ->leftjoin('barber_bookings', 'sales_invoice_m.sales_invoice_m_id', '=', 'barber_bookings.b_invoice_id')
                ->leftjoin('barber_m as req_barber', 'barber_bookings.barber_id', '=', 'req_barber.barber_m_id')

                ->groupBy('sales_invoice_m.sales_invoice_m_id')
                // ->where('sales_invoice_m.branch_id', '=', $this->return['branch_id'])
                ->where('sales_invoice_m.sales_invoice_date' , '>=' , $this->return['from']." 00:00:00")
                ->where('sales_invoice_m.sales_invoice_date' , '<=' , $this->return['to']." 23:59:59")
                ->where('sales_invoice_active' , '=' , 1)

                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id  ,
                    0 as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    sales_invoice_m.sales_invoice_date as invoice_date ,
                    branchs.name_'.$lang.' as branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,
                    sales_invoice_m.customer_id as customer_id  ,
                    customers.name_'.$lang.' as customer_name ,
                    barber_m.name_'.$lang.' as barber_name ,
                    req_barber.name_'.$lang.' as booking_barber_name ,
                    users.user_full_name as user_full_name ,

                    sales_invoice_m.items_count as total_quantity ,

                    ( sales_invoice_m.total_without_vat + sales_invoice_m.discount ) as total_price ,

                    sales_invoice_m.discount as discount ,

                    sales_invoice_m.total_vat as total_vat ,
                    sales_invoice_m.total_with_vat as total_with_vat ,
                    sales_invoice_m.total_without_vat as total_without_vat ,

                    sales_invoice_types.sales_invoice_type_title_'.$lang.' as payment_type,
                    payment_methods.payment_method_id as payment_type_id ,

                    sum( case when sales_invoice_types.sales_invoice_type_id = 1 then ( sales_invoice_m.total_with_vat  ) end ) as term_sales ,
                    sum( case when sales_invoice_payments.payment_type = 1 then sales_invoice_payments.amount end ) as paid_cash ,
                    sum( case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end ) as paid_bank ,
                    sum( case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end ) as paid_trans
                ');

            if( $this->return['branch_id'] > 0  ){
                $query->where('sales_invoice_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $query->whereIn('sales_invoice_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if( $this->return['sales_agent_id'] != "0" ){
                $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $query->where('sales_invoice_m.sales_invoice_m_id' , $this->return['invoice_code'] );
            }

            if(isset($this->return['barber_id']) && ($this->return['barber_id']) > 0){
                $query->where('sales_invoice_m.barber_id' , $this->return['barber_id'] );
            }

            if(isset($this->return['customer_id']) && ($this->return['customer_id']) > 0){
                $query->where('sales_invoice_m.customer_id' , $this->return['customer_id'] );
            }


            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $query->where('sales_invoice_payments.payment_type' , $this->return['payment_type']);
            }

            $sales = $query->get()->toArray();

            foreach ($sales as $key => $row) {
                $sales[$key]->type = 1;
                $sales[$key]->sumtion = 1;
            }
        }else{
            $sales = array();
        }

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 2){
            $returns2 = DB::table('notice_creditors_m')
                ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
                ->leftjoin('branchs' , 'notice_creditors_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('items' , 'notice_creditors_d.item_id' , '=' , 'items.item_id')
                ->leftjoin('taxes' , 'items.tax_id' , '=' , 'taxes.tax_id')
                ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
                ->leftjoin('barber_m', 'sales_invoice_m.barber_id', '=', 'barber_m.barber_m_id')
                ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
                ->leftjoin('barber_bookings', 'sales_invoice_m.sales_invoice_m_id', '=', 'barber_bookings.b_invoice_id')
                ->leftjoin('barber_m as req_barber', 'barber_bookings.barber_id', '=', 'req_barber.barber_m_id')
                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('customers' , 'notice_creditors_m.customer_id' , '=' , 'customers.customer_id')

                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id ,
                    notice_creditors_m.notice_creditor_m_id as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    notice_creditors_m.invoice_date ,

                    branchs.name_'.$lang.' as  branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,

                    sales_invoice_m.customer_id,
                    customers.name_'.$lang.' as customer_name ,
                    barber_m.name_'.$lang.' as barber_name ,
                    req_barber.name_'.$lang.' as booking_barber_name ,

                    0 as discount ,
                    sales_invoice_types.sales_invoice_type_title_'.$lang.' as payment_type,

                    sum(notice_creditors_d.new_total_without_vat) as total_price ,
                    sum(notice_creditors_d.new_total_with_vat) as total_with_vat ,
                    sum(notice_creditors_d.new_total_without_vat) as total_without_vat ,
                    sum(notice_creditors_d.new_total_vat) as total_vat ,
                    sum(notice_creditors_d.new_quantity) as total_quantity ,

                    sum( case when sales_invoice_types.sales_invoice_type_id = 1 then ( notice_creditors_d.new_total_with_vat ) end ) as term_sales

                ')
                ->groupBy('notice_creditors_m.notice_creditor_m_id')
                ->where('notice_creditors_m.invoice_date' , '>=' , $this->return['from'] )
                ->where('notice_creditors_m.invoice_date' , '<=' , $this->return['to'] )
                ->where('notice_creditor_active' , '=' , 1);

            if( $this->return['branch_id'] > 0  ){
                $returns2->where('notice_creditors_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $returns2->whereIn('notice_creditors_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $returns2->where('notice_creditors_d.notice_creditor_m_id' ,  $this->return['invoice_code'] );
            }

            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $returns2->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
                        ->where('notice_payments.payment_type' , $this->return['payment_type'] );
            }

            if(isset($this->return['barber_id']) && ($this->return['barber_id']) > 0){
                $query->where('sales_invoice_m.barber_id' , $this->return['barber_id'] );
            }

            if( $this->return['sales_agent_id'] != "0" ){
                $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            $returns2 = $returns2->get()->toArray();

            foreach ($returns2 as $key => $row) {
                $returns2[$key]->paid_cash  = DB::table('notice_payments')->where('notice_creditor_m_id' , $row->r_m_id)->where('payment_type' , 1)->sum('amount');
                $returns2[$key]->paid_bank  = DB::table('notice_payments')->where('notice_creditor_m_id' , $row->r_m_id)->where('payment_type' , 2)->sum('amount');
                $returns2[$key]->paid_trans = DB::table('notice_payments')->where('notice_creditor_m_id' , $row->r_m_id)->where('payment_type' , 3)->sum('amount');
                $returns2[$key]->type       = 2;
                $returns2[$key]->sumtion    = 2;
            }
        }else{
            $returns2 = array();
        }

        if($this->return['report_type'] == 0 || $this->return['report_type'] == 3){
            $returns3 = DB::table('notice_debtors_m')
                ->leftjoin('notice_debtors_d' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_debtors_d.notice_debtor_m_id')
                ->leftjoin('branchs' , 'notice_debtors_m.branch_id' , '=' , 'branchs.branch_id')
                ->leftjoin('items' , 'notice_debtors_d.item_id' , '=' , 'items.item_id')
                ->leftjoin('taxes' , 'items.tax_id' , '=' , 'taxes.tax_id')
                ->leftjoin('sales_invoice_m' , 'notice_debtors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
                ->leftjoin('barber_m', 'sales_invoice_m.barber_id', '=', 'barber_m.barber_m_id')
                ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')

                ->leftjoin('barber_bookings', 'sales_invoice_m.sales_invoice_m_id', '=', 'barber_bookings.b_invoice_id')
                ->leftjoin('barber_m as req_barber', 'barber_bookings.barber_id', '=', 'req_barber.barber_m_id')



                ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
                ->leftjoin('customers' , 'notice_debtors_m.customer_id' , '=' , 'customers.customer_id')
                //
                ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as s_m_id ,
                    notice_debtors_m.notice_debtor_m_id as r_m_id ,
                    sales_invoice_m.sales_invoice_m_id as invoice_code ,
                    notice_debtors_m.invoice_date ,

                    branchs.name_'.$lang.' as  branch_name ,
                    sales_agents.name_'.$lang.' as  sales_agent_name ,

                    sales_invoice_m.customer_id,
                    customers.name_'.$lang.' as customer_name ,
                    barber_m.name_'.$lang.' as barber_name ,
                    req_barber.name_'.$lang.' as booking_barber_name ,

                    0 as discount ,

                    sum(notice_debtors_d.new_total_without_vat) as total_price ,
                    sum(notice_debtors_d.new_total_with_vat) as total_with_vat ,
                    sum(notice_debtors_d.new_total_without_vat) as total_without_vat ,
                    sum(notice_debtors_d.new_total_vat) as total_vat ,
                    sum(notice_debtors_d.new_quantity) as total_quantity ,
                    sales_invoice_types.sales_invoice_type_title_'.$lang.' as payment_type,

                    sum( case when sales_invoice_types.sales_invoice_type_id = 1 then ( sales_invoice_m.total_without_vat + sales_invoice_m.discount ) end ) as term_sales
                ')
                ->groupBy('notice_debtors_m.notice_debtor_m_id')
                ->where('notice_debtors_m.invoice_date' , '>=' , $this->return['from'] )
                ->where('notice_debtors_m.invoice_date' , '<=' , $this->return['to'] )
                ->where('notice_debtor_active' , '=' , 1);

            if( $this->return['branch_id'] > 0  ){
                $returns3->where('notice_debtors_m.branch_id' , '=' , $this->return['branch_id'] );
            }else{
                $returns3->whereIn('notice_debtors_m.branch_id' , array_keys($this->data['branchs']) );
            }

            if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
                $returns3->where('notice_debtors_d.notice_debtor_m_id' ,  $this->return['invoice_code'] );
            }

            if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
                $returns3->leftjoin('notice_payments' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_payments.notice_debtor_m_id')
                    ->where('notice_payments.payment_type' , $this->return['payment_type'] );
            }

            if(isset($this->return['barber_id']) && ($this->return['barber_id']) > 0){
                $query->where('sales_invoice_m.barber_id' , $this->return['barber_id'] );
            }

            if( $this->return['sales_agent_id'] != "0" ){
                $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
            }

            $returns3 = $returns3->get()->toArray();

            foreach ($returns3 as $key => $row) {

                $returns3[$key]->paid_cash  = DB::table('notice_payments')->where('notice_debtor_m_id' , $row->r_m_id)->where('payment_type' , 1)->sum('amount');
                $returns3[$key]->paid_bank  = DB::table('notice_payments')->where('notice_debtor_m_id' , $row->r_m_id)->where('payment_type' , 2)->sum('amount');
                $returns3[$key]->paid_trans = DB::table('notice_payments')->where('notice_debtor_m_id' , $row->r_m_id)->where('payment_type' , 3)->sum('amount');
                $returns3[$key]->type       = 3;
                $returns3[$key]->sumtion    = 1;
            }
        }else{
            $returns3 = array();
        }

        $this->return['data']           = array_merge($sales  ,$returns2 , $returns3);
        $this->return['data']           = collect( $this->return['data'])->sortByDesc('s_m_id')->values()->all();

        $this->return['chart'] = collect($this->return['data'])->groupBy('invoice_date')->map(function ($group) {
            return [
                'total_with_vat' => $group->sum('total_with_vat'),
                'quantity' => $group->count('s_m_id'),
            ];
        });

        $this->return['logo']           = get_logo($this->data['current_branch']);
        $this->return['params_text']    = trans('main.from').":".$this->return['from']." - ".trans('main.to').":".$this->return['to'];

        if(strlen($this->return['invoice_code']))
            $this->return['params_text']  .= trans('main.invoice_code')." ".$this->return['invoice_code'];

        if($this->return['sales_agent_id'] > 0 )
            $this->return['params_text']  .= " - ".trans('main.sales_agent')." ".SalesAgent::get_sales_agent( $this->return['sales_agent_id'] , $this->return['lang'] )->name ?? '';

        return $this->sendPrint($request['type'] ?? 'print' ,'Print/Sales/report/full_report',  $this->return);
    }

    public function sales_weekly_report($lang, Request $request)
    {
        $this->checkPermission('06-010','view');

        $first  = ( date("l") == "Saturday"? date("Y-m-d"):date("Y-m-d" , strtotime("-1 Saturday")));
        for ($i=0; $i < 5; $i++) {

            $days       = $i * 7;
            $from_date  = date("Y-m-d" , strtotime($first." -".($days+6)." days"));
            $to_date    = date("Y-m-d" , strtotime($first." -".($days)." days"));

            $this->return[$from_date." | ".$to_date] = DB::table('sales_invoice_m')
                ->leftJoin('sales_invoice_d','sales_invoice_d.sales_invoice_m_id','sales_invoice_m.sales_invoice_m_id')
                ->whereBetween('sales_invoice_date',[$from_date,$to_date])
                ->selectRaw('
                    ifnull( count(distinct sales_invoice_m.sales_invoice_m_id), 0 ) as order_count ,
                    ifnull( count(sales_invoice_d.sales_invoice_d_id) , 0 ) as service_count ,
                    ifnull( sum(sales_invoice_d.quantity) , 0 ) as service_count_q ,
                    ifnull( sum(sales_invoice_d.total_with_vat) , 0 ) as total_price
                ')->first();

        }

        return $this->sendResponse( $this->return );

    }

    public function sales_monthly_report($lang, Request $request)
    {
        $this->checkPermission('06-010','view');


        $from_month   = Carbon::parse( date("Y-m-01" , strtotime($request['from_month'])) );
        $to_month     = Carbon::parse( date("Y-m-t" , strtotime($request['to_month'])) );
        $diff         = $from_month->diffInMonths($to_month);

        for ($i=0; $i <= $diff; $i++) {
            $this->return[date("Y-m-01" , strtotime($request['from_month']." +".($i)." months"))] = DB::table('sales_invoice_m')
                ->leftJoin('sales_invoice_d','sales_invoice_d.sales_invoice_m_id','sales_invoice_m.sales_invoice_m_id')
                ->where('sales_invoice_date', 'like' , date("Y-m-" , strtotime($request['from_month']." +".($i)." months"))."%" )
                ->selectRaw('
                    ifnull( count(distinct sales_invoice_m.sales_invoice_m_id), 0 ) as order_count ,
                    ifnull( count(sales_invoice_d.sales_invoice_d_id) , 0 ) as service_count ,
                    ifnull( sum(sales_invoice_d.quantity) , 0 ) as service_count_q ,
                    ifnull( sum(sales_invoice_d.total_with_vat) , 0 ) as total_price
                ')->first();
        }

        return $this->sendResponse( $this->return );

    }

    public function customer_statement_report_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-014'][0]->permission ?? [] ?? [] )){
            return $this->sendError('view permission needed #06-014', $this->data, 200);
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-012' , $lang)->sub_title ?? '';
        $this->return['customers']      = Customer::all_customers(array('active' => 1, 'lang' => $lang ,  'is_search' => 1));


//         if( isset( $_GET['xx'] ) ){
//             $x = DB::select("SELECT sales_invoice_m.`sales_invoice_m_id` , sales_invoice_m.`sales_invoice_type_id` , sales_invoice_m.total_with_vat, sum(amount) as total FROM `sales_invoice_m`
// left join sales_invoice_payments on sales_invoice_m.`sales_invoice_m_id` = sales_invoice_payments.`sales_invoice_m_id`
// WHERE `sales_invoice_type_id` in (2,3,4)
// GROUP by sales_invoice_m.`sales_invoice_m_id`
// HAVING total is null;");


//             foreach ($x as $key => $row) {
//                 $seed = [
//                     'sales_invoice_m_id' => $row->sales_invoice_m_id ,
//                     'machine_id'         => 0 ,
//                     'treasury_id'        => 1 ,
//                     'payment_type'       => 1 ,
//                     'card_type'          => 0 ,
//                     'payment_text'       => 'Cash' ,
//                     'amount'             => $row->total_with_vat
//                 ];


//                 if($row->sales_invoice_type_id == 3 ){
//                     $seed['treasury_id']    = 0 ;
//                     $seed['machine_id']     = 1 ;
//                     $seed['payment_type']   = 2 ;
//                     $seed['card_type']      = 4 ;
//                     $seed['payment_text']   = 'network' ;
//                 }

//                 // DB::table('sales_invoice_payments')->insert($seed);

//             }
//         return $this->sendResponse( $x  );


        // }
        return $this->sendResponse( $this->return  );


    }


    public function customer_statement_report_post($lang, Request $request)
    {

        if(!@in_array('1', $this->data['mypermissions']['06-014'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-014', $this->data, 200);
         }

        $this->return['from']         = $request['from'] ?? date("Y-m-01");
        $this->return['to']           = $request['to'] ?? date("Y-m-t");
        $this->return['customer_id']  = $request['customer_id'] ?? 0 ;
        $this->return['with_notes']  = $request['with_notes'] ?? 0 ;

        $this->return['first']        = CustomerStatmentReportHelper::get_account_customer_statment($request['customer_id'],$lang , array('total' => true , 'before' => $this->return['from'] , 'first' => 1,'with_notes' => $this->return['with_notes']));
        $this->return['action']       = CustomerStatmentReportHelper::get_account_customer_statment($request['customer_id'],$lang , array('from' => $this->return['from']  , 'to' => $this->return['to'],'with_notes' => $this->return['with_notes'] ) );

       return $this->sendResponse( $this->return);

    }

    public function customer_balances_report_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-015'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-015', $this->data, 200);
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-015' , $lang)->sub_title ?? '';
        $this->return['customers']      = Customer::all_customers(array('active' => 1, 'lang' => $lang ,  'is_search' => 1));
        return $this->sendResponse( $this->return  );

    }

    public function customer_balances_report_post($lang, Request $request)
    {

        if(!@in_array('1', $this->data['mypermissions']['06-015'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-015', $this->data, 200);
         }

        $this->return['from']           = $request['from'] ?? date("Y-m-01");
        $this->return['to']             = $request['to'] ?? date("Y-m-t");
        $this->return['is_credit']      = $request['is_credit'] ?? 1;
        $this->return['is_debit']       = $request['is_debit'] ?? 1;
        $this->return['has_balance']    = $request['has_balance'] ?? 1;

        $this->return['report']     = [];

        $customers = Customer::all_customers(['active' => 1 , 'lang' => $lang]);
        foreach ($customers as $key => $value) {
            $f= CustomerStatmentReportHelper::get_account_customer_statment($value->id , $lang , array('total' => true , 'before' => $this->return['from'], 'first' => 1 ) );
            $a= CustomerStatmentReportHelper::get_account_customer_statment($value->id , $lang , array('total' => true , 'from' => $this->return['from'] , 'to' => $this->return['to'] ) );
            $balance = $f->total + $a->debit - $a->credit ;

            if(($this->return['is_credit'] == 0 && $this->return['is_debit'] == 1) && ($balance < 0 || $balance == 0)){
                continue;
            }

            if(($this->return['is_debit'] == 0 && $this->return['is_credit'] == 1) && ($balance > 0 || $balance == 0)){
                continue;
            }

            if($this->return['has_balance'] == 1 && $balance  == 0 ){
                continue;
            }

                $this->return['report'][] = [
                    'id'    => $value->id,
                    'name'  => $value->name,
                    'first' => $f->total,
                    'debit' => $a->debit,
                    'credit'=> $a->credit
                ];

        }

       return $this->sendResponse( $this->return);
    }





    public function purchase_vendor_statement_report_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-019'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-019', $this->data, 200);
        }

        $this->return['screen_name']  = ScreenSub::get_screen_sub_by_screen_code('06-019' , $lang)->sub_title ?? '';
        $this->return['items']        = PurchasesVendor::all_purchases_vendors(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse( $this->return  );
    }

    public function purchase_vendor_statement_report_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-019'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-019', $this->data, 200);
         }

        $this->return['from']                = $request['from'] ?? date("Y-m-01");
        $this->return['to']                  = $request['to'] ?? date("Y-m-t");
        $this->return['purchase_vendor_id']  = $request['purchase_vendor_id'] ?? 0 ;
        $this->return['first']               = PurchaseVendorStatmentReportHelper::get_account_purchase_vendor_statment($request['purchase_vendor_id'] , $lang ,  array('total' => true , 'before' => $this->return['from'] ) );
        $this->return['action']              = PurchaseVendorStatmentReportHelper::get_account_purchase_vendor_statment($request['purchase_vendor_id'],$lang , array('from' => $this->return['from']  , 'to' => $this->return['to'] ) );

       return $this->sendResponse( $this->return);
    }
    public function daily_report_get($lang)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-024'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-024', $this->data, 200);
        }

        $this->return['treasurys']  = Treasury::all_treasury(['lang' => $lang, 'active' => 1]);
        $this->return['branchs']    = Branch::all_branchs(array('active' => 1, 'lang' => $lang , 'user' => auth()->user()->id ));

       return $this->sendResponse( $this->return);
    }

    public function daily_report_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-024'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-024', $this->data, 200);
        }
        $parrams  =array(
            'lang'          => $lang,
            'treasury_id'   => $request['treasury_id'] ?? null,
            'branch_id'     => $request['branch_id'] ?? null ,
            'date'          => $request['date'] ?? date('Y:m:d'),
            'first'         => $request['first'] ?? 0,
        );

        $this->return['report']   = (new DailyReportHelper)->get_daily_report($parrams);

       return $this->sendResponse( $this->return);
    }
    public function full_daily_report_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-024'][0]->permission ?? [])){
            return $this->sendError('view permission needed #06-024', $this->data, 200);
        }
        $parrams  =array(
            'lang'          => $lang,
            'treasury_id'   => $request['treasury_id'] ?? null,
            'branch_id'     => $request['branch_id'] ?? null ,
            'date'          => $request['date'] ?? date('Y:m:d'),
            'first'         => $request['first'] ?? 0,
        );

        $this->return['report']   = (new DailyReportHelper)->get_full_daily_report($parrams);

       return $this->sendResponse( $this->return);
    }


    public function debt_age_report($lang, Request $request)
    {

        $this->checkPermission('06-012','view');

        $this->return['from']                = $request['from'] ?? date("Y-m-01");
        $this->return['to']                  = $request['to'] ?? date("Y-m-t");
        $this->return['action']              = DeptAgeReportHelper::debt_age_report($lang , array('from' => $this->return['from']  , 'to' => $this->return['to'] ) );

       return $this->sendResponse( $this->return);
    }



}
