<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Classes\General\Upload;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\Sales\CustomerHelper;
use App\Classes\Sales\CustomerStatmentReportHelper;
use App\Models\Sales\CustomerType;
use App\Models\Sales\SalesAgent;
use App\Models\Sales\SalesArea;
use Illuminate\Http\Request;
use App\Models\Finance\AccountTree;
use App\Models\Sales\Customer;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use DB;
use Illuminate\Validation\Rule;

class CustomerController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('view permission needed #06-003', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-003', $lang)->sub_title ?? '';
        $this->return['items']       = Customer::all_customers($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('create permission needed #06-003', [], 200);
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-003', $lang)->sub_title ?? '';
        $this->return['customer_types'] = CustomerType::all_customer_types(array('active' => 1, 'lang' => $lang));
        $this->return['sales_areas']    = SalesArea::all_sales_areas(array('active' => 1, 'lang' => $lang));
        $this->return['sales_agents']   = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2, 'active' => 1));
        $this->return['currencys']      = DB::table('currencys')->select('currency_id as id', 'name_'.$lang.' as name')->get();
        $this->return['defaults']       = array(
            'account_tree_id' => intval( Setting::get_main_setting_by_code('default_customer_account')->value ?? 0 )

        );

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('create permission needed #06-003', [], 200);
        }

        $insert = $request->only(['name_en', 'name_ar', 'address', 'sales_area_id', 'commercial_registeration_no',
                                  'vat_register_number','check_balance' ,'default_currency_id', 'customer_behaviour_type',
                                  'sales_agent_id', 'maximum_term_value', 'term_period', 'customer_type_id',
                                  'account_tree_id', 'phone', 'job_title', 'notes' , 'customer_invoice_type','first_term_balance','balance_nature' ]);

        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, Customer::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();
        $insert['balance_nature']       = $insert['balance_nature'] ?? 1;
        $insert['first_term_balance']   = $insert['first_term_balance'] ?? 0;
        $this->return['id'] = Customer::add_customer($insert);

        if (isset($request['customer_contacts']) && is_array($request['customer_contacts'])) {
            foreach ($request['customer_contacts'] as $customer_contact) {
                DB::table('customer_contacts')
                    ->insert([
                        'customer_id' => $this->return['id'],
                        'name'        => $customer_contact['name'],
                        'phone'       => $customer_contact['phone'],
                    ]);
            }
        }


        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('show permission needed #06-003', [], 200);
        }

        $this->return['screen_name']          = ScreenSub::get_screen_sub_by_screen_code('06-003', $lang)->sub_title ?? '';
        $this->return['data']                 = Customer::get_customer($id, $lang);
        $this->return['customer_attachments'] = Customer::get_customer_attachments($id);
        $this->return['customer_contacts']    = Customer::get_customer_contacts($id);
        $this->return['customer_types']       = CustomerType::all_customer_types(array('active' => 1, 'lang' => $lang));
        $this->return['sales_areas']          = SalesArea::all_sales_areas(array('active' => 1, 'lang' => $lang));
        $this->return['sales_agents']         = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['account_trees']        = AccountTree::active_account_trees($lang , array('account_type' => 2, 'active' => '1'));
        $this->return['currencys']            = DB::table('currencys')->select('currency_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }
    public function customer_info($lang, $id)
    {
        // check if customer exists
        $customer = Customer::find($id);
        if (!$customer) {
            return $this->sendError(trans('error.Customer Not Found'));
        }
        $this->return['screen_name']          = ScreenSub::get_screen_sub_by_screen_code('06-003', $lang)->sub_title ?? '';
        $this->return['data']                 = Customer::get_customer($id, $lang);
        $this->return['data']->customer_balance = CustomerStatmentReportHelper::get_account_customer_statment($this->return['data']->id,$lang , array('total' => true , 'before' => date('Y-m-d') , 'first' => 1 ) );

        return $this->sendResponse($this->return);
    }
    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('show permission needed #06-003', [], 200);
        }

        if(!(new CustomerHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update = $request->only(['name_en', 'name_ar', 'address', 'sales_area_id', 'commercial_registeration_no',
                                  'vat_register_number','check_balance' , 'default_currency_id', 'customer_behaviour_type',
                                  'sales_agent_id', 'maximum_term_value', 'term_period', 'customer_type_id',
                                  'account_tree_id', 'phone', 'job_title', 'notes' , 'customer_invoice_type' , 'first_term_balance' , 'balance_nature' ]);


        $update_rule['name_en'] = [
            'required',
            'string',
            Rule::unique('customers')->ignore($id,'customer_id'),
        ];
        $update_rule['name_ar'] = [
            'required',
            'string',
            Rule::unique('customers')->ignore($id,'customer_id'),
        ];



        $validator = validator()->make($update, $update_rule);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        // If Customer Contacts Updated
        DB::table('customer_contacts')->where('customer_id', $id)->delete();
        if (isset($request['customer_contacts']) && is_array($request['customer_contacts'])) {
            foreach ($request['customer_contacts'] as $customer_contact) {
                DB::table('customer_contacts')
                    ->insert([
                        'customer_id' => $id,
                        'name'        => $customer_contact['name'],
                        'phone'       => $customer_contact['phone'],
                    ]);
            }
        }

        Customer::update_customer($update, $id);

        DB::commit();
        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('delete permission needed #06-003', [], 200);
        }

        if(!(new CustomerHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        Customer::delete_customer($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = Customer::find($id);

        if($item->customer_active){
            if(!@in_array('4', $this->data['mypermissions']['06-003'][0]->permission)){
                return $this->sendError('update permission needed #06-003', [], 200);
            }

            if(!(new CustomerHelper)->can_edit_or_delete($id)){
                return $this->sendError( trans('error.delete_fails'), []);
            }

            Customer::delete_customer($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['06-003'][0]->permission)){
                return $this->sendError('update permission needed #06-003', [], 200);
            }

            if(!(new CustomerHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            Customer::update_customer(array('customer_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function upload_customer_attachment($lang, $id, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('view permission needed #06-003', $this->data, 200);
        }

                $upload = (new Upload)->uploadFile($request['file_path'], 'customer_attachments',$request['file_name']);
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));
                DB::table('customer_attachments')->insert([
                    'customer_id'    => $id,
                    'file_name'      => $upload['filename'],
                    'file_path'      => $upload['url'],
                    'file_extension' => $upload['extension'],
                    'add_user'       => auth()->user()->id,
                ]);



        return $this->sendResponse([], trans('main.Attachments Uploaded Successfully'));
    }

    public function download_customer_attachment($lang, $id, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('view permission needed #06-003', $this->data, 200);
        }

        $row = DB::table('customer_attachments')
            ->where('customer_attachment_id', $id)
            ->first();

        return response()->file(public_path().$row->file_path);
    }

    public function delete_customer_attachment($lang, $attachment_id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-003'][0]->permission)){
            return $this->sendError('delete permission needed #06-003', [], 200);
        }

        Customer::delete_customer_attachment($attachment_id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function customer_attachment_toggle_active($lang, $attachment_id)
    {
        $item = DB::table('customer_attachments')->where('customer_attachment_id', $attachment_id)->first();

        if($item->customer_attachment_active){
            if(!@in_array('4', $this->data['mypermissions']['06-003'][0]->permission)){
                return $this->sendError('update permission needed #06-003', [], 200);
            }

            Customer::delete_customer_attachment($attachment_id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['06-003'][0]->permission)){
                return $this->sendError('update permission needed #06-003', [], 200);
            }

            DB::table('customer_attachments')
                ->where('customer_attachment_id', $attachment_id)
                ->update([
                    'customer_attachment_active' => 1
                ]);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
    public function get_customer_balance($lang, $id)
    {
        $this->checkPermission('06-003','view');

        $this->return['payments'] = DB::table('quotations_payments')
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->where('elevators_quotations.customer_id', $id)
            ->where('remaining','>',0)
            ->where('elevators_quotations.active', 1)
            ->get();

            return $this->sendResponse($this->return,[]);
        }
}
