<?php

namespace App\Http\Controllers\API\V1\Purchases;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Purchases\PurchasesAgent;
use Illuminate\Http\Request;
use App\Classes\Purchases\PurchasesAgentHelper;
use App\Models\Main\ScreenSub;
use Illuminate\Validation\Rule;

class PurchasesAgentController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('view permission needed #04-001', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('04-001', $lang)->sub_title ?? '';
        $this->return['items']       = PurchasesAgent::all_purchases_agents($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('create permission needed #04-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('04-001', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('create permission needed #04-001', [], 200);
        }

        $insert             = $request->only(['name_en', 'name_ar']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, PurchasesAgent::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = PurchasesAgent::add_purchases_agent($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang , $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('show permission needed #04-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('04-001', $lang)->sub_title ?? '';
        $this->return['data']        = PurchasesAgent::get_purchases_agent($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('show permission needed #04-001', [], 200);
        }

        if(!(new PurchasesAgentHelper())->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update     = $request->only(['name_en', 'name_ar']);
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('purchases_agents')->ignore($id,'purchases_agent_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('purchases_agents')->ignore($id,'purchases_agent_id'),
            ]
        ];
        $validator  = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        PurchasesAgent::update_purchases_agent($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['04-001'][0]->permission)){
            return $this->sendError('delete permission needed #04-001', [], 200);
        }

        if(!(new PurchasesAgentHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        PurchasesAgent::delete_purchases_agent($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = PurchasesAgent::find($id);

        if($item->purchases_agent_active){
            if(!@in_array('4', $this->data['mypermissions']['04-001'][0]->permission)){
                return $this->sendError('update permission needed #04-001', [], 200);
            }

            if(!(new PurchasesAgentHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            PurchasesAgent::delete_purchases_agent($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['04-001'][0]->permission)){
                return $this->sendError('update permission needed #04-001', [], 200);
            }

            if(!(new PurchasesAgentHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            PurchasesAgent::update_purchases_agent(array('purchases_agent_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
