<?php

namespace App\Http\Controllers\API\V1\POS;
use App\Classes\ItemStock;
use App\Classes\Sales\SalesOrderHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Main\ScreenSub;
use App\Models\POS\SalesOrder;
use Illuminate\Http\Request;
use DB;

class SalesOrderController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_sales_orders($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-008'][0]->permission)){
            return $this->sendError('view permission needed #06-008', $this->data, 200);
        }

        $this->filter = array(
            'lang'      => $lang ,
            'active'    => $request['active'] ?? 1 ,
            'status'    => $request['status'] ?? 1 ,
            'rows'      => $request['rows'] ?? 20 ,
            'page'      => $request['page'] ?? 1 ,
            'from_date' => $request['from_date'] ?? null ,
            'to_date'   => $request['to_date'] ?? null ,
            'word'      => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['items']       = SalesOrder::all_sales_orders($this->filter);

        return $this->sendResponse($this->return);
    }

    public function get_sales_order($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-008'][0]->permission)){
            return $this->sendError('show permission needed #06-008', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['master']      = SalesOrder::get_sales_order_m($id, $lang);
        $this->return['details']     = SalesOrder::get_sales_order_d($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function add_sales_order($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-008'][0]->permission)){
            return $this->sendError('create permission needed #06-008', [], 200);
        }

        $insert       = $request->all();
        $branch_id    = $this->data['shift']->branch_id ?? 0;
        $warehouse_id = DB::table('branchs')->where('branch_id', $branch_id)->value('default_warehouse');
        $insert['sales_order_date'] = date('Y-m-d');

        if($branch_id == 0){
            return $this->sendError(trans("Shift is Not Started"));
        }

        $year = array_search(date("Y", strtotime($insert['sales_order_date'])), $this->data['years']);

        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        if(!isset($insert['sales_agent_id']) || intval($insert['sales_agent_id']) < 1){
            return $this->sendError(trans("Sales Agent Error"));
        }

        if(!isset($insert['items']) || count($insert['items']) < 1){
            return $this->sendError(trans("Error In Items"));
        }

        $master_seed = [
            'branch_id'               => $branch_id,
            'finance_year_id'         => $year,
            'customer_id'             => $insert['customer_id'],
            'sales_order_date'        => $insert['sales_order_date'],
            'sales_order_description' => 'POS Order',
            'supply_order'            => 'POS Supply Order',
            'sales_order_type_id'     => $insert['sales_order_type_id'] ?? 1,
            'sales_agent_id'          => $insert['sales_agent_id'],
            'invoice_discount'        => $insert['invoice_discount'] ?? 0,
            'discount_type'           => $insert['discount_type'] ?? 0,
            'discount'                => $insert['discount'] ?? 0,
            'items_count'             => collect($insert['items'])->count(),
            'add_user'                => auth()->user()->id
        ];

        DB::beginTransaction();

        $m_id = SalesOrder::add_sales_order_m($master_seed);

        if (isset($insert['items']) && is_array($insert['items'])){

            // Calculate Items Total Price
            $items_total_price = 0;
            foreach ($insert['items'] as $item){
                $items_total_price += $item['price'] * $item['quantity'];
            }

            foreach ($insert['items'] as $item){

                $item_check = (new ItemStock)->get_item_stock(array('item' => $item['item_id'], 'warehouse' => $warehouse_id));

                if(!isset($item_check[0])){
                    DB::rollback();
                    return $this->sendError(trans("Item Not Found"));
                }

                $tax_percentage = DB::table('taxes')
                    ->where('tax_id', $item['tax_percent_id'] ?? 0)
                    ->value('tax_percentage');

                if (isset($item['unit_id']) && !is_null($item['unit_id'])){
                    $selectedItem = DB::table('items')
                        ->where('item_id', $item['item_id'])
                        ->first();
                    if ($item['unit_id'] == $selectedItem->big_unit_id){
                        $item['unit_type'] = 3;
                    }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
                        $item['unit_type'] = 2;
                    }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
                        $item['unit_type'] = 1;
                    }
                }

                $total_price = ($item['price'] * $item['quantity']);

                $discount     = ($insert['discount_type'] == 1) ? $insert['discount'] : (($items_total_price) * ($insert['discount'] / 100));
                $discount_per = ($discount / $items_total_price);
                $total_price_after_discount = (($item['price'] * $item['quantity']) - ($discount_per * ($item['price'] * $item['quantity'])));
                $item_price_after_discount  = ($total_price_after_discount / $item['quantity']);

                $details_seed = array(
                    'sales_order_m_id'           => $m_id,
                    'item_id'                    => $item['item_id'],
                    'warehouse_id'               => $warehouse_id,
                    'unit_id'                    => $item['unit_id'],
                    'unit_type'                  => $item['unit_type'] ?? 0,

                    'quantity'                   => $item['quantity'] ?? 0,
                    'price'                      => $item['price'],
                    'total_price'                => $total_price,
                    'tax_percent_id'             => $item['tax_percent_id'] ?? 0,

                    'total_vat'                  => ($total_price_after_discount) * (($tax_percentage ?? 15) / 100),
                    'total_without_vat'          => ($total_price_after_discount),
                    'total_with_vat'             => ($total_price_after_discount) + (($total_price_after_discount) * (($tax_percentage ?? 15) / 100)),

                    'discount_per'               => $discount_per,
                    'discount'                   => ($discount_per * $total_price),

                    'total_price_after_discount' => $total_price_after_discount,
                    'item_price_after_discount'  => $item_price_after_discount,

                    'add_user'                   => auth()->user()->id
                );

                $d_id = SalesOrder::add_sales_order_d($details_seed);
            }
        }

        $updateMasterValues = (new SalesOrderHelper)->update_master_values($m_id);

        DB::commit();
        return $this->sendResponse([], trans('main.add_success'));
    }

    public function delete_sales_order($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-008'][0]->permission)){
            return $this->sendError('delete permission needed #06-008', [], 200);
        }

        $master = SalesOrder::get_sales_order_m($id);

        if(!isset($master->sales_order_m_id) || $master->branch_id != $this->data['current_branch']){
            return $this->sendError(trans("error.delete_fail"));
        }

        SalesOrder::delete_sales_order_m($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }
}
