<?php

namespace App\Http\Controllers\API\V1\POS;
use App\Classes\Excel\InvoicesExport;
use App\Classes\ItemStock;
use App\Classes\Sales\SalesInvoiceHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Finance\Tax;
use App\Models\Inventory\Category;
use App\Models\Inventory\Item;
use App\Models\Main\Branch;
use App\Models\Main\NetworkMachine;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use App\Models\POS\SalesInvoice;
use App\Models\Sales\Customer;
use App\Models\Sales\SalesAgent;
use Illuminate\Http\Request;

use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

use Illuminate\Support\Facades\DB;
use Auth;
use Str;
use App;
use App\Classes\Barbers\BarberBookingHelper;
use App\Models\Barbers\Barber;
use App\Models\Finance\Currency;
use App\Models\Finance\Treasury;
use App\Models\POS\Coupons;
use PDF;
use Excel;

class SalesInvoiceController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_sales_invoices($lang, Request $request)
    {

        // $this->checkPermission('06-008','view');

        $this->filter = array(
            'lang'      => $lang,
            'active'    => $request['active'] ?? 1,
            'status'    => $request['status'] ?? 1,
            'rows'      => $request['rows'] ?? 20,
            'page'      => $request['page'] ?? 1,
            'from_date' => $request['from_date'] ?? null,
            'to_date'   => $request['to_date'] ?? null,
            'word'      => $request['word'] ?? null,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['items']       = SalesInvoice::all_sales_invoices($this->filter);
        $this->return['defaults']           = [];

        return $this->sendResponse($this->return);
    }

    public function get_sales_invoice($lang, $id)
    {
        // $this->checkPermission('06-008','view');

        // Categories and Sub Categories For Add Item To Invoice From Notice Debtor
        $this->return['categorys']        = Category::all_categorys(array('active' => 1, 'lang' => $lang, 'parent' => 0));
        $this->return['sub_categorys']    = Category::all_categorys(array('active' => 1, 'lang' => $lang, 'category_type' => 0));

        $branch_id = $this->data['shift']->branch_id ?? $this->data['current_branch'] ?? 0;

        // if($branch_id == 0){
        //     return $this->sendError(trans("Shift is Not Started"));
        // }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $lang)->sub_title ?? '';
        $this->return['master']      = SalesInvoice::get_sales_invoice_m($id, $lang);

        if (!isset($this->return['master']->m_id)) {
            return $this->sendError(trans("error.Invoice Not Found"));
        }

        if ($this->return['master']->branch_id != $branch_id) {
            return $this->sendError(trans("Error In Branch"));
        }

        $this->return['details']             = SalesInvoice::get_sales_invoice_d($id, $lang);
        $this->return['payments']            = SalesInvoice::get_payments($id, $lang);
        $this->return['branch_data']         = Branch::get_branch($this->return['master']->branch_id, $lang);
        $this->return['cash']                = collect($this->return['payments'])->where('payment_type', 1)->sum('amount');
        $this->return['machine']             = collect($this->return['payments'])->where('payment_type', 2)->sum('amount');
        $this->return['treasurys']           = Treasury::all_treasury(array('active' => 1, 'lang' => $lang));
        $this->return['network_machines']    = NetworkMachine::all_network_machines(array('lang' => $lang, 'active' => '1'));
        $this->return['sales_agents']        = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['currencies']          = Currency::all_currency(array('active' => 1, 'lang' => $lang));
        $this->return['defaults']           = [];

        return $this->sendResponse($this->return);
    }

    public function create_sales_invoice($lang, Request $request)
    {
        $this->checkPermission('06-008', 'add');

        $this->return['categorys']           = Category::all_categorys(array('active' => 1, 'lang' => $lang, 'parent' => 0));
        $this->return['coupons']             = Coupons::all_coupons(array('active' => 1, 'lang' => $lang, 'from_date' => date('Y-m-d'), 'to_date' => date('Y-m-d')));
        $this->return['barbers']             = Barber::all_barbers(array('active' => 1, 'lang' => $lang));
        $this->return['sub_categorys']       = Category::all_categorys(array('active' => 1, 'lang' => $lang, 'category_type' => 0));
        $this->return['network_machines']    = NetworkMachine::all_network_machines(array('lang' => $lang, 'active' => '1'));
        $this->return['sales_agents']        = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['sales_orders_count']  = DB::table('sales_order_m')->where('sales_order_active', 1)->where('sales_order_status', 1)->count();
        $this->return['items']               = Item::all_items(array('lang' => $lang, 'active' => '1', 'pos_item' => 1));
        $this->return['default_customer']    = Customer::get_customer(Setting::get_main_setting_by_code('default_customer')->value ?? 0, $lang);
        $this->return['stock_watch']        = intval(Setting::get_main_setting_by_code('stock_watch')->value ?? 0);
        $this->return['currencies']          = Currency::all_currency(array('active' => 1, 'lang' => $lang));
        $this->return['defaults']           = [];

        return $this->sendResponse($this->return);
    }

    public function add_sales_invoice($lang, Request $request)
    {
        $this->checkPermission('06-008', 'add');

        $insert       = $request->all();
        $branch_id    = $this->data['shift']->branch_id ?? $this->data['current_branch'] ?? 0;
        $warehouse_id = DB::table('branchs')->where('branch_id', $branch_id)->value('default_warehouse');
        $insert['sales_invoice_date'] = date('Y-m-d');

        // if($branch_id == 0){
        //     return $this->sendError(trans("Shift is Not Started"));
        // }

        $year = array_search(date("Y", strtotime($insert['sales_invoice_date'])), $this->data['years']);

        if ($year == '') {
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        if (!isset($insert['sales_agent_id']) || intval($insert['sales_agent_id']) < 1) {
            return $this->sendError(trans("Sales Agent Error"));
        }

        if (!isset($insert['items']) || count($insert['items']) < 1) {
            return $this->sendError(trans("Error In Items"));
        }

        $customer   = Customer::get_customer($insert['customer_id'], 'en');
        $codes      = (new SalesInvoiceHelper)->get_next_codes($insert['sales_invoice_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'shift_id'                  => $this->data['shift']->shift_id ?? 0,
            'branch_id'                 => $branch_id,
            'finance_year_id'           => $year,
            'year_ser'                  => $codes['year_ser'],
            'month_ser'                 => $codes['month_ser'],
            'branch_ser'                => $codes['branch_ser'],
            'daily_journal_m_id'        => 0,
            'proforma_invoice_id'       => 0,
            'link_cost_center'          => 0,
            'cost_center_id'            => 0,
            'customer_id'               => $insert['customer_id'],
            'invoice_cust_type'         => $customer->customer_invoice_type ?? 0,
            'sales_invoice_date'        => $insert['sales_invoice_date'],
            'sales_invoice_description' => 'POS Invoice',
            'supply_order'              => 'POS Supply Order',
            'sales_invoice_type_id'     => $insert['sales_invoice_type_id'] ?? 2,
            'sales_agent_id'            => $insert['sales_agent_id'],
            'invoice_discount'          => $insert['invoice_discount'] ?? 0,
            'discount_type'             => $insert['discount_type'] ?? 0,
            'discount'                  => $insert['discount'] ?? 0,
            'barber_id'                 => $insert['barber_id'] ?? 0,
            'coupon_id'                 => $insert['coupon_id'] ?? 0,
            'invoice_uuid'              => Str::uuid(),
            'items_count'               => collect($insert['items'])->count(),
            'add_user'                  => auth()->user()->id
        ];

        DB::beginTransaction();

        $m_id = SalesInvoice::add_sales_invoice_m($master_seed);

        $items  = (new SalesInvoiceHelper)->prepare_details($m_id, 0, [], $request['items'], 0);

        if (count($items) < 1) {
            DB::rollback();
            return $this->sendError(trans('error.add_fails'), []);
        }
        foreach ($items as $item) {

            $validator = validator()->make($item, SalesInvoice::$details_rules);
            if ($validator->fails()) {
                return $this->sendError(trans('error.add_fails'), $validator->errors());
            }

            unset($item['d_id']);
            $d_id = SalesInvoice::add_sales_invoice_d($item);
        }

        $insert['payments'] = $insert['payments'] ?? [];

        foreach ($insert['payments'] as $payment) {
            DB::table('sales_invoice_payments')->insert(array(
                'sales_invoice_m_id' => $m_id,
                'machine_id'         => $payment['machine_id'] ?? 0,
                'treasury_id'        => $payment['treasury_id'] ?? 0,
                'payment_type'       => $payment['payment_type'] ?? 1,
                'payment_text'       => $payment['payment_text'],
                'card_type'          => $payment['cart_type'] ?? $payment['card_type']  ?? 1,
                'amount'             => $payment['amount']
            ));
        }

        $updateMasterValues = (new SalesInvoiceHelper)->update_master_values($m_id);

        // (new SalesInvoiceHelper)->generate_daily_journal($m_id);

        // If Request From Pending Sales Order - Convert Pending To Completed Invoice
        if (isset($insert['sales_order_m_id']) && strlen($insert['sales_order_m_id']) > 0) {
            DB::table('sales_order_m')
                ->where('sales_order_m_id', $insert['sales_order_m_id'])
                ->update(['sales_order_status' => 2]);
        }

        // If Request From Barber Booking
        if (isset($insert['barber_booking_id']) && strlen($insert['barber_booking_id']) > 0) {

            // check if the barber booking exists
            $barber_booking_exists = DB::table('barber_bookings')
                ->where('barber_booking_id', $insert['barber_booking_id'])
                ->exists();

            if (!$barber_booking_exists) {
                return $this->sendError(trans('error.barber_booking_id ' . $insert['barber_booking_id'] . ' not exists'), []);
            }
            BarberBookingHelper::process_barberBooking_invoice($insert['barber_booking_id'], $m_id);
        }

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function print_invoice($id, Request $request)
    {
        $input = $request->all();

        App::setLocale('ar');

        $this->data['lang']        = 'ar';
        $this->data['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-008', $this->data['lang']);
        $this->data['master']      = SalesInvoice::get_sales_invoice_m($id, $this->data['lang']);
        $this->data['details']     = SalesInvoice::get_sales_invoice_d($id, $this->data['lang'], 1);
        $this->data['payments']    = SalesInvoice::get_payments($id, $this->data['lang']);
        $this->data['logo']        = get_logo($this->data['master']->branch_id);
        $this->data['branch_data'] = Branch::get_branch($this->data['master']->branch_id, $this->data['lang']);

        $this->data['cash']        = collect($this->data['payments'])->where('payment_type', 1)->sum('amount');
        $this->data['card']        = collect($this->data['payments'])->where('payment_type', 2)->sum('amount');
        $this->data['trans']       = collect($this->data['payments'])->where('payment_type', 3)->sum('amount');

        $temp_name                 = Setting::get_main_setting_by_code('sales_print')->value ?? 'temp_1';
        $print_temp                = 'Print.Sales.' . $temp_name;

        $this->data['qrcode']      = GenerateQrCode::fromArray([
            new Seller($this->data['branch_data']->vat_register_name), // Seller Name
            new TaxNumber($this->data['branch_data']->vat_number), // Seller Tax Number
            new InvoiceDate(date('Y-m-d\TH:i:s', strtotime($this->data['master']->add_date))),
            new InvoiceTotalAmount($this->data['master']->total_without_vat_after_discount), // Invoice Total Amount
            new InvoiceTaxAmount(round($this->data['master']->total_vat, 2)) // Invoice Tax Amount
        ])->render();

        switch (@$input['type']) {
            case 'excel':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $export = new InvoicesExport($this->data, $print_temp);
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $pdf = PDF::loadView($print_temp, array('data' => $this->data));
                return $pdf->stream();
                break;
            case 'image':
                $this->data['logo'] = public_path() . $this->data['logo'];
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp, array('data' => $this->data))->setOption('width', '80');

                if ($request['clientID'] == '1000' || $request['clientID'] == 'test') {
                    $image->setOption('width', '80');
                }

                return $image->stream();
                break;
            case 'print':
                return view($print_temp)->with('data', $this->data);
                break;
        }
    }

    public function search_item($lang, Request $request)
    {
        $input = $request->all();

        $this->filter = array(
            'lang'      => $lang,
            'pos_item'  => 1,
            'active'    => $input['active'] ?? 1,
            'rows'      => $input['rows'] ?? null,
            'page'      => $input['page'] ?? 1,
            'word'      => $input['word'] ?? null,
        );

        $this->return['items'] = Item::all_items($this->filter);
        return $this->sendResponse($this->return);
    }
}
