<?php

namespace App\Http\Controllers\API\V1\POS;
use App\Classes\Excel\InvoicesExport;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Inventory\Item;
use App\Models\Main\Branch;
use App\Models\Main\ScreenSub;
use App\Models\POS\NoticeCreditor;
use App\Models\POS\NoticeDebtor;
use App\Models\POS\SalesInvoice;
use App\Models\Sales\SalesAgent;
use Illuminate\Http\Request;

use DB;
use PDF;
use Str;
use Excel;
use App;

class ReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function generate_pos_report($lang, Request $request)
    {
        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? 20 ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $report_type = $request['report_type'];

        switch($report_type){
            case 1:
                $this->return['report'] = SalesInvoice::all_sales_invoices($this->filter);
                break;
            case 2:
                $this->return['report'] = NoticeDebtor::all_notice_debtors($this->filter);
                break;
            case 3:
                $this->return['report'] = NoticeCreditor::all_notice_creditors($this->filter);
                break;
        }

        return $this->sendResponse($this->return);
    }

    // public function full_report_get($lang, Request $request)
    // {
    //     if(!@in_array('1', $this->data['mypermissions']['06-012'][0]->permission)){
    //         return $this->sendError('view permission needed #06-012', $this->data, 200);
    //     }

    //     App::setLocale($lang);

    //     $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-012' , $lang)->sub_title ?? '';
    //     $this->return['branchs'] = Branch::all_branchs(array('active' => 1, 'lang' => $lang));
    //     $this->return['items']   = Item::all_items(array('active' => 1, 'lang' => $lang));

    //     $this->return['types']              = array(
    //         array(
    //             'id'    => 0 ,
    //             'title' => trans('main.all')
    //         ),array(
    //             'id'    => 1 ,
    //             'title' => trans('main.sales')
    //         ),array(
    //             'id'    => 2 ,
    //             'title' => trans('main.notice_creditor')
    //         ),array(
    //             'id'    => 3 ,
    //             'title' => trans('main.notice_debtor')
    //         )
    //     );

    //     return $this->sendResponse($this->return);
    // }

    // public function full_report_post($lang, Request $request)
    // {
    //     if(!@in_array('2', $this->data['mypermissions']['06-012'][0]->permission)){
    //         return $this->sendError('view permission needed #06-012', $this->data, 200);
    //     }

    //     App::setLocale($lang);

    //     $this->return['from']         = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
    //     $this->return['to']           = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
    //     $this->return['report_type']  = $request['report_type'] ?? 0;
    //     $this->return['items']        = $request['items'] ?? [];
    //     $this->return['payment_type'] = $request['payment_type'] ?? 0;

    //     $this->return['sales_agent_id'] = $request['sales_agent_id'] ?? 0 ;
    //     $this->return['customer_id']    = $request['customer_id'] ?? 0 ;

    //     $this->return['invoice_code']   = $request['invoice_code'] ?? 0 ;

    //     $this->return['branch_id']    = intval( $request['branch_id'] ?? 0 );
    //     $this->return['lang']         = $lang ;

    //     if (isset($this->return['items']) && !is_array($this->return['items'])) {
    //         $this->return['items'] = explode(',' , $this->return['items']);
    //     }

    //     $branch = Branch::get_branch($this->data['current_branch'] , 'en');

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 1){
    //         $query = DB::table('sales_invoice_m')
    //             ->leftjoin('sales_invoice_d', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
    //             ->leftjoin('items', 'sales_invoice_d.item_id' , '=' , 'items.item_id')
    //             ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('users', 'sales_invoice_m.add_user' , '=' , 'users.id')
    //             ->leftjoin('branchs', 'sales_invoice_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
    //             ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
    //             ->groupBy('items.item_id')
    //             ->where('sales_invoice_m.branch_id', '=', $this->return['branch_id'])
    //             ->where('sales_invoice_m.sales_invoice_date' , '>=' , $this->return['from']." 00:00:00")
    //             ->where('sales_invoice_m.sales_invoice_date' , '<=' , $this->return['to']." 23:59:59")
    //             ->where('sales_invoice_active' , '=' , 1)

    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id  ,
    //                 0 as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 sales_invoice_m.sales_invoice_date as sales_invoice_date ,
    //                 branchs.name_'.$lang.' as branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,
    //                 sales_invoice_m.customer_id as customer_id  ,
    //                 customers.name_'.$lang.' as customer_name ,

    //                 users.user_full_name as user_full_name ,

    //                 sales_invoice_d.item_id as item_id  ,
    //                 items.name_'.$lang.' as  item_name,
    //                 sales_invoice_d.quantity as item_quantity ,
    //                 sales_invoice_d.price as item_price ,
    //                 sales_invoice_d.total_price as total_price ,
    //                 sales_invoice_d.discount as discount ,
    //                 sales_invoice_d.total_price_after_discount as total_price_after_discount ,
    //                 sales_invoice_d.total_vat as total_vat ,
    //                 sales_invoice_d.total_without_vat as total_without_vat ,
    //                 sales_invoice_d.total_with_vat as total_with_vat ,

    //                 payment_methods.payment_method_id as payment_type_id ,
    //                 payment_methods.name_'.$lang.' as payment_type ,

    //                 sum( case when sales_invoice_payments.payment_type = 1 then sales_invoice_payments.amount end ) as paid_cash ,
    //                 sum( case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end ) as paid_bank ,
    //                 sum( case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end ) as paid_trans
    //             ');

    //         if(count($this->return['items']) > 0){
    //             $query->whereIn('items.item_id', $this->return['items']);
    //         }

    //         if( $this->return['branch_id'] > 0  ){
    //             $query->where('sales_invoice_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $query->whereIn('sales_invoice_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if( $this->return['sales_agent_id'] != 0 ){
    //             $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $query->where('sales_invoice_d.sales_invoice_m_id' , $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['customer_id']) && ($this->return['customer_id']) > 0){
    //             $query->where('sales_invoice_m.customer_id' , $this->return['customer_id'] );
    //         }


    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $query->where('sales_invoice_payments.payment_type' , $this->return['payment_type']);
    //         }

    //         $sales = $query->get()->toArray();

    //         foreach ($sales as $key => $row) {
    //             $sales[$key]->type = 1;
    //             $sales[$key]->sumtion = 1;
    //         }
    //     }else{
    //         $sales = array();
    //     }

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 2){
    //         $returns2 = DB::table('notice_creditors_m')
    //             ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
    //             ->leftjoin('items', 'notice_creditors_d.item_id' , '=' , 'items.item_id')
    //             ->leftjoin('branchs' , 'notice_creditors_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('customers' , 'notice_creditors_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id ,
    //                 notice_creditors_m.notice_creditor_m_id as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 notice_creditors_m.invoice_date ,

    //                 notice_creditors_d.item_id as item_id ,
    //                 items.name_'.$lang.' as  items_name ,

    //                 notice_creditors_d.new_price as item_price ,
    //                 notice_creditors_d.new_quantity as item_quantity ,

    //                 branchs.name_'.$lang.' as  branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,

    //                 sum(notice_creditors_d.new_price) as total_without_vat ,
    //                 sum(notice_creditors_d.new_quantity) as total_quantity ,
    //                 sum(notice_creditors_d.new_total_price) as total_with_vat ,

    //                 sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
    //                 sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
    //                 sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
    //             ')
    //             ->groupBy('items.item_id')
    //             ->where('notice_creditors_m.invoice_date' , '>=' , $this->return['from'] )
    //             ->where('notice_creditors_m.invoice_date' , '<=' , $this->return['to'] )
    //             ->where('notice_creditor_active' , '=' , 1);

    //         if(count($this->return['items']) > 0){
    //             $returns2->whereIn('items.item_id', $this->return['items']);
    //         }

    //         if( $this->return['branch_id'] > 0  ){
    //             $returns2->where('notice_creditors_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $returns2->whereIn('notice_creditors_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $returns2->where('notice_creditors_d.notice_creditor_m_id' ,  $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $returns2->where('notice_payments.payment_type' , $this->return['payment_type'] );
    //         }

    //         if( $this->return['sales_agent_id'] != "0" ){
    //             $returns2->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         $returns2 = $returns2->get()->toArray();

    //         foreach ($returns2 as $key => $row) {
    //             $returns2[$key]->type = 2;
    //             $returns2[$key]->sumtion = 2;
    //         }
    //     }else{
    //         $returns2 = array();
    //     }

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 3){
    //         $returns3 = DB::table('notice_debtors_m')
    //             ->leftjoin('notice_debtors_d' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_debtors_d.notice_debtor_m_id')
    //             ->leftjoin('items', 'notice_debtors_d.item_id' , '=' , 'items.item_id')
    //             ->leftjoin('branchs' , 'notice_debtors_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_invoice_m' , 'notice_debtors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('customers' , 'notice_debtors_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('notice_payments' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_payments.notice_debtor_m_id')
    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id ,
    //                 notice_debtors_m.notice_debtor_m_id as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 notice_debtors_m.invoice_date ,

    //                 notice_debtors_d.item_id as item_id ,
    //                 items.name_'.$lang.' as  items_name ,

    //                 notice_debtors_d.new_price as item_price ,
    //                 notice_debtors_d.new_quantity as item_quantity ,

    //                 branchs.name_'.$lang.' as  branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,

    //                 sum(notice_debtors_d.new_price) as total_without_vat ,
    //                 sum(notice_debtors_d.new_quantity) as total_quantity ,
    //                 sum(notice_debtors_d.new_total_price) as total_with_vat ,

    //                 sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
    //                 sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
    //                 sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
    //             ')
    //             ->groupBy('items.item_id')
    //             ->where('notice_debtors_m.invoice_date' , '>=' , $this->return['from'] )
    //             ->where('notice_debtors_m.invoice_date' , '<=' , $this->return['to'] )
    //             ->where('notice_debtor_active' , '=' , 1);

    //         if(count($this->return['items']) > 0){
    //             $returns3->whereIn('items.item_id', $this->return['items']);
    //         }

    //         if( $this->return['branch_id'] > 0  ){
    //             $returns3->where('notice_debtors_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $returns3->whereIn('notice_debtors_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $returns3->where('notice_debtors_d.notice_debtor_m_id' ,  $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $returns3->where('notice_payments.payment_type' , $this->return['payment_type'] );
    //         }

    //         if( $this->return['sales_agent_id'] != "0" ){
    //             $returns3->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         $returns3 = $returns3->get()->toArray();

    //         foreach ($returns3 as $key => $row) {
    //             $returns3[$key]->type = 3;
    //             $returns3[$key]->sumtion = 1;
    //         }
    //     }else{
    //         $returns3 = array();
    //     }

    //     $this->return['data']           = array_merge($sales  ,$returns2 , $returns3);
    //     $this->return['data']           = collect( $this->return['data'])->sortByDesc('s_m_id')->values()->all();

    //     $this->return['chart']          = collect($this->return['data'])->groupBy('items_name')->map(function ($group) {
    //         return [
    //             'total_with_vat' => $group->sum('item_price'),
    //             'quantity' => $group->sum('item_quantity'),
    //         ];
    //     });

    //     $this->return['logo']           = get_logo($this->data['current_branch']);
    //     $this->return['params_text']    = trans('main.from').":".$this->return['from']." - ".trans('main.to').":".$this->return['to'];

    //     if(strlen($this->return['invoice_code']))
    //         $this->return['params_text']  .= trans('main.invoice_code')." ".$this->return['invoice_code'];

    //     if($this->return['sales_agent_id'] > 0 )
    //         $this->return['params_text']  .= " - ".trans('main.sales_agent')." ".SalesAgent::get_sales_agent( $this->return['sales_agent_id'] , $this->return['lang'] )->name ?? '';

    //     switch (@$request['type']) {
    //         case 'excel':
    //             $this->return['logo']     = public_path().$this->return['logo'];
    //             $export = new InvoicesExport($this->return , 'Print/Sales/report/full_report');
    //             return Excel::download($export, 'balances.xlsx');
    //             break;
    //         case 'pdf':
    //             $this->return['logo']     = public_path().$this->return['logo'];
    //             $pdf = PDF::loadView('Print/Sales/report/full_report', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
    //             return $pdf->stream();
    //             break;

    //         case 'print':
    //             return view('Print/Sales/report/full_report')->with('data' , $this->return);
    //             break;
    //         case 'json':
    //             return $this->sendResponse( $this->return  );
    //             // return view('finance/report/account_statment_anal_p')->with('data' , $this->data);
    //             break;
    //     }
    // }

    // public function sales_report_get($lang, Request $request)
    // {
    //     if(!@in_array('1', $this->data['mypermissions']['06-013'][0]->permission)){
    //         return $this->sendError('view permission needed #06-013', $this->data, 200);
    //     }

    //     App::setLocale($lang);

    //     $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-013' , $lang)->sub_title ?? '';
    //     $this->return['branchs'] = Branch::all_branchs(array('active' => 1, 'lang' => $lang));

    //     $this->return['types']              = array(
    //         array(
    //             'id'    => 0 ,
    //             'title' => trans('main.all')
    //         ),array(
    //             'id'    => 1 ,
    //             'title' => trans('main.sales')
    //         ),array(
    //             'id'    => 2 ,
    //             'title' => trans('main.notice_creditor')
    //         ),array(
    //             'id'    => 3 ,
    //             'title' => trans('main.notice_debtor')
    //         )
    //     );

    //     return $this->sendResponse($this->return);
    // }

    // public function sales_report_post($lang, Request $request)
    // {
    //     if(!@in_array('2', $this->data['mypermissions']['06-013'][0]->permission)){
    //         return $this->sendError('view permission needed #06-013', $this->data, 200);
    //     }

    //     App::setLocale($lang);

    //     $this->return['from']         = date("Y-m-d" , strtotime($request['from'] ?? date("Y-m-01")));
    //     $this->return['to']           = date("Y-m-d" , strtotime($request['to'] ?? date("Y-m-d")));
    //     $this->return['report_type']  = $request['report_type'] ?? 0;
    //     $this->return['payment_type'] = $request['payment_type'] ?? 0;

    //     $this->return['sales_agent_id'] = $request['sales_agent_id'] ?? 0 ;
    //     $this->return['customer_id']    = $request['customer_id'] ?? 0 ;

    //     $this->return['invoice_code']   = $request['invoice_code'] ?? 0 ;

    //     $this->return['branch_id']    = intval( $request['branch_id'] ?? 0 );
    //     $this->return['lang']         = $lang ;

    //     if (isset($this->return['items']) && !is_array($this->return['items'])) {
    //         $this->return['items'] = explode(',' , $this->return['items']);
    //     }

    //     $branch = Branch::get_branch($this->data['current_branch'] , 'en');

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 1){
    //         $query = DB::table('sales_invoice_m')
    //             ->leftjoin('sales_invoice_d', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
    //             ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('users', 'sales_invoice_m.add_user' , '=' , 'users.id')
    //             ->leftjoin('branchs', 'sales_invoice_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
    //             ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
    //             ->groupBy('sales_invoice_m.sales_invoice_m_id')
    //             ->where('sales_invoice_m.branch_id', '=', $this->return['branch_id'])
    //             ->where('sales_invoice_m.sales_invoice_date' , '>=' , $this->return['from']." 00:00:00")
    //             ->where('sales_invoice_m.sales_invoice_date' , '<=' , $this->return['to']." 23:59:59")
    //             ->where('sales_invoice_active' , '=' , 1)

    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id  ,
    //                 0 as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 sales_invoice_m.sales_invoice_date as sales_invoice_date ,
    //                 branchs.name_'.$lang.' as branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,
    //                 sales_invoice_m.customer_id as customer_id  ,
    //                 customers.name_'.$lang.' as customer_name ,

    //                 users.user_full_name as user_full_name ,

    //                 sales_invoice_m.items_count as quantity ,

    //                 ( sales_invoice_m.total_without_vat + sales_invoice_m.discount ) as total_price ,
    //                 sales_invoice_m.discount as discount ,

    //                 sales_invoice_m.total_vat as total_vat ,
    //                 sales_invoice_m.total_with_vat as total_with_vat ,
    //                 sales_invoice_m.total_without_vat as total_without_vat ,


    //                 payment_methods.payment_method_id as payment_type_id ,
    //                 payment_methods.name_'.$lang.' as payment_type ,

    //                 sum( case when sales_invoice_payments.payment_type = 1 then sales_invoice_payments.amount end ) as paid_cash ,
    //                 sum( case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end ) as paid_bank ,
    //                 sum( case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end ) as paid_trans
    //             ');

    //         if( $this->return['branch_id'] > 0  ){
    //             $query->where('sales_invoice_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $query->whereIn('sales_invoice_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if( $this->return['sales_agent_id'] != "0" ){
    //             $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $query->where('sales_invoice_d.sales_invoice_m_id' , $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['customer_id']) && ($this->return['customer_id']) > 0){
    //             $query->where('sales_invoice_m.customer_id' , $this->return['customer_id'] );
    //         }


    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $query->where('sales_invoice_payments.payment_type' , $this->return['payment_type']);
    //         }

    //         $sales = $query->get()->toArray();

    //         foreach ($sales as $key => $row) {
    //             $sales[$key]->type = 1;
    //             $sales[$key]->sumtion = 1;
    //         }
    //     }else{
    //         $sales = array();
    //     }

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 2){
    //         $returns2 = DB::table('notice_creditors_m')
    //             ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
    //             ->leftjoin('branchs' , 'notice_creditors_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('customers' , 'notice_creditors_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id ,
    //                 notice_creditors_m.notice_creditor_m_id as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 notice_creditors_m.invoice_date ,

    //                 branchs.name_'.$lang.' as  branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,
    //                 sales_invoice_m.sales_invoice_date ,


    //                 sum(notice_creditors_d.new_price) as total_without_vat ,
    //                 sum(notice_creditors_d.new_quantity) as total_quantity ,
    //                 sum(notice_creditors_d.new_total_price) as total_with_vat ,

    //                 sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
    //                 sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
    //                 sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
    //             ')
    //             ->groupBy('notice_creditors_m.notice_creditor_m_id')
    //             ->where('notice_creditors_m.invoice_date' , '>=' , $this->return['from'] )
    //             ->where('notice_creditors_m.invoice_date' , '<=' , $this->return['to'] )
    //             ->where('notice_creditor_active' , '=' , 1);

    //         if( $this->return['branch_id'] > 0  ){
    //             $returns2->where('notice_creditors_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $returns2->whereIn('notice_creditors_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $returns2->where('notice_creditors_d.notice_creditor_m_id' ,  $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $returns2->where('notice_payments.payment_type' , $this->return['payment_type'] );
    //         }

    //         if( $this->return['sales_agent_id'] != "0" ){
    //             $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         $returns2 = $returns2->get()->toArray();

    //         foreach ($returns2 as $key => $row) {
    //             $returns2[$key]->type = 2;
    //             $returns2[$key]->sumtion = 2;
    //         }
    //     }else{
    //         $returns2 = array();
    //     }

    //     if($this->return['report_type'] == 0 || $this->return['report_type'] == 3){
    //         $returns3 = DB::table('notice_debtors_m')
    //             ->leftjoin('notice_debtors_d' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_debtors_d.notice_debtor_m_id')
    //             ->leftjoin('branchs' , 'notice_debtors_m.branch_id' , '=' , 'branchs.branch_id')
    //             ->leftjoin('sales_invoice_m' , 'notice_debtors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
    //             ->leftjoin('sales_agents' , 'sales_invoice_m.sales_agent_id' , 'sales_agents.sales_agent_id')
    //             ->leftjoin('customers' , 'notice_debtors_m.customer_id' , '=' , 'customers.customer_id')
    //             ->leftjoin('notice_payments' , 'notice_debtors_m.notice_debtor_m_id' , '=' , 'notice_payments.notice_debtor_m_id')
    //             ->selectRaw('
    //                 sales_invoice_m.sales_invoice_m_id as s_m_id ,
    //                 notice_debtors_m.notice_debtor_m_id as r_m_id ,
    //                 sales_invoice_m.sales_invoice_m_id as invoice_code ,
    //                 notice_debtors_m.invoice_date ,

    //                 branchs.name_'.$lang.' as  branch_name ,
    //                 sales_agents.name_'.$lang.' as  sales_agent_name ,
    //                 sales_invoice_m.sales_invoice_date ,

    //                 sum(notice_debtors_d.new_price) as total_without_vat ,
    //                 sum(notice_debtors_d.new_quantity) as total_quantity ,
    //                 sum(notice_debtors_d.new_total_price) as total_with_vat ,

    //                 sum( case when notice_payments.payment_type = 1 then amount end ) as paid_cash ,
    //                 sum( case when notice_payments.payment_type = 2 then amount end ) as paid_bank ,
    //                 sum( case when notice_payments.payment_type = 3 then amount end ) as paid_trans
    //             ')
    //             ->groupBy('notice_debtors_m.notice_debtor_m_id')
    //             ->where('notice_debtors_m.invoice_date' , '>=' , $this->return['from'] )
    //             ->where('notice_debtors_m.invoice_date' , '<=' , $this->return['to'] )
    //             ->where('notice_debtor_active' , '=' , 1);

    //         if( $this->return['branch_id'] > 0  ){
    //             $returns3->where('notice_debtors_m.branch_id' , '=' , $this->return['branch_id'] );
    //         }else{
    //             $returns3->whereIn('notice_debtors_m.branch_id' , array_keys($this->data['branchs']) );
    //         }

    //         if(isset($this->return['invoice_code']) && ($this->return['invoice_code']) > 0){
    //             $returns3->where('notice_debtors_d.notice_debtor_m_id' ,  $this->return['invoice_code'] );
    //         }

    //         if(isset($this->return['payment_type']) && ($this->return['payment_type']) > 0){
    //             $returns3->where('notice_payments.payment_type' , $this->return['payment_type'] );
    //         }

    //         if( $this->return['sales_agent_id'] != "0" ){
    //             $query->where('sales_invoice_m.sales_agent_id' , '=' , $this->return['sales_agent_id'] );
    //         }

    //         $returns3 = $returns3->get()->toArray();

    //         foreach ($returns3 as $key => $row) {
    //             $returns3[$key]->type = 3;
    //             $returns3[$key]->sumtion = 1;
    //         }
    //     }else{
    //         $returns3 = array();
    //     }

    //     $this->return['data']           = array_merge($sales  ,$returns2 , $returns3);
    //     $this->return['data']           = collect( $this->return['data'])->sortByDesc('s_m_id')->values()->all();

    //     $this->return['chart'] = collect($this->return['data'])->groupBy('sales_invoice_date')->map(function ($group) {
    //         return [
    //             'total_with_vat' => $group->sum('total_with_vat'),
    //             'quantity' => $group->count('s_m_id'),
    //         ];
    //     });

    //     $this->return['logo']           = get_logo($this->data['current_branch']);
    //     $this->return['params_text']    = trans('main.from').":".$this->return['from']." - ".trans('main.to').":".$this->return['to'];

    //     if(strlen($this->return['invoice_code']))
    //         $this->return['params_text']  .= trans('main.invoice_code')." ".$this->return['invoice_code'];

    //     if($this->return['sales_agent_id'] > 0 )
    //         $this->return['params_text']  .= " - ".trans('main.sales_agent')." ".SalesAgent::get_sales_agent( $this->return['sales_agent_id'] , $this->return['lang'] )->name ?? '';

    //     switch (@$request['type']) {
    //         case 'excel':
    //             $this->return['logo']     = public_path().$this->return['logo'];
    //             $export = new InvoicesExport($this->return , 'Print/Sales/report/full_report');
    //             return Excel::download($export, 'balances.xlsx');
    //             break;
    //         case 'pdf':
    //             $this->return['logo']     = public_path().$this->return['logo'];
    //             $pdf = PDF::loadView('Print/Sales/report/full_report', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
    //             return $pdf->stream();
    //             break;

    //         case 'print':
    //             return view('Print/Sales/report/full_report')->with('data' , $this->return);
    //             break;
    //         case 'json':
    //             return $this->sendResponse( $this->return  );
    //             // return view('finance/report/account_statment_anal_p')->with('data' , $this->data);
    //             break;
    //     }
    // }
}
