<?php

namespace App\Http\Controllers\API\V1\POS;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Classes\Excel\InvoicesExport;
use App\Classes\ItemStock;
use App\Classes\Sales\NoticeDebtorHelper;



use App\Models\Main\Branch;
use App\Models\Main\NetworkMachine;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use App\Models\POS\NoticeDebtor;
use App\Models\Sales\SalesAgent;

use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

use DB;
use Auth;
use Str;
use PDF;
use App;

class NoticeDebtorController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_notice_debtors($lang, Request $request)
    {
        if (!@in_array('1', $this->data['mypermissions']['06-010'][0]->permission)) {
            return $this->sendError('view permission needed #06-010', $this->data, 200);
        }

        $shift = (!isset($input['rows'])) ? @$this->data['shift']->shift_id : null;

        $this->filter = array(
            'lang'   => $lang,
            'branch' => $this->data['current_branch'],
            'active' => $request['active'] ?? 1,
            'status' => $request['status'] ?? 1,
            'rows'   => $request['rows'] ?? 20,
            'page'   => $request['page'] ?? 1,
            'word'   => $request['word'] ?? null,
            'shift'  => $shift
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-010', $lang)->sub_title ?? '';
        $this->return['items']       = NoticeDebtor::all_notice_debtors($this->filter);

        return $this->sendResponse($this->return);
    }

    public function get_notice_debtor($lang, $id)
    {
        if (!@in_array('1', $this->data['mypermissions']['06-010'][0]->permission)) {
            return $this->sendError('show permission needed #06-010', [], 200);
        }

        $branch_id = $this->data['shift']->branch_id ?? $this->data['current_branch'];

        if ($branch_id == 0) {
            return $this->sendError(trans("Shift is Not Started"));
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-010', $lang)->sub_title ?? '';
        $this->return['master']      = NoticeDebtor::get_notice_debtor_m($id, $lang);

        if (!isset($this->return['master']->m_id)) {
            return $this->sendError(trans("Notice Debtor Not Found"));
        }

        if ($this->return['master']->branch_id != $branch_id) {
            return $this->sendError(trans("Error In Branch"));
        }

        $this->return['details']          = NoticeDebtor::get_notice_debtor_d($id, $lang);
        $this->return['payments']         = NoticeDebtor::get_payments($id, $lang);

        $this->return['branch_data']      = Branch::get_branch($this->return['master']->branch_id, $lang);
        $this->return['cash']             = collect($this->return['payments'])->where('payment_type', 1)->sum('amount');
        $this->return['machine']          = collect($this->return['payments'])->where('payment_type', 2)->sum('amount');
        $this->return['network_machines'] = NetworkMachine::all_network_machines(array('lang' => $lang, 'active' => '1'));
        $this->return['sales_agents']     = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse($this->return);
    }

    public function create_notice_debtor($lang, Request $request)
    {
        if (!@in_array('2', $this->data['mypermissions']['06-010'][0]->permission)) {
            return $this->sendError('view permission needed #06-010', $this->data, 200);
        }

        $branch_id = $this->data['shift']->branch_id ?? $this->data['current_branch'];

        if ($branch_id == 0) {
            return $this->sendError('Shift is Not Started');
        }

        $this->return['sales_agents']     = SalesAgent::all_sales_agents(array('active' => 1, 'lang' => $lang));
        $this->return['network_machines'] = NetworkMachine::all_network_machines(array('lang' => $lang, 'active' => '1'));

        return $this->sendResponse($this->return);
    }

    public function add_notice_debtor($lang, Request $request)
    {
        // if (!@in_array('2', $this->data['mypermissions']['06-010'][0]->permission)) {
        //     return $this->sendError('view permission needed #06-010', $this->data, 200);
        // }

        $insert       = $request->all();
        $branch_id    = $this->data['shift']->branch_id ?? $this->data['current_branch'];
        $warehouse_id = DB::table('branchs')->where('branch_id', $branch_id)->value('default_warehouse');
        $insert['invoice_date'] = date("Y-m-d");

        if ($branch_id == 0) {
            return $this->sendError('Shift is Not Started');
        }

        $year = array_search(date("Y", strtotime($insert['invoice_date'])), $this->data['years']);

        if ($year == '') {
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        if (!isset($insert['items']) || count($insert['items']) < 1) {
            return $this->sendError(trans("No Items"));
        }

        $codes = $this->get_next_codes($insert['invoice_date'], $year, $branch_id);

        $sales_invoice = DB::table('sales_invoice_m')
            ->where('sales_invoice_m_id', $insert['sales_invoice_m_id'])
            ->first();

        $master_seed = [
            'treasury_id'           =>  $insert['treasury_id'] ?? 0,
            'machine_id'            =>  $insert['machine_id'] ?? 0,
            'sales_invoice_m_id'    => $insert['sales_invoice_m_id'],
            'branch_id'             => $branch_id,
            'finance_year_id'       => $year,
            'year_ser'              => $codes['year_ser'],
            'month_ser'             => $codes['month_ser'],
            'branch_ser'            => $codes['branch_ser'],
            'daily_journal_m_id'    => 0,
            'customer_id'           => $sales_invoice->customer_id,
            'invoice_date'          => $insert['invoice_date'],
            'sales_invoice_type_id' => $insert['sales_invoice_type_id'] ?? 2,
            'shift_id'              => $this->data['shift']->shift_id ?? 0,
            'add_user'              => auth()->user()->id
        ];

        DB::beginTransaction();

        $m_id = NoticeDebtor::add_notice_debtor_m($master_seed);

        if (isset($insert['items']) && is_array($insert['items'])) {
            foreach ($insert['items'] as $item) {
                if (isset($item['unit_id']) && !is_null($item['unit_id'])) {
                    $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
                    if ($item['unit_id'] == $selectedItem->big_unit_id) {
                        $item['unit_type'] = 3;
                    } elseif ($item['unit_id'] == $selectedItem->mid_unit_id) {
                        $item['unit_type'] = 2;
                    } elseif ($item['unit_id'] == $selectedItem->small_unit_id) {
                        $item['unit_type'] = 1;
                    } else {
                        $item['unit_type'] = 3;
                    }
                }
                $detail = DB::table('sales_invoice_d')
                    ->selectRaw('
                            unit_type , 
                            unit_id ,
                            current_quantity ,
                            current_total_vat ,
                            current_total_without_vat ,
                            current_total_with_vat 
                        ')
                    ->where('sales_invoice_d_id', $item['d_id'])
                    ->first();


                $new_values = [
                    'quantity'          => $item['new_quantity']          - $detail->current_quantity,
                    'total_vat'         => $item['new_total_vat']         - $detail->current_total_vat,
                    'total_without_vat' => $item['new_total_without_vat'] - $detail->current_total_without_vat,
                    'total_with_vat'    => $item['new_total_with_vat']    - $detail->current_total_with_vat,
                ];

                // check if any new_values < 0
                foreach ($new_values as $val) {
                    if ($val < 0) {
                        return $this->sendError(trans('error.Error In Price Or Quantity'));
                    }
                }




                DB::table('sales_invoice_d')
                    ->where('sales_invoice_d_id', $item['d_id'])
                    ->update([
                        'current_quantity'                   => $item['new_quantity'],
                        'current_total_vat'                  => $item['new_total_vat'],
                        'current_total_without_vat'          => $item['new_total_without_vat'],
                        'current_total_with_vat'             => $item['new_total_with_vat'],
                    ]);

                $detail_seed = [
                    'notice_debtor_m_id'  => $m_id,
                    'sales_invoice_d_id'    => $item['d_id'],
                    'item_id'               => $item['item_id'],
                    'warehouse_id'          => $warehouse_id,

                    'old_quantity'          => $detail->current_quantity,
                    'old_total_vat'         => $detail->current_total_vat,
                    'old_total_without_vat' => $detail->current_total_without_vat,
                    'old_total_with_vat'    => $detail->current_total_with_vat,

                    'new_quantity'         => $new_values['quantity'],
                    'new_total_vat'        => $new_values['total_vat'],
                    'new_total_without_vat' => $new_values['total_without_vat'],
                    'new_total_with_vat'   => $new_values['total_with_vat'],
                ];

                $d_id = NoticeDebtor::add_notice_debtor_d($detail_seed);
                $source = ItemStock::notice_debitor_source; // - stock
                $qty = $new_values['quantity'];
                // Item Stock
                if ($detail_seed['new_quantity'] > 0) {
                    (new ItemStock)->update_item_stock($this->data['current_branch'], $item['item_id'], $warehouse_id, $source, $m_id, $d_id, $qty, 0, $item['unit_id'], $item['unit_type'], 0);
                }
            }
        }

        $insert['payments'] = $insert['payments'] ?? [];

        foreach ($insert['payments'] as $payment) {
            DB::table('notice_payments')->insert(array(
                'sales_invoice_m_id' => $insert['sales_invoice_m_id'],
                'notice_debtor_m_id' => $m_id,
                'machine_id'         => ($payment['payment_type'] == 1 ? 0 : $insert['machine_id'] ?? 0),
                'payment_type'       => $payment['payment_type'] ?? 1,
                'payment_text'       => $payment['payment_text'],
                'amount'             => $payment['amount']
            ));
        }

        (new NoticeDebtorHelper)->generate_daily_journal($m_id);




        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function print_invoice($id, Request $request)
    {
        $input = $request->all();

        App::setLocale('ar');
        $this->data['lang'] = 'ar';
        $this->data['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-010', $this->data['lang']);
        $this->data['master']      = NoticeDebtor::get_notice_debtor_m($id, $this->data['lang']);
        $this->data['details']     = NoticeDebtor::get_notice_debtor_d($id, $this->data['lang']);
        $this->data['branch_data'] = Branch::get_branch($this->data['master']->branch_id);

        $temp_name  = Setting::get_main_setting_by_code('notice_debtor_print')->value ?? 'temp_1';
        $print_temp = 'Print.notice_debtor.' . $temp_name;

        $this->data['qrcode']      = GenerateQrCode::fromArray([
            new Seller($this->data['branch_data']->vat_register_name), // Seller Name
            new TaxNumber($this->data['branch_data']->vat_number), // Seller Tax Number
            new InvoiceDate(date('Y-m-d\TH:i:s', strtotime($this->data['master']->add_date))),
            new InvoiceTotalAmount($this->data['details']->sum('new_total_price')), // Invoice Total Amount
            new InvoiceTaxAmount(round($this->data['details']->sum('new_total_vat') ?? 0, 2)) // Invoice Tax Amount
        ])->render();

        switch (@$input['type']) {
            case 'excel':
                $this->data['logo'] = public_path() . $this->data['branch_data']->branch_image;
                $export = new InvoicesExport($this->data, $print_temp);
                return Excel::download($export, 'notice_debtor.xlsx');
                break;
            case 'pdf':
                $this->data['logo'] = public_path() . $this->data['branch_data']->branch_image;
                $pdf = PDF::loadView($print_temp, array('data' => $this->data));
                return $pdf->stream();
                break;
            case 'image':
                $this->data['logo'] = public_path() . $this->data['branch_data']->branch_image;
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp, array('data' => $this->data));
                return $image->stream();
                break;
            case 'print':
                $this->data['logo'] = $this->data['branch_data']->branch_image;
                return view($print_temp)->with('data', $this->data);
                break;
        }
    }

    protected function get_next_codes($date, $year, $branch)
    {
        $data['year_ser']   = intval(DB::table('notice_debtors_m')
            ->where('finance_year_id', $year)
            ->max('year_ser')) + 1;

        $data['month_ser']  = intval(DB::table('notice_debtors_m')
            ->where('finance_year_id', $year)
            ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('notice_debtors_m')
            ->where('branch_id', $branch)
            ->max('branch_ser')) + 1;

        return $data;
    }
}
