<?php

namespace App\Http\Controllers\API\V1\Manufacturing;

use App\Classes\General\Upload;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Elevators\ElevatorsQuotation;
use App\Models\Main\ScreenSub;
use App\Models\Manufacturing\WorkOrders;
use Illuminate\Support\Facades\File;

use DB;
class WorkOrderController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('13-002','view');

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? null ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('13-002', $lang)->sub_title ?? '';
        $this->return['items']       = WorkOrders::all_work_orders($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('13-002','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('13-002', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }
    public function get_contract($lang,$id)
    {
        $this->checkPermission('13-002','add');
        $contract_id = DB::table('elevators_quotations')->where('invoice_code' , $id)->value('quotation_id');
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('13-002', $lang)->sub_title ?? '';
        $this->return['work_orders']    = WorkOrders::get_contract_orders($contract_id , null ,$lang);
        $this->return['item']           = ElevatorsQuotation::get_quotation($contract_id, $lang);
        $this->return['details']        = ElevatorsQuotation::get_quotation_payments(array('quotation_id' => $contract_id,'lang' => $lang));
        return $this->sendResponse($this->return);
    }
    public function store($lang, Request $request)
    {
        $this->checkPermission('13-002','add');

        $inputs             = $request->all();
        $insert =[
            'action_date'   => $inputs['action_date'] ?? date('Y-m-d'),
            'contract_id'   => $inputs['contract_id'] ,
        ];

        $validator = validator()->make($insert, WorkOrders::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        DB::beginTransaction();
        $this->return['id'] = WorkOrders::add_order_m($insert);
        if(isset($inputs['items']) && is_array($inputs['items'])){
            foreach($inputs['items'] as $item){
                $insert_details = [
                    'order_m_id'    => $this->return['id'],
                    'term_name'         => $item['term_name'],
                    'term_description'  => $item['term_description'],
                ];
                WorkOrders::add_order_d($insert_details);
            }
        }
        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('13-002','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('13-002', $lang)->sub_title ?? '';
        $this->return['master']         = WorkOrders::get_order_m($id, $lang);
        $this->return['details']        = WorkOrders::get_order_d($id, $lang);
        $this->return['attachments']    = WorkOrders::get_attachments($id, $lang);


        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('13-002','edit');
        $check = DB::table('manufacturing_m')->where([['active',1],['order_m_id',$id]])->count();
        if($check > 0){
            return $this->sendError(trans('error.this_order_is_used_in_manufacturning'));
        }
        $inputs    = $request->all();
        $update =[
            'action_date'   => $inputs['action_date'] ?? date('Y-m-d'),
            'contract_id'   => $inputs['contract_id'] ,
        ];
        $validator = validator()->make($update, WorkOrders::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        DB::beginTransaction();
        WorkOrders::update_order($update, $id);
        if(isset($inputs['items']) && is_array($inputs['items'])){
            DB::table('work_orders_d')->where('order_m_id',$id)->delete();
            foreach($inputs['items'] as $item){
                $insert_details = [
                    'order_m_id'        => $id,
                    'term_name'         => $item['term_name'],
                    'term_description'  => $item['term_description'],
                ];
                WorkOrders::add_order_d($insert_details);
            }
        }
        DB::commit();
        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('13-002','delete');
        $check = DB::table('manufacturing_m')->where([['active',1],['order_m_id',$id]])->count();
        if($check > 0){
            return $this->sendError(trans('error.this_order_is_used_in_manufacturning'));
        }
        WorkOrders::delete_order($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = WorkOrders::find($id);

        if($item->active){
            $this->checkPermission('13-002','delete');
            $check = DB::table('manufacturing_m')->where([['active',1],['order_m_id',$id]])->count();
            if($check > 0){
                return $this->sendError(trans('error.this_order_is_used_in_manufacturning'));
            }
            WorkOrders::delete_order($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('13-002','edit');

            WorkOrders::update_order(array('active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function add_attachments(Request $request)
    {
        $this->checkPermission('13-002','add');

        $input    = $request->all();

        $upload = (new Upload)->uploadFile($input['file_url'], 'work_orders_attachments');
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));
                    $this->return['id'] = DB::table('work_orders_attachments')->insertGetId([
                    'order_m_id'        => $input['order_m_id'],
                    'file_name'         => $input['filename'] ?? date('Y-m-d H:i:s'),
                    'file_url'          => $upload['url'],
                ]);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }
    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('13-002','delete');

        $file_url = DB::table('work_orders_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the server
        if ($file_url && File::exists(public_path($file_url))) {
            File::delete(public_path($file_url));
        }
        WorkOrders::delete_attachment($id);
        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }
}
