<?php

namespace App\Http\Controllers\API\V1\Manufacturing;

use App\Classes\General\Upload;
use App\Classes\RealTime\NotificationHelper;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Inventory\Item;
use App\Models\Inventory\UnitMeasurement;
use App\Models\Inventory\Warehouse;
use App\Models\Main\Notiffications;
use App\Models\Main\ScreenSub;
use App\Models\Manufacturing\Manufacturings;
use App\Models\Manufacturing\WorkOrders;
use Illuminate\Support\Facades\File;

use DB;
class ManufacturingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('13-001','view');

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? null ,
            'page'          => $request['page'] ?? 1 ,
            'status'        => $request['status'] ?? null,
            'word'          => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('13-001', $lang)->sub_title ?? '';
        $this->return['items']       = Manufacturings::all_manufacturing($this->filter);
        foreach($this->return['items'] as $item){
            $item->notifications = Notiffications::all_notifficationss(array('type' => 'manufacturing', 'action_id'=>$item->manufacturing_m_id , 'lang'=>$lang));
        };

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('13-001','add');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('13-001', $lang)->sub_title ?? '';
        $this->return['orders']             = WorkOrders::get_contract_orders(null,null, $lang);
        $this->return['warehouses']         = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['items']              = Item::all_items(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements']  = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));
        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('13-001','add');

        $inputs             = $request->all();

        $insert =[
            'action_date'   => $inputs['action_date'] ?? date('Y-m-d'),
            'order_m_id'    => $inputs['order_m_id'] ,
            'status'        => 1,

        ];

        $validator = validator()->make($insert, Manufacturings::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        DB::beginTransaction();
        $this->return['id'] = Manufacturings::add_manufacturing_m($insert);
        if(isset($inputs['items']) && is_array($inputs['items'])){
            foreach($inputs['items'] as $item){
                $insert_details = [
                    'manufacturing_m_id'  => $this->return['id'],
                    'exchange_date'     => $item['exchange_date'] ?? date('Y-m-d'),
                    'unit_id'           => $item['unit_id'],
                    'item_id'           => $item['item_id'],
                    'quantity'          => $item['quantity'] ?? 1,
                    'warehouse_id'      => $item['warehouse_id'] ,
                    'description'       => $item['description'] ?? null,
                ];
                Manufacturings::add_manufacturing_d($insert_details);
            }
        }
        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('13-001','view');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('13-001', $lang)->sub_title ?? '';
        $this->return['warehouses']         = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['items']              = Item::all_items(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements']  = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));
        $this->return['master']             = Manufacturings::get_manufacturing_m($id, $lang);
        $this->return['work_order']         = WorkOrders::get_contract_orders(null,$this->return['master']->order_m_id, $lang);
        $this->return['details']            = Manufacturings::get_manufacturing_d($id, $lang);
        $this->return['attachments']        = Manufacturings::get_attachments($id, $lang);
        $this->return['notifications']      = Notiffications::all_notifficationss(array('type' => 'manufacturing' , 'action_id' => $id , 'lang' => $lang  ));


        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('13-001','edit');
        $check = DB::table('manufacturing_m')->where('manufacturing_m_id',$id)->value('status');
        if($check == 3){
            return $this->sendError(trans('error.this is ended manufacturing'));
        }
        $inputs    = $request->all();
        $update =[
            'action_date'   => $inputs['action_date'] ?? date('Y-m-d'),
            'order_m_id'    => $inputs['order_m_id'] ,
        ];
        $validator = validator()->make($update, Manufacturings::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        DB::beginTransaction();

        Manufacturings::update_manufacturing($update, $id);
        if(isset($inputs['items']) && is_array($inputs['items'])){
            DB::table('manufacturing_d')->where('manufacturing_m_id' , $id)->delete();
            foreach($inputs['items'] as $item){
                $insert_details = [
                    'manufacturing_m_id'    => $id,
                    'exchange_date'         => $item['exchange_date'] ?? date('Y-m-d'),
                    'unit_id'               => $item['unit_id'],
                    'item_id'               => $item['item_id'],
                    'quantity'              => $item['quantity'] ?? 1,
                    'warehouse_id'          => $item['warehouse_id'] ,
                    'description'           => $item['description'] ?? null,
                ];
                Manufacturings::add_manufacturing_d($insert_details);
            }
        }
        DB::commit();

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('13-001','delete');
        $check = DB::table('manufacturing_m')->where('manufacturing_m_id',$id)->value('status');
        if($check == 3){
            return $this->sendError(trans('error.this is ended manufacturing'));
        }
        Manufacturings::delete_manufacturing($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }
    public function hold_manufacturing($lang, $id , Request $request)
    {
        $this->checkPermission('13-001','edit');
        $insert = [
            'title'         => 'Manufactoring Problem',
            'description'   => $request['description'] ?? null,
            'type'          => 'manufacturing',
            'action_id'     => $id,
            'add_user'      => auth()->user()->id,
        ];
        Notiffications::add_notiffication($insert);

        $count = DB::table('notiffications')->whereRaw('(FIND_IN_SET(?, users_read) = 0 OR users_read IS NULL)', [auth()->user()->id])
        ->count();
        (new NotificationHelper)->send_notifications($count , array('type' => 'manufacturing'));
        $update =[
            'status' => 2,
            'hold_date' => date('Y-m-d'),
        ];
        Manufacturings::update_manufacturing($update, $id);

        return $this->sendResponse([], trans('main.update_success'));
    }
    public function resume_manufacturing($lang, $id)
    {
        $this->checkPermission('13-001','edit');
        $status = Manufacturings::get_manufacturing_m($id, $lang)->status;
        if($status == 2){
            $update =[
                'status' => 1,
            ];
            Manufacturings::update_manufacturing($update, $id);
        }else{
            return $this->sendError(trans('error.error_in_status'));
        }

        return $this->sendResponse([], trans('main.update_success'));
    }
    public function end_manufacturing($lang, $id)
    {
        $this->checkPermission('13-001','edit');
        $update =[
            'status' => 3,
            'end_date' => date('Y-m-d'),
        ];
        Manufacturings::update_manufacturing($update, $id);

        return $this->sendResponse([], trans('main.update_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = Manufacturings::find($id);

        if($item->active){
            $this->checkPermission('13-001','delete');
            $check = DB::table('manufacturing_m')->where('manufacturing_m_id',$id)->value('status');
            if($check == 3){
                return $this->sendError(trans('error.this is ended manufacturing'));
            }
            Manufacturings::delete_manufacturing($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('13-001','edit');

            Manufacturings::update_manufacturing(array('active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function add_attachments(Request $request)
    {
        $this->checkPermission('13-001','add');

        $input    = $request->all();

        $upload = (new Upload)->uploadFile($input['file_url'], 'manufacturing_attachments');
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));
                    $this->return['id'] = DB::table('manufacturing_attachments')->insert([
                    'manufacturing_m_id'  => $input['manufacturing_m_id'],
                    'file_name'         => $inputs['filename'] ?? date('Y-m-d H:i:s'),
                    'file_url'          => $upload['url']
                ]);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }
    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('13-001','delete');

        $file_url = DB::table('manufacturing_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the server
        if ($file_url && File::exists(public_path($file_url))) {
            File::delete(public_path($file_url));
        }
        Manufacturings::delete_attachments($id);
        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }
    public function all_notifications($lang, Request $request)
    {
        // $this->checkPermission('13-001','view');
        $this->filter = array(
            'lang'          => $lang ,
            'rows'          => $request['rows'] ?? null ,
            'page'          => $request['page'] ?? 1 ,
            'type'          => 'manufacturing',
        );
            $this->return['notifications'] = Notiffications::all_notifficationss($this->filter);
            return $this->sendResponse($this->return);

    }
    public function read_notification($lang , $id)
    {
        $this->checkPermission('13-001','view');
            $old_reads = DB::table('notiffications')->where('id',$id)->value('users_read');

            $users_read = array_map('intval',explode(',',($old_reads)));

            array_push($users_read, auth()->user()->id);
            $update_users_read = array_unique($users_read);
                 DB::table('notiffications')->where('id',$id)
                ->update([
                     'users_read' => implode(',',($update_users_read))
                ]);

            return $this->sendResponse([], trans('main.update_success'));

    }
}
