<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use Illuminate\Http\Request;

use App\Models\Main\ScreenMain;
use App\Models\Main\ScreenSub;


class ScreenMainController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-001' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-001' , $lang)->sub_title ?? '';
        $this->return['items']       = ScreenMain::all_screen_mains( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-001' , [] , 200 );
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-001' , $lang)->sub_title ?? '';

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-001' , [] , 200 );
        }

        $insert             = $request->only(['screen_main_title_en', 'screen_main_title_ar', 'screen_main_image']);
        $insert['add_user'] = auth()->user()->id;
        $validator          = validator()->make( $insert , ScreenMain::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        if(isset($insert['screen_main_image']) && strlen($insert['screen_main_image']) > 100 ){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($insert['screen_main_image'] , 'screen_main' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $insert['screen_main_image'] = $check['url'];
        }

        $this->return['id'] = ScreenMain::add_screen_main($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-001' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-001' , $lang)->sub_title ?? '';
        $this->return['data']               = ScreenMain::find($id);

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-001' , [] , 200 );
        }

        $update     = $request->only(['screen_main_title_en', 'screen_main_title_ar', 'screen_main_image']);
        $validator  = validator()->make( $update , ScreenMain::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        if(isset($update['screen_main_image']) && strlen($update['screen_main_image']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($update['screen_main_image'] , 'screen_main' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $update['screen_main_image'] = $check['url'];
        }

        ScreenMain::update_screen_main($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-001' , [] , 200 );
        }

        ScreenMain::delete_screen_main($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-001'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-001' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            ScreenMain::update_screen_main(array('screen_main_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = ScreenMain::find($id);
        if($item->screen_main_active){

            if(!@in_array('4', $this->data['mypermissions']['01-001'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-001' , [] , 200 );
            }

            ScreenMain::delete_screen_main($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-001'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-001' , [] , 200 );
            }

            ScreenMain::update_screen_main(array('screen_main_active' => 1 ),  $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
