<?php

namespace App\Http\Controllers\API\V1\Main;

use App\Http\Controllers\API\V1\BaseController;
use App\Models\Main\Branch;
use Illuminate\Http\Request;

use App\Models\Main\Delegate;
use App\Models\Main\ScreenSub;


class DelegateController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-015' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-015' , $lang)->sub_title ?? '';
        $this->return['items']       = Delegate::all_delegates( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-015' , [] , 200 );
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-015' , $lang)->sub_title ?? '';
        $this->return['branchs']     = Branch::all_branchs(array('lang' => $lang , 'active' => 1 ));

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-015' , [] , 200 );
        }
        $insert            = $request->only(['name_en', 'name_ar', 'mobile', 'customer_id', 'supplier_id', 'branchs']);
        $insert['branchs'] = (is_array($insert['branchs'] ?? '')) ? implode(',' , $insert['branchs']) : $insert['branchs'];

        $validator = validator()->make($insert , Delegate::$rules);

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $insert['add_user'] = auth()->user()->id;
        $this->return['id'] = Delegate::add_delegate($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-015' , [] , 200 );
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-015' , $lang)->sub_title ?? '';
        $this->return['data']        = Delegate::get_delegate($id);
        $this->return['branchs']     = Branch::all_branchs(array('lang' => $lang , 'active' => 1 ));

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-015' , [] , 200 );
        }

        $update            = $request->only(['name_en', 'name_ar', 'mobile', 'customer_id', 'supplier_id', 'branchs']);
        $update['branchs'] = (is_array($update['branchs'] ?? '')) ? implode(',' , $update['branchs']) : $update['branchs'];

        $validator  = validator()->make($update , Delegate::$rules);

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        Delegate::update_delegate($update, $id);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-015' , [] , 200 );
        }

        Delegate::delete_delegate($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-015'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-015' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            Delegate::update_delegate(array('delegate_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = Delegate::find($id);
        if($item->delegate_active){

            if(!@in_array('4', $this->data['mypermissions']['01-015'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-015' , [] , 200 );
            }

            Delegate::delete_delegate($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-015'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-015' , [] , 200 );
            }

            Delegate::update_delegate(array('delegate_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
}
