<?php

namespace App\Http\Controllers\API\V1\Inventory;
use App\Classes\ItemStock;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Inventory\Item;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use DB;
use PDF;
use Excel;
use App;

class ReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    // Item Card

    public function item_card_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-010'][0]->permission)){
            return $this->sendError('view permission needed #03-010', $this->data, 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-010', $lang)->sub_title ?? '';
        $this->return['items']       = DB::table('items')->select('item_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function item_card_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-010'][0]->permission)){
            return $this->sendError('view permission needed #03-010', $this->data, 200);
        }

        $this->return['item_card'] = Item::get_item($request['item_id'], $lang);
        $this->return['item_logs'] = (new ItemStock)->get_item_stock_logs(array('lang' => $lang, 'item_id' => $request['item_id'], 'to_date' => $request['to_date']));

        return $this->sendResponse($this->return);
    }

    // Warehouse Balances

    public function warehouse_balance_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-011'][0]->permission)){
            return $this->sendError('view permission needed #03-011', $this->data, 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-011', $lang)->sub_title ?? '';
        $this->return['warehouses']  = DB::table('warehouses')->select('warehouse_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function warehouse_balance_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-011'][0]->permission)){
            return $this->sendError('view permission needed #03-011', $this->data, 200);
        }

        $this->return['items'] = (new ItemStock)->get_item_stock(array('lang' => $lang, 'warehouse_id' => $request['warehouse_id'], 'to_date' => $request['to_date']));

        return $this->sendResponse($this->return);
    }

    // Warehouse Evaluation

    public function warehouse_evaluation_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-012'][0]->permission)){
            return $this->sendError('view permission needed #03-012', $this->data, 200);
        }

        $this->return['screen_name']       = ScreenSub::get_screen_sub_by_screen_code('03-012', $lang)->sub_title ?? '';
        $this->return['warehouses']        = DB::table('warehouses')->select('warehouse_id as id','name_'.$lang.' as name')->get();
        $this->return['unit_measurements'] = DB::table('unit_measurements')->select('unit_measurement_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function warehouse_evaluation_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-012'][0]->permission)){
            return $this->sendError('view permission needed #03-012', $this->data, 200);
        }

        $this->return['items'] = (new ItemStock)->get_item_stock(array('lang' => $lang, 'warehouse_id' => $request['warehouse_id'], 'to_date' => $request['to_date']));

        return $this->sendResponse($this->return);
    }

    // Item Trial Balance

    public function item_trial_balance_get($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-013'][0]->permission)){
            return $this->sendError('view permission needed #03-013', $this->data, 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-013', $lang)->sub_title ?? '';
        $this->return['warehouses']  = DB::table('warehouses')->select('warehouse_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function item_trial_balance_post($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-013'][0]->permission)){
            return $this->sendError('view permission needed #03-013', $this->data, 200);
        }

        $this->return['report'] = [];
        $data = [];

        $data['first'] = (new ItemStock)->get_item_stock_logs(array('lang' => $lang, 'warehouse_id' => $request['warehouse_id'], 'before' => $request['from_date']));
        $data['in']    = (new ItemStock)->get_item_stock_logs(array('lang' => $lang, 'warehouse_id' => $request['warehouse_id'], 'from_date' => $request['from_date'], 'to_date' => $request['to_date'], 'stock_in' => true));
        $data['out']   = (new ItemStock)->get_item_stock_logs(array('lang' => $lang, 'warehouse_id' => $request['warehouse_id'], 'from_date' => $request['from_date'], 'to_date' => $request['to_date'], 'stock_out' => true));

        $data['first_stock'] = collect($data['first'])->sum('stock');
        $data['first_value'] = collect($data['first'])->sum('value');

        $data['in_stock']    = collect($data['in'])->sum('stock');
        $data['in_value']    = collect($data['in'])->sum('value');

        $data['out_stock']   = collect($data['out'])->sum('stock');
        $data['out_value']   = collect($data['out'])->sum('value');

        foreach ($data['first'] as $key => $row){
            $first_stock = $row->stock;
            $first_value = $row->value;

            $final_stocks = $data['first'][$key]->stock + $data['in'][$key]->stock + $data['out'][$key]->stock;
            $final_values = $data['first'][$key]->value + $data['in'][$key]->value + $data['out'][$key]->value;

            $this->return['report'][] = [
                'item_name'   => $row->item_name,
                'first_stock' => $first_stock,
                'first_value' => $first_value,
                'in_stock'    => $data['in'][$key]->stock,
                'in_value'    => $data['in'][$key]->value,
                'out_stock'   => $data['out'][$key]->stock,
                'out_value'   => $data['out'][$key]->value,
                'final_stock' => $final_stocks,
                'final_value' => $final_values
            ];
        }
        foreach ($data['first'] as $item){
            $first_stock = $row->stock;
            $first_value = $row->value;
            
            $final_stocks = $data['first'][$key]->stock + $data['in'][$key]->stock + $data['out'][$key]->stock;
            $final_values = $data['first'][$key]->value + $data['in'][$key]->value + $data['out'][$key]->value;

            $this->return['report'][] = [
                'item_name'   => $row->item_name,
                'first_stock' => $first_stock,
                'first_value' => $first_value,
                'in_stock'    => $data['in'][$key]->stock,
                'in_value'    => $data['in'][$key]->value,
                'out_stock'   => $data['out'][$key]->stock,
                'out_value'   => $data['out'][$key]->value,
                'final_stock' => $final_stocks,
                'final_value' => $final_values
            ];
        }

        $this->return['report'][] = [
            'item_name'   => trans('main.Total'),
            'first_stock' => $data['first_stock'],
            'first_value' => $data['first_value'],
            'in_stock'    => $data['in_stock'],
            'in_value'    => $data['in_value'],
            'out_stock'   => $data['out_stock'],
            'out_value'   => $data['out_value'],
            'final_stock' => $data['first_stock'] + $data['in_stock'] + $data['out_stock'],
            'final_value' => $data['first_value'] + $data['in_value'] + $data['out_value'],
        ];

        return $this->sendResponse($this->return);
    }
}
