<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Classes\Excel\InvoicesExport;
use App\Classes\Finance\VoucherReceiptHelper;


use App\Models\Finance\VoucherReceipt;
use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Main\ScreenSub;
use App\Models\Main\Bank;
use App\Models\Main\Delegate;
use App\Models\Main\Supplier;
use App\Models\Main\Customer;



class VoucherReceiptController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-007' , $this->data , 200 );
        }
        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 20 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'branch'        => $this->data['current_branch'] ,
            'finance_year'  => $this->data['current_year']
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['items']       = VoucherReceipt::all_voucher_receipt( $this->filter );
        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-007' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['bank']               = Bank::all_banks( array('lang' => $lang , 'active' => 1 ) );
        $this->return['delegates']          = Delegate::all_delegates( array('lang' => $lang , 'active' => 1 ) );
        $this->return['suppliers']          = Supplier::all_suppliers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['customers']          = Customer::all_customers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));


        return $this->sendResponse( $this->return  );
    }

 
    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-007' , [] , 200 );
        }
        $insert = $request->all();
        $year   = array_search( date("Y" , strtotime($insert['action_date'])) , $this->data['years'] );
        if($year == ''){
            return $this->sendError( trans("error.finance_year_not_aval"));
        }
        $codes = (new VoucherReceiptHelper)->get_next_codes($insert['action_date'] , $year , $this->data['current_branch'] );

        $insert_seed = array(
            'finance_year_id'   => $year ,
            'branch_id'         => $this->data['current_branch'] ,
            'description'       => $insert['description'] ,
            'year_ser'          => $codes['year_ser'] ,
            'month_ser'         => $codes['month_ser'] ,
            'branch_ser'        => $codes['branch_ser'] ,
            'action_date'       => $insert['action_date'] ,
            'cost_center_id'    => $insert['cost_center_id'] ?? 0 ,
            'amount'            => $insert['amount'] ?? 0 ,
            'invoice_type'      => $insert['invoice_type'] ?? 2 ,
            'delegate_id'       => $insert['delegate_id'] ?? 0 ,


            'from_type'             => $insert['from_type'] ?? 1 ,
            'from_account_tree_id'  => $insert['from_account_tree_id'] ?? 0 ,
            'from_supplier_id'      => $insert['from_supplier_id'] ?? 0 ,
            'from_customer_id'      => $insert['from_customer_id'] ?? 0 ,


            'collect_type'          => $insert['collect_type'] ?? 1 ,
            'to_account_tree_id'    => $insert['to_account_tree_id'] ?? 0 ,
            'to_treasury_id'        => $insert['to_treasury_id'] ?? 0 ,
            'to_bank_id'            => $insert['to_bank_id'] ?? 0 ,
            'due_date'              => $insert['due_date'] ?? 0 ,
            'cheq_number'           => $insert['cheq_number'] ?? 0 ,


            'add_user'              => auth()->user()->id  
        );


        $validator = validator()->make( $insert_seed , VoucherReceipt::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $id = VoucherReceipt::add_voucher_receipt($insert_seed);

        $this->return['id'] = $id;

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'show permission needed #02-007' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['data']               = VoucherReceipt::get_voucher_receipt($id);
        $this->return['delegates']          = Delegate::all_delegates( array('lang' => $lang , 'active' => 1 ) );
        $this->return['suppliers']          = Supplier::all_suppliers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['customers']          = Customer::all_customers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));

        
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


    public function update($lang , $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-007' , [] , 200 );
        }
        $update_seed    = collect( $request->all() )->only('description' , 'delegate_id' , 'cost_center_id')->all() ;
        VoucherReceipt::update_voucher_receipt($update_seed ,  $id);
        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['02-007'][0]->permission) ){
            return $this->sendError( 'delete permission needed #02-007' , [] , 200 );
        }
        VoucherReceipt::delete_voucher_receipt($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang , $id){

        $item = VoucherReceipt::find($id);
        if($item->voucher_receipt_active){

            if(!@in_array('4', $this->data['mypermissions']['02-007'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-007' , [] , 200 );
            }

            if( !(new VoucherReceiptHelper)->can_edit_or_delete($id) ){
                return $this->sendError( trans('error.delete_fails') , [] );
            }

            VoucherReceipt::delete_voucher_receipt($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['02-007'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-007' , [] , 200 );
            }

            VoucherReceipt::update_voucher_receipt(array('voucher_receipt_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    

}
