<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Finance\AccountTreeHelper;
use App\Classes\Excel\InvoicesExport;

use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Finance\DailyJournal;
use App\Models\Main\ScreenSub;
use App\Models\Main\Branch;


use DB;
use PDF;
use Excel;
class ReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();


    public function taxـdeclaration_get($lang , Request $request){

        $this->checkPermission('06-016','view');
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-016' , $lang)->sub_title ?? '';
        $this->return['from']           = ($this->data['years'][$this->data['current_year']] ?? date("Y"))."-01-01" ;
        $this->return['to']             = date("Y-m-d");

        return $this->sendResponse( $this->return  );
    }

    public function tax_declaration_post($lang , Request $request){

        // $this->checkPermission('06-016','print');

        $this->return['from']           = $request['from'] ?? date("Y-m-01");
        $this->return['to']             = $request['to'] ?? date("Y-m-t");
        $this->return['branch_id']      = $request['branch_id'] ?? 0;

        $tax_types                      = DB::table('tax_types')->get();


        if(in_array(request()->header('clientID'), ["802","test"]) ){
        $report                         = DB::select('call p_tax_declaration("'.$this->return['from'].'" , "'.$this->return['to'].'" , '.$this->return['branch_id'].')');
        }else{
        $report                         = DB::select('call p_tax_declaration("'.$this->return['from'].'" , "'.$this->return['to'].'" )');

        }
        $report_collection              = collect($report);
        $this->return['report']         = [];

        foreach ($tax_types as $key => $value) {
            $tax_type_items = $report_collection->where('tax_type_id' , $value->tax_type_id );
            $this->return['report'][] = [
                'id'        => $value->tax_type_id ,
                'name'      => ($lang == 'ar' ? $value->name_ar :  $value->name_en ) ,
                'in_time'   => $tax_type_items->where('in_time' , 1 )->sum('total_without_vat') ,
                'out_time'  => $tax_type_items->where('in_time' , 0 )->sum('total_without_vat'),
                'vat'       => $tax_type_items->sum('total_vat') ,
                'items_in_time'     => $tax_type_items->where('in_time' , 1 )->values()->all() ,
                'items_out_time'    => $tax_type_items->where('in_time' , 0 )->values()->all()
            ];
        }

        return $this->sendResponse( $this->return );

    }


    public function account_statment_anal_report_get($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-004'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-004' , $this->data , 200 );
        }
        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => '1' ));
        $this->return['branchs']   = Branch::all_branchs(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse( $this->return  );

    }
    public function account_statment_anal_report_post($lang , Request $request)
    {

        if(!@in_array('1', $this->data['mypermissions']['02-004'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-004' , $this->data , 200 );
        }
        $this->return['from']             = $request['from'];
        $this->return['branch_id']        = $request['branch_id'] ?? null;
        $this->return['to']               = $request['to'] ?? date("Y-m-d");
        $this->return['lang']             = $lang;
        $this->return['screen_name']      = ScreenSub::get_screen_sub_by_screen_code('02-004' , $lang);
        $this->return['first']            = DailyJournal::get_account_balance($request['account_tree_id'] , $lang , array('total' => true , 'before' => $this->return['from'] , 'branch_id'=>$this->return['branch_id'] ) );
        $this->return['actions']          = DailyJournal::get_account_balance($request['account_tree_id'] , $lang , array('from' => $this->return['from']  , 'to' => $this->return['to'] , 'branch_id'=>$this->return['branch_id'] ) );
        $this->return['account_tree']     = AccountTree::get_account_tree( $request['account_tree_id'] , $lang );
        $this->return['logo']             = get_logo(1);
        $this->return['branch']           = Branch::get_branch( $this->data['current_branch'] , 'en');


        if($this->return['first']->total < 0 ){
            $this->return['first']->debit    = 0;
            $this->return['first']->credit   = $this->return['first']->total * -1;
        }else{
            $this->return['first']->debit    = $this->return['first']->total;
            $this->return['first']->credit   = 0;
        }


        switch (@$request['type']) {
            case 'excel':
                $this->return['logo']     = public_path().$this->return['logo'];
                $export = new InvoicesExport($this->return , 'Finance/report/account_statment_anal');
                return Excel::download($export, 'balances.xlsx');
            break;
            case 'pdf':
                $this->return['logo']     = public_path().$this->return['logo'];
                $pdf = PDF::loadView('Finance/report/account_statment_anal', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
                return $pdf->stream();
            break;
            case 'print':
                return view('Finance/report/account_statment_anal')->with('data' , $this->return);
            break;
            case 'json':
                return $this->sendResponse( $this->return  );
                // return view('finance/report/account_statment_anal_p')->with('data' , $this->return);
            break;
        }

    }




    public function trial_balance_report($lang , Request $request)
    {
        if(!@in_array('5', $this->data['mypermissions']['02-005'][0]->permission) ){
            return redirect()->to('/admin')->withErrors('permission needed #02-005')->send();
        }

        $this->data['from']             = $request['from'];
        $this->data['to']               = $request['to'];
        $this->return['lang']           = $lang;
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-005' , $this->return['lang']);
        $this->return['report']         = [];
        $data                           = [];
        $this->return['first']          = DB::select('call p_trial_balance("2000-01-01" ,  "'.date("Y-m-d" , strtotime($this->data['from']."- 1 day")).'"  , "'.$this->return['lang'].'" )  ');

        // foreach ($this->return['first'] as $key => $value) {
        //     if( substr($this->return['first'][$key]->account_code , 0, 1) == "3" || substr($this->return['first'][$key]->account_code , 0, 1) == "4" ){
        //         $this->return['first'][$key]->credit = 0;
        //         $this->return['first'][$key]->debit = 0;
        //         $this->return['first'][$key]->total = 0;
        //     }
        // }

        $this->return['actions']                = DB::select('call p_trial_balance("'.$this->data['from'].'" ,  "'.$this->data['to'].'"  , "'.$this->return['lang'].'" )  ');
        $this->return['first_debit']            = collect($this->return['first'])->whereIn('account_code', [1, 3])->sum('total');
        $this->return['first_credit']           = collect($this->return['first'])->whereIn('account_code', [2, 4, 5])->sum('total');
        $this->return['actions_debit']          = collect($this->return['actions'])->whereIn('account_code', [1, 2 , 3 , 4 , 5])->sum('debit');
        $this->return['actions_credit']         = collect($this->return['actions'])->whereIn('account_code', [1, 2 , 3 , 4 , 5])->sum('credit');
        if($this->return['first_debit'] < 0){$this->return['first_debit'] = $this->return['first_debit'] * -1 ;}
        if($this->return['first_credit'] < 0){$this->return['first_credit'] = $this->return['first_credit'] * -1 ;}
        foreach($this->return['first'] as $key => $row){

            if($row->total < 0 ){
                $first_debit    = 0;
                $first_credit   = $row->total * -1;
            }else{
                $first_debit    = $row->total;
                $first_credit   = 0;
            }

            $final_debit    = $this->return['actions'][$key]->debit + $first_debit ;
            $final_credit   = $this->return['actions'][$key]->credit + $first_credit ;

            $final = $final_debit - $final_credit;
            if($final < 0 ){
                $final_debit    = 0;
                $final_credit   = $final * -1;
            }else{
                $final_debit    = $final ;
                $final_credit   = 0;
            }

            $this->return['report'][] = [
                'account_tree_id'   => $row->account_tree_id ?? 0 ,
                'account_code'      => $row->account_code ,
                'parent_id'         => $row->parent_id ,
                'name'              => $row->name ,
                'account_level'     => $row->account_level ?? 0,
                'account_type'      => $row->account_type ,
                'first_debit'       => $first_debit ,
                'first_credit'      => $first_credit ,
                'actions_debit'     => $this->return['actions'][$key]->debit ,
                'actions_credit'    => $this->return['actions'][$key]->credit ,
                'final_debit'       => $final_debit ,
                'final_credit'      => $final_credit
            ];
       }

       $this->return['report'][] = [
            'account_tree_id'   => 0 ,
            'account_code'      => 'total' ,
            'name'              => 'total',
            'account_type'      => '',
            'account_level'     => '',
            'first_debit'       => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('first_debit') ,
            'first_credit'      => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('first_credit') ,
            'actions_debit'     => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('actions_debit')  ,
            'actions_credit'    => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('actions_credit')  ,
            'final_debit'       => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('final_debit') ,
            'final_credit'      => collect($this->return['report'])->whereIn('account_code', [1,2,3,4,5])->sum('final_credit')
        ];


       // $this->return['report'][] = [
       //      'account_tree_id'   => 0 ,
       //      'account_code'      => 'total' ,
       //      'name'              => 'total',
       //      'account_type'      => '',
       //      'first_debit'       => $this->return['first_debit'] ,
       //      'first_credit'      => $this->return['first_credit'] ,
       //      'actions_debit'     => $this->return['actions_debit'] ,
       //      'actions_credit'    => $this->return['actions_credit'] ,
       //      'final_debit'       => $this->return['actions_debit'] + $this->return['first_debit'] ,
       //      'final_credit'      => $this->return['actions_credit'] + $this->return['first_credit']
       //  ];


        $this->return['logo']       = get_logo(1);
        $this->return['branch']     = Branch::get_branch( $this->data['current_branch'] , 'en');

        switch (@$request['type']) {
            case 'excel':
                $this->return['logo']     = public_path().$this->return['logo'];
                $export = new InvoicesExport($this->return , 'Finance/report/trial_balance');
                return Excel::download($export, 'balances.xlsx');
            break;
            case 'pdf':
                $this->return['logo']     = public_path().$this->return['logo'];
                $pdf = PDF::loadView('Finance/report/trial_balance', array('data' => $this->return ))->setOption("footer-center", "[page] / [topage]");
                return $pdf->stream();
            break;
            case 'print':
                return view('Finance/report/trial_balance')->with('data' , $this->return);
            break;
            case 'json':
                return $this->sendResponse( $this->return  );
                // return view('finance/report/account_statment_anal_p')->with('data' , $this->data);
            break;
        }

    }

}
