<?php
namespace App\Http\Controllers\API\V1\Finance;

use App\Classes\Finance\DailyJournalHelper;
use App\Classes\Sales\DailyReportHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Finance\AccountTree;
use App\Models\Finance\DailyJournal;
use Illuminate\Http\Request;

use DB;
use App\Models\Finance\FinancialPeriod;
use App\Models\Main\FinanceYear;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;

class FinancialPeriodController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-009'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-009' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 10 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null 
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-009' , $lang)->sub_title ?? '';
        $this->return['items']       = FinancialPeriod::all_financial_periods( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-009'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-009' , [] , 200 );
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-009' , $lang)->sub_title ?? '';
        $this->return['finance_years']  = FinanceYear::all_finance_years(array('lang' => $lang , 'active' => '1' , 'user' => auth()->user()->id ));
        $this->return['closin_year_account'] = intval(Setting::get_main_setting_by_code('closing_year_account')->value ?? 0 );
        $this->return['account_trees']     = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => 1));

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-009'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-009' , [] , 200 );
        }

        $insert             = $request->only(['finance_year_id', 'months']);
        $insert['months']   = array_unique( ( is_array($insert['months'] ?? []) ) ? $insert['months'] : explode(',', $insert['months'] ?? [] )  ) ;
        $validator = validator()->make( $insert , FinancialPeriod::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        $monthsItems        = collect(array_unique($insert['months']))->sort()->values()->all();
        $insert['months']   = (is_array($monthsItems ?? '')) ? implode(',' , $monthsItems) : $monthsItems;
        $insert['add_user'] = auth()->user()->id;

        $this->return['id'] = FinancialPeriod::add_financial_period($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-009'][0]->permission) ){
            return $this->sendError( 'show permission needed #02-009' , [], 200 );
        }

        $this->return['screen_name']            = ScreenSub::get_screen_sub_by_screen_code('02-009' , $lang)->sub_title ?? '';
        $this->return['financial_period']       = FinancialPeriod::get_financial_period( $id );
        $this->return['closin_year_account']    = intval(Setting::get_main_setting_by_code('closing_year_account')->value ?? 0 ) ;
        $this->return['account_trees']          = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => 1));
        $this->return['finance_years']          = FinanceYear::all_finance_years(array('lang' => $lang , 'active' => '1' , 'user' => auth()->user()->id ));

        return $this->sendResponse( $this->return );
    }

    public function update($lang , $id , Request $request )
    {
        if(!@in_array('2', $this->data['mypermissions']['02-009'][0]->permission) ){
            return $this->sendError( 'show permission needed #02-009' , [], 200 );
        }

        $update             = $request->only(['finance_year_id', 'months']);
        $update['months']   = array_unique( ( is_array($update['months'] ?? []) ) ? $update['months'] : explode(',', $update['months'] ?? [] )  ) ;
        $validator          = validator()->make( $update , FinancialPeriod::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $monthsItems = collect($update['months'])->sort()->values()->all();
        $update['months'] = (is_array($monthsItems ?? '')) ? implode(',' , $monthsItems) : $monthsItems;

        FinancialPeriod::update_financial_period($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-010' , [] , 200 );
        }

        FinancialPeriod::delete_financial_period($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function toggle_active($lang , $id){

        $item = FinancialPeriod::find($id);
        if($item->financial_period_active){

            if(!@in_array('4', $this->data['mypermissions']['02-009'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-009' , [] , 200 );
            }

            FinancialPeriod::delete_financial_period($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['02-009'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-009' , [] , 200 );
            }

            FinancialPeriod::update_financial_period(array('financial_period_active' => 1 ) , $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function close_finance_year($lang, $id, Request $request)
    {
        $this->checkPermission('02-009','edit');

        FinancialPeriod::get_financial_period( $id );
        $year   = FinanceYear::get_finance_year($id)->name;
        if($year == ''){
            return array( false ,  trans("error.finance_year_not_aval") );
        }
        $closin_year_account = intval(Setting::get_main_setting_by_code('closing_year_account')->value ?? $request['account_tree_id'] );

        $expenses_accounts = DB::table('account_tree')->where([ //debit
            ['active',1],
            ['account_code', 'like', '3%'],
            ['account_type' , 2 ]
            ])->pluck('account_tree_id')->toArray();
        $revenues_accounts = DB::table('account_tree')->where([//credit
            ['active',1],
            ['account_code', 'like', '4%'],
            ['account_type' , 2 ]
            ])->pluck('account_tree_id')->toArray();

            
            $codes = (new DailyJournalHelper)->get_next_codes(date('Y-m-d') , $year , $this->data['current_branch'] );
    
            $master_seed = array(
                'finance_year_id'   => $year ,
                'branch_id'         => $this->data['current_branch'] ,
                'description'       => 'Closing a financial year' ,
                'year_ser'          => $codes['year_ser'] ,
                'month_ser'         => $codes['month_ser'] ,
                'branch_ser'        => $codes['branch_ser'] ,
                'journal_date'      => date('Y-m-d') ,
                'daily_type_id'     => 35 , 
                'auto_generated'    => 0 ,
                'document_id'       => 0 ,
                'confirmed'         => 1 ,
                'journal_active'    => 1 ,
                'add_user'          => auth()->user()->id  
            );
    
            $validator = validator()->make( $master_seed , DailyJournal::$master_rules );
            if($validator->fails())
            {
                return $this->sendError(trans('error.add_fails'), $validator->errors());

            }
            DB::beginTransaction();

            $m_id = DailyJournal::add_daily_journal_m($master_seed);
            foreach($expenses_accounts as $account_id){
                $journals = DB::table('daily_journal_d')
                    ->join('daily_journal_m','daily_journal_d.daily_journal_m_id','daily_journal_m.daily_journal_m_id')
                    ->where('journal_active' , 1)
                    ->where('confirmed' , 1)
                    ->where('daily_journal_m.finance_year_id' , $id)
                    ->where('daily_journal_d.account_tree_id' , $account_id)
                    ->selectRaw('sum(debit) as debit , sum(credit) as credit , (sum(debit) - sum(credit)) as total')
                    ->first();

                if($journals->total > 0){
                    $credit = $journals->total;
                    $debit = 0;
                }elseif($journals->total < 0){
                    $credit = 0;
                    $debit = abs($journals->total);
                }else{
                    $credit = 0;
                    $debit = 0;
                }

                $det_seed = array(
                    'daily_journal_m_id'        => $m_id ,
                    'account_tree_id'           => $account_id ,
                    'cost_centers'              =>  "" ,
                    'debit'                     => doubleval($debit) ,
                    'credit'                    => doubleval($credit)  ,
                    'description'               => 'expenses Accounts'
                );

                $validator = validator()->make( $det_seed , DailyJournal::$detaile_rules );
                if($validator->fails())
                {
                    return $this->sendError(trans('error.add_fails'), $validator->errors());

                }

                DailyJournal::add_daily_journal_d($det_seed);
            }
            foreach($revenues_accounts as $account_id){
                $journals = DB::table('daily_journal_d')
                ->join('daily_journal_m','daily_journal_d.daily_journal_m_id','daily_journal_m.daily_journal_m_id')
                ->where('journal_active' , 1)
                ->where('confirmed' , 1)
                ->where('daily_journal_m.finance_year_id' , $id)
                ->where('daily_journal_d.account_tree_id' , $account_id)
                ->selectRaw('sum(debit) as debit , sum(credit) as credit , (sum(debit) - sum(credit)) as total')->first();

                if($journals->total > 0){
                    $credit = $journals->total;
                    $debit = 0;
                }elseif($journals->total < 0){
                    $credit = 0;
                    $debit = abs($journals->total);
                }else{
                    $credit = 0;
                    $debit = 0;
                }
                $det_seed = array(
                    'daily_journal_m_id'        => $m_id ,
                    'account_tree_id'           => $account_id ,
                    'cost_centers'              =>  "" ,
                    'debit'                     => doubleval($debit) ,
                    'credit'                    => doubleval($credit)  ,
                    'description'               => 'revenues Accounts'
                );

                $validator = validator()->make( $det_seed , DailyJournal::$detaile_rules );
                if($validator->fails())
                {
                    return $this->sendError(trans('error.add_fails'), $validator->errors());

                }

                DailyJournal::add_daily_journal_d($det_seed);
            }
            // check diff between debit and credit 
            $sum_depit = DB::table('daily_journal_d')->where('daily_journal_m_id',$m_id)->sum('debit');
            $sum_credit = DB::table('daily_journal_d')->where('daily_journal_m_id',$m_id)->sum('credit');
            $diff = $sum_credit - $sum_depit ;
            if($diff > 0){
                $credit = 0;
                $debit = $diff;
            }elseif($diff < 0){
                $credit = abs($diff);
                $debit = 0;
            }
            $det_seed = array(
                'daily_journal_m_id'        => $m_id ,
                'account_tree_id'           => $closin_year_account ,
                'cost_centers'              =>  "" ,
                'debit'                     => doubleval($debit) ,
                'credit'                    => doubleval($credit)  ,
                'description'               => 'closing year Accounts'
            );

            $validator = validator()->make( $det_seed , DailyJournal::$detaile_rules );
            if($validator->fails())
            {
                return $this->sendError(trans('error.add_fails'), $validator->errors());

            }

            DailyJournal::add_daily_journal_d($det_seed);

        FinanceYear::update_finance_year(array('daily_journal_id' => $m_id) , $id );

        DB::commit();
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
