<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Classes\Excel\InvoicesExport;
use App\Classes\Finance\DailyJournalHelper;

use App\Classes\General\Upload;


use App\Models\User;
use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Finance\DailyJournal;
use App\Models\Main\ScreenSub;
use App\Models\Main\DailyType;
use App\Models\Main\Branch;

use DB;
use App;
use File;
use PDF;
use Excel;


class DailyJournalController extends BaseController
{

    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-003' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 10 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'branch'        => $this->data['current_branch'] ,
            'finance_year'  => $this->data['current_year']
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-001' , $lang)->sub_title ?? '';
        $this->return['items']       = DailyJournal::all_daily_journals( $this->filter );


        return $this->sendResponse( $this->return );
    }


    public function create($lang )
    {
        if(!@in_array('2', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-003' , $this->data , 200 );
        }
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-003' , $lang)->sub_title ?? '';

        $this->return['daily_types']    = DailyType::all_daily_types(array('lang' => $lang , 'active' => '1' ));
        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => '1' ));
        $this->return['cost_centers']   = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => '1' ));

        return $this->sendResponse( $this->return );
    }

    public function store( $lang , Request $request )
    {
        if(!@in_array('2', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'store permission needed #02-003' , $this->data , 200 );
        }

        $insert = $request->all();

        $insert['des']          = $insert['description'];
        $insert['branch_id']    = $this->data['current_branch'];
        $insert['auto_generated'] = 0;



        $check  = (new DailyJournalHelper)->generate_journal($insert , $insert['items']);

        if($check[0]){
            $this->return['id'] = $check[2];
            return $this->sendResponse( $this->return , $check[1]);
        }else{
            return $this->sendError( $check[1] , $check[2] ?? [] );
        }
    }

    public function show($lang , $id)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'show permission needed #02-003' , [], 200 );
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-003' , $lang)->sub_title ?? '';
        $this->return['daily_types']    = DailyType::all_daily_types(array('lang' => $lang , 'active' => '1' ));
        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => '1' ));
        $this->return['cost_centers']   = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => '1' ));
        $this->return['master']         = DailyJournal::get_daily_journal_m( $id ,$lang );
        $this->return['details']        = DailyJournal::get_daily_journal_d( $id ,$lang );
        $this->return['files']          = DailyJournal::get_files( $id );
        $this->return['next_item']      = DailyJournal::get_next( $id , $this->data['current_branch'] )->m_id ?? 0;
        $this->return['previous_item']  = DailyJournal::get_previous($id , $this->data['current_branch'] )->m_id ?? 0;
        $this->return['first_item']     = 1;
        $this->return['last_item']      = DailyJournal::get_last($this->data['current_branch'] )->m_id ?? 0;



        foreach ($this->return['details'] as $key => $value) {
            $this->return['details'][$key]->cost_centers = CostCenter::active_cost_centers( $lang  , array( 'account_type' => 2 , 'active' => 1 , 'ids' => explode(',', $this->return['details'][$key]->cost_centers )) );
        }
        return $this->sendResponse( $this->return );
    }

    public function update($lang , $id , Request $request )
    {
        if(!@in_array('3', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'store permission needed #02-003' , $this->data , 200 );
        }

        $update = $request->all();

        if( !isset($update['items']) || !is_array($update['items']) || count($update['items']) < 2 ){
            return $this->sendError( trans("error.account_tree")  );
        }

        if(round( collect($update['items'])->sum('credit') , 4 ) != round( collect($update['items'])->sum('debit') , 4 ) ){
            return $this->sendError( trans("error.credit_not_equal_debit") , [ round( collect($update['items'])->sum('credit') , 4 ) , round( collect($update['items'])->sum('debit') , 4 )  ]);
        }

        $master = DailyJournal::get_daily_journal_m($id , $lang);
        if(!isset($master->m_id) )
            return $this->sendError( trans("error.update_fails") , [] );
        if($master->auto_generated != 0 )
            return $this->sendError( trans("error.auto_generated_update_fail") , [] );


        $update_seed    = collect($update)->only( 'description' , 'daily_type_id' , 'journal_date' )->all() ;
        $rules          = collect(DailyJournal::$master_rules)->only('description')->all() ;
        $validator      = validator()->make( $update_seed , $rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.update_fail') , $validator->errors() );
        }

        DB::beginTransaction();

            DailyJournal::update_daily_journal_m($update_seed , $id);

            DB::table('daily_journal_d')
                ->where('daily_journal_m_id' , $id)
                ->whereNotIn('daily_journal_d_id' , collect($update['items'])->pluck('daily_journal_d_id'))
                ->delete();

            DailyJournal::delete_daily_journal_d($id);

            foreach ($update['items'] as $row) {
                if(isset($row['daily_journal_d_id']) && $row['daily_journal_d_id'] > 0 ){

                    DB::table('daily_journal_d')
                        ->where('daily_journal_m_id' , $id)
                        ->where('daily_journal_d_id' , $row['daily_journal_d_id'] )
                        ->update(
                            array(
                                'account_tree_id'   => $row['account_tree_id'] ,
                                'cost_centers'      => (is_array($row['cost_center_id'] ?? ''))? implode(',' , $row['cost_center_id']) : $row['cost_center_id'] ,
                                'debit'             => $row['debit'] ,
                                'credit'            => $row['credit'] ,
                                'description'       => $row['description']
                            )
                        );

                }else{
                    
                    $det_seed = array(
                        'daily_journal_m_id'        => $id ,
                        'account_tree_id'           => $row['account_tree_id'] ,
                        'cost_centers'              => (is_array($row['cost_center_id'] ?? ''))? implode(',' , $row['cost_center_id']) : $row['cost_center_id']  ,
                        'debit'                     => $row['debit'] ,
                        'credit'                    => $row['credit'] ,
                        'description'               => $row['description']
                    );

                    $validator = validator()->make( $det_seed , DailyJournal::$detaile_rules );
                    if($validator->fails())
                    {
                        return $this->sendError( trans('error.update_fail') , $validator->errors() );
                    }

                    DailyJournal::add_daily_journal_d($det_seed);
                }
            }

        DB::commit();
        return $this->sendResponse( $this->return , trans('main.update_success' ));
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'store permission needed #02-003' , $this->data , 200 );
        }

        $master = DailyJournal::get_daily_journal_m($id , $lang);
        if(!isset($master->m_id) || $master->finance_year_id != $this->data['current_year'] || $master->branch_id != $this->data['current_branch'] || !(new DailyJournalHelper)->can_edit_or_delete($id) ){
            return $this->sendError( trans("error.delete_fail")  );
        }

        DailyJournal::delete_daily_journal_m($id);

        return $this->sendResponse( $this->return , trans('main.delete_success' ));

    }


    public function toggle_active($lang , $id){

        $item = DailyJournal::find($id);
        if($item->journal_active){

            if(!@in_array('4', $this->data['mypermissions']['02-003'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-003' , [] , 200 );
            }

            if( !(new DailyJournalHelper)->can_edit_or_delete($id) ){
                return $this->sendError( trans('error.delete_fails') , [] );
            }

            DailyJournal::delete_daily_journal_m($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['02-003'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-003' , [] , 200 );
            }

            DailyJournal::update_daily_journal_m(array('journal_active' => 1 ) , $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function export_journal_data($lang , $id , Request $request)
    {

        if(!@in_array('5', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-003' , [] , 200 );
        }
        $this->data['lang']             = $lang;
        $this->data['master']           = DailyJournal::get_daily_journal_m( $id ,$this->data['lang'] );
        $this->data['details']          = DailyJournal::get_daily_journal_d( $id ,$this->data['lang'] );
        $this->data['screen_name']      = ScreenSub::get_screen_sub_by_screen_code('02-003' , $this->data['lang']);
        $this->data['branch_data']      = Branch::get_branch($this->data['master']->branch_id);


        $this->data['logo']             = get_logo( $this->data['master']->branch_id );
        switch (@$request['type']) {
            case 'excel':
                $this->data['logo']     = public_path().$this->data['logo'];
                $export = new InvoicesExport($this->data , 'finance/daily_journal/print');
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $this->data['logo']     = public_path().$this->data['logo'];
                $pdf = PDF::loadView('Finance/daily_journal/print', array('data' => $this->data ));
                return $pdf->stream();

            break;
            case 'image':
                $this->data['logo']     = public_path().$this->data['logo'];
                $image = App::make('snappy.image.wrapper');
                $image->loadView('Finance/daily_journal/print', array('data' => $this->data ));
                return $image->stream();

            break;
            case 'print':
                return view('Finance/daily_journal/print')->with('data' , $this->data);
            break;
        }

    }

    public function add_daily_journal_attach($lang , $id , Request $request){

        if(!@in_array('2', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-003' , [] , 200 );
        }

        if(isset($request['file']) && strlen($request['file']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64File($request['file'] , 'daily_journal' );

            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $insert = $check;
        }

        DB::table('daily_journal_d')
            ->where('daily_journal_d_id' , $id)
            ->update( ['attach_path' => $insert['url'] , 'attach_ext' => $insert['ext'] ] );

        return $this->sendResponse( [] , trans('main.add_success') );

    }

    public function get_daily_journal_attach($lang , $id , Request $request){

        if(!@in_array('1', $this->data['mypermissions']['02-003'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-003' , [] , 200 );
        }

        $rec = DB::table('daily_journal_d')
            ->where('daily_journal_d_id' , $id)
            ->first();

        return response()->file(public_path().$rec->attach_path);


    }

    public function add_master_attach($lang , $id , Request $request){
       
        $upload = new Upload;
        $check  = $upload->uploadFile($request['file'] , 'receipt_voucher' );
        if(!$check['check'])
            return $this->sendError( trans('error.add_fails') , $check['msg'] );


        $this->return['id'] = DB::table('daily_journal_files')->insertGetId( [
            'daily_journal_id'  => $id , 
            'file_name'         => $request['file_name']  ,
            'file_path'         => $check['url']  ,
            'file_ext'          => $check['extension']  ,
            'add_user'          => auth()->user()->id
        ]);



        return $this->sendResponse( $this->return , '' );
    }

    public function download_master_attach($lang , $id){

        $file = DB::table('daily_journal_files')
            ->where('daily_journal_file_id' , $id)
            ->first();

        return response()->file(public_path().$file->file_path);

    }

 
    public function delete_master_attach($lang , $id){

        $file = DB::table('daily_journal_files')
            ->where('daily_journal_file_id' , $id)
            ->first();


        DB::table('daily_journal_files')
            ->where('daily_journal_file_id' , $id)
            ->delete();


        File::delete(public_path().$file->file_path);

        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }


}
