<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Finance\Currency;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CurrencyController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    
    public function index($lang, Request $request)
    {

        $this->checkPermission('02-015','view');
        


        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
            'id'     => $request['id'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-015', $lang)->sub_title ?? '';
        $this->return['items']       = Currency::all_currency($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('02-015','add');


        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-015', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('02-015','add');


        $insert = $request->only(['name_en', 'name_ar', 'equivalent_value']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, Currency::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = Currency::add_currency($insert);
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        
        $this->checkPermission('02-015','view');


        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-015', $lang)->sub_title ?? '';
        $this->return['data']        = Currency::get_currency($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        
        $this->checkPermission('02-015','edit');


        $update    = $request->only(['name_en', 'name_ar', 'equivalent_value']);
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('currencys')->ignore($id,'currency_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('currencys')->ignore($id,'currency_id'),
            ]
        ];
        $validator = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        Currency::update_currency($update, $id);
        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('02-015','delete');


        Currency::delete_currency($id);
        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        
        $item = Currency::find($id);

        if($item->currency_active){
            $this->checkPermission('02-015','delete');


            Currency::delete_currency($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('02-015','edit');


            Currency::update_currency(array('currency_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
