<?php

namespace App\Http\Controllers\API\V1\Elevators;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Elevators\ElevatorPayments;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ElevatorPaymentsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('12-006','view');

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? 20 ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-006', $lang)->sub_title ?? '';
        $this->return['items']       = ElevatorPayments::all_payments($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('12-006','add');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-006', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('12-006','add');

        $inputs = $request->only(['name_en', 'name_ar','installments']);

        $master_seed = [
            'name_en'       => $inputs['name_en'],
            'name_ar'       => $inputs['name_ar'],
            'installments'  => json_encode($inputs['installments']),

        ];

        $validator = validator()->make($master_seed, ElevatorPayments::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $this->return['id'] = ElevatorPayments::add_payment($master_seed);

        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('12-006','view');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-006', $lang)->sub_title ?? '';
        $this->return['master']      = ElevatorPayments::get_payment($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('12-006','edit');

        $inputs = $request->only(['name_en', 'name_ar','installments']);

        $master_seed = [
            'name_en'       => $inputs['name_en'],
            'name_ar'       => $inputs['name_ar'],
            'installments'  => json_encode($inputs['installments']),
        ];

        $validator = validator()->make($master_seed, ElevatorPayments::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        ElevatorPayments::update_payment($master_seed, $id);

        DB::commit();
        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('12-006','delete');

        ElevatorPayments::delete_payment($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = ElevatorPayments::find($id);

        if($item->active){
            $this->checkPermission('12-006','view');

            ElevatorPayments::delete_payment($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('12-006','view');

            ElevatorPayments::update_payment(array('active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
