<?php

namespace App\Http\Controllers\API\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Classes\General\General;
use App\Classes\Excel\InvoicesExport;



use Route;
use App;
use Excel;
use PDF;


class BaseController extends Controller
{

    protected $data = array();

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (auth()->guard('api')->check()) {
                $general = new General;
                $this->data = $general->general_data(auth()->user()->id, Route::current()->parameter('lang'));
                if (!isset($this->data['branchs'][$this->data['current_branch']])) {
                    return $this->sendError('Branch Error', $this->data, 401);
                }

                if (!isset($this->data['years'][$this->data['current_year']])) {
                    return $this->sendError('Finance Year Error', $this->data, 401);
                }
            }

            return $next($request);
        });
    }

    public function checkPermission($code, $action)
    {
        $actions = ['view' => 1, 'add' => 2, 'edit' => 3, 'delete' => 4, 'print' => 5];
        if (!@in_array($actions[$action] ?? 10, $this->data['mypermissions'][$code][0]->permission ?? [])) {
            $response = [
                'check' => false,
                'data'  => [],
                'msg'   => 'permission needed #' . $code
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();
        }
    }


    public function sendResponse($result, $message = '')
    {
        $response = [
            'check' => true,
            'data'  => $result,
            'msg'   => $message,
        ];

        return response()->json($response, 200);
    }

    public function sendError($error, $errorMessages = [], $code = 200)
    {
        $response = [
            'check' => false,
            'msg' => $error,
        ];

        if (!empty($errorMessages)) {
            $response['data'] = $errorMessages;
        }

        return response()->json($response, $code);
    }

    public function sendPrint($type, $print_temp, $data)
    {

        switch ($type) {
            case 'excel':
                $data['logo'] = public_path() . ($data['logo'] ?? '');
                $export = new InvoicesExport($this->data, $print_temp);
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $data['logo'] = public_path() . ($data['logo'] ?? '');
                $pdf = PDF::loadView($print_temp, array('data' => $data));
                return $pdf->stream();
                break;
            case 'image':
                $data['logo'] = public_path() . ($data['logo'] ?? '');
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp, array('data' => $data));
                return $image->stream();
                break;
            case 'json':
                return $this->sendResponse($data);
                break;

            case 'print':
                return view($print_temp)->with('data', $data);
                break;
            default:
                return $this->sendResponse($data);
                break;
        }
    }
}
