<?php

namespace App\Http\Controllers\API\V1\Barbers;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Barbers\BarberShopTime;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;

class BarberShopTimeController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-001'][0]->permission ?? [])){
            return $this->sendError('view permission needed #10-001', $this->data, 200);
        }

        $this->filter = array(
            'lang' => $lang ,
            'rows' => $request['rows'] ?? null ,
            'page' => $request['page'] ?? 1 ,
            'word' => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-001', $lang)->sub_title ?? '';
        $this->return['items']       = BarberShopTime::all_barber_shop_times($this->filter);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['10-001'][0]->permission ?? [])){
            return $this->sendError('show permission needed #10-001', [], 200);
        }

        $update = $request->only(['beginning_work', 'end_work', 'is_day_off']);

        $validator = validator()->make($update, BarberShopTime::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        BarberShopTime::update_barber_shop_time($update, $id);
        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
