<?php

namespace App\Http\Controllers\API\V1\Barbers;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use App\Models\Barbers\Barber;
use App\Models\Inventory\Category;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;
use DB;

class BarberController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('view permission needed #10-002', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? 20 ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['items']       = Barber::all_barbers($this->filter);

        foreach ($this->return['items'] as $key => $value){
            $this->return['items'][$key]->barber_work_times = DB::table('barber_d')
                ->select('day_name_'.$lang.' as day_name', 'beginning_work', 'end_work', 'is_day_off')
                ->where('barber_m_id', $value->id)
                ->get();
        }

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['categorys']         = Category::all_categorys(array('active' => 1, 'lang' => $lang , 'category_type' => 0));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if (!@in_array('2', $this->data['mypermissions']['10-002'][0]->permission ?? [])) {
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $insert = $request->only(['name_en', 'name_ar', 'items' ,'categories']);

        if (isset($request['image']) && strlen($request['image']) > 100) {
            $upload = (new Upload)->uploadBase64Image($request['image'], 'barbers_images');
            if(!$upload)
                return $this->sendError(trans("error.Something Error"));
            $insert['image'] = $upload['url'];
        }

        $master_seed = [
            'name_en'   => $insert['name_en'],
            'name_ar'   => $insert['name_ar'],
            'image'     => $insert['image'] ?? null,
            'categories' => implode(',',$insert['categories']),
            'add_user'  => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, Barber::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $m_id = Barber::add_barber_m($master_seed);

        if (isset($insert['items']) && is_array($insert['items'])){
            foreach ($insert['items'] as $item){
                $details_seed = array(
                    'barber_m_id'    => $m_id,
                    'day_name_en'    => $item['day_name_en'],
                    'day_name_ar'    => $item['day_name_ar'],
                    'beginning_work' => $item['beginning_work'],
                    'end_work'       => $item['end_work'],
                    'is_day_off'     => $item['is_day_off'],
                    'add_user'       => auth()->user()->id
                );

                $validator = validator()->make($details_seed, Barber::$details_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                $d_id = Barber::add_barber_d($details_seed);
            }
        }

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('show permission needed #10-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['master']      = Barber::get_barber_m($id, $lang);
        $this->return['details']     = Barber::get_barber_d($id, $lang);
        $this->return['categorys']         = Category::all_categorys(array('active' => 1, 'lang' => $lang , 'category_type' => 0));

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if (!@in_array('3', $this->data['mypermissions']['10-002'][0]->permission ?? [])) {
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $barber = Barber::find($id);

        $update = $request->only(['name_en', 'name_ar', 'items' , 'categories']);

        if (isset($request['image']) && strlen($request['image']) > 100) {
            if (!is_null($barber->image) && file_exists(public_path().$barber->image)){
                unlink(public_path().$barber->image);
            }

            $upload = (new Upload)->uploadBase64Image($request['image'], 'barbers_images');
            if(!$upload)
                return $this->sendError(trans("error.Something Error"));
            $update['image'] = $upload['url'];
        }

        $master_seed = [
            'name_en'  => $update['name_en'],
            'name_ar'  => $update['name_ar'],
            'image'    => $update['image'] ?? $barber->image,
            'categories' => implode(',',$update['categories']),
            'add_user' => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, Barber::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        Barber::update_barber_m($master_seed, $id);

        if (isset($update['items']) && is_array($update['items'])){
            foreach ($update['items'] as $item) {
                DB::table('barber_d')
                    ->where('barber_m_id', $id)
                    ->where('barber_d_id', $item['d_id'])
                    ->update([
                        'day_name_en'    => $item['day_name_en'],
                        'day_name_ar'    => $item['day_name_ar'],
                        'beginning_work' => $item['beginning_work'],
                        'end_work'       => $item['end_work'],
                        'is_day_off'     => $item['is_day_off'],
                        'add_user'       => auth()->user()->id
                    ]);
            }
        }

        DB::commit();
        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('delete permission needed #10-002', [], 200);
        }

        Barber::delete_barber_m($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = Barber::find($id);

        if($item->barber_active){
            if(!@in_array('4', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
                return $this->sendError('update permission needed #10-002', [], 200);
            }

            Barber::delete_barber_m($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
                return $this->sendError('update permission needed #10-002', [], 200);
            }

            Barber::update_barber_m(array('barber_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
