<?php

namespace App\Http\Controllers\API\V1\Assets;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\AssetsSettings;
use App\Models\Finance\AccountTree;

class AssetsSettingsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');
        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1
        );

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']          = AssetsSettings::all_assets_settings($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['account_trees']      = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        return $this->sendResponse( $this->return);
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');


        $this->return['screen_name']     = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['item']            = AssetsSettings::get_assets_settings($id, $lang);
        $this->return['account_trees']   = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));

        return $this->sendResponse( $this->return);
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();
        $update = [
            'loss_acc_id'       => $input['loss_acc_id'],
            'profit_acc_id'     => $input['profit_acc_id'],
            'create_purchase'   => $input['create_purchase'],
            'create_journal'    => $input['create_journal'],
            'show_journal'      => $input['show_journal'],
        ];

        $validator  = validator()->make( $update , AssetsSettings::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        AssetsSettings::update_assets_settings($update ,$id );
        $this->return = AssetsSettings::get_assets_settings($id,$lang);
        return $this->sendResponse( [] , trans('main.update_success') );
    }

}
