<?php

namespace App\Http\Controllers\API\V1\Assets;

use App\Http\Controllers\API\V1\BaseController;
use App\Models\Assets\Assets;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\AssetsDeprecating;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File as FacadesFile;

class AssetsDeprecatingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');

        $this->filter = array(
            'lang'        => $lang ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']       = AssetsDeprecating::all_assets_deprecating($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));
        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $insert = [
            'doc_date'          => $input['doc_date'] ?? date('Y-m-d'),
            'doc_number'        => $input['doc_number'] ,
            'asset_m_id'        => $input['asset_m_id'],
            'notes'             => $input['notes'] ?? null,
            'add_user'          => auth()->user()->id,
        ];
        $validator = validator()->make( $insert , AssetsDeprecating::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = AssetsDeprecating::add_assets_deprecating($insert);
        Assets::update_assets_m(array('is_destructed' => 1),$input['asset_m_id']);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['item']           = AssetsDeprecating::get_assets_deprecating($id,$lang);
        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));
        return $this->sendResponse( $this->return);
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();

        $update = [
            'doc_date'          => $input['doc_date'],
            'doc_number'        => $input['doc_number'],
            'asset_m_id'        => $input['asset_m_id'],
            'notes'             => $input['notes'],
        ];

        $validator  = validator()->make( $update , AssetsDeprecating::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        AssetsDeprecating::update_assets_deprecating($update ,$id );
        $this->return = AssetsDeprecating::get_assets_deprecating($id,$lang);

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('06-021','delete');

        $file_url = DB::table('deprecating_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the server
        if ($file_url && FacadesFile::exists(public_path($file_url))) {
            FacadesFile::delete(public_path($file_url));
        }
        AssetsDeprecating::delete_deprecating_attachments($id);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


}
