<?php

namespace App\Http\Controllers\API\EX\V1;
use App\Http\Controllers\API\EX\V1\BaseController;
use App\Models\Main\Branch;
use App\Models\Inventory\Category;
use App\Models\Barbers\BarberBooking;
use App\Models\Inventory\Item;
use App\Models\Sales\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Classes\General\SMS;
use App\Classes\RealTime\NotificationHelper;
use Illuminate\Validation\Rules\NotIn;

class BookingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->filter = [
            'lang'          => $lang,
            'active_date'   => $request['active_date'] ?? null,
        ];
        $this->return['columns'] = 5;
        $this->return['barbers_bookings'] = BarberBooking::all_barber_bookings($this->filter);

        return $this->sendResponse($this->return);
    }
    public function barbers_bookings($lang, Request $request)
    {
        $this->filter = [
            'lang'          => $lang,
            'active_date'   => $request['active_date'] ?? date('Y-m-d'),
            'barber'        => auth()->user()->barber_id ?? 0,
        ];

        $this->return['barbers_bookings'] = BarberBooking::all_barber_bookings($this->filter);
        foreach ($this->return['barbers_bookings'] as $barber_booking ){
            $barber_booking->activities = DB::table('booking_activities')->where('booking_id',$barber_booking->id)->get()->toArray();
        };
        return $this->sendResponse($this->return);
    }
    public function barbers_start_order($lang, $id)
    {
        $insert = [
            'add_user'      => auth()->user()->barber_id,
            'status'        => 1,
            'booking_id'    => $id,
        ];
        $this->return['id'] = DB::table('booking_activities')->insertGetId($insert);
        return $this->sendResponse($this->return);
    }

    public function barbers_end_order($lang, $id)
    {
        $insert = [
            'add_user'      => auth()->user()->barber_id,
            'status'        => 2,
            'booking_id'    => $id,
        ];
        $this->return['id'] = DB::table('booking_activities')->insertGetId($insert);
        return $this->sendResponse($this->return);
    }

    public function create_booking($lang, Request $request)
    {
        $this->return['categorys'] = Category::all_categorys(array('active' => 1, 'lang' => $lang , 'category_type' => 0 ));
        $this->return['services']  = Item::all_items(array('active' => 1, 'lang' => $lang , 'pos_item' => 1));
        $this->return['branchs']   = Branch::all_branchs(array('active' => 1, 'lang' => $lang));


        $barber_in_vacation_ids = DB::table('barber_vacations')
            ->whereDate('from_date', '>=', date("Y-m-d"))
            ->whereDate('to_date', '<=', date("Y-m-d"))
            ->pluck('barber_id');

        $this->return['barbers'] = DB::table('barber_m')
            ->where('barber_active' , 1 )
            ->selectRaw('barber_m_id as id , name_'.$lang.' as name , image')
            ->whereNotIn('barber_m_id', $barber_in_vacation_ids)
            ->orderBy('barber_m.barber_m_id', 'desc')
            ->get();


        return $this->sendResponse($this->return);
    }
    public function search_customer($lang, Request $request)
    {
        $input = $request->all();
        $this->filter = array(
            'lang'   => $lang,
            'active' => $input['active'] ?? 1,
            'word'   => $input['word'] ?? null
        );

        $this->return = Customer::all_customers($this->filter);
        return $this->sendResponse($this->return);
    }
    public function make_booking($lang, Request $request)
    {
        
        $insert = $request->only('services', 'branch_id', 'barber_booking_date', 'start_time', 'coupon_code' , 'barber_id','platform');

        $validator = validator()->make($insert, BarberBooking::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.Error In Validation'), $validator->errors());
        }

        $services = DB::table('items')->whereIn('item_id', $insert['services'])->get();

        $total_with_vat    = collect($services)->sum('sale_price');
        $total_without_vat = ($total_with_vat / 1.15);
        $total_vat         = ($total_with_vat - $total_without_vat);

        $needed_blocks  = collect($services)->sum('time_blocks');
        if($needed_blocks < 1 ){
            return $this->sendError(trans('error.Error In Time'), [] );
        }

        $needed_blocks      = ceil( $needed_blocks / 5 );
        $time_blocks_ids    = DB::table('b_times')
            ->where('time_id' , '>=', $insert['start_time'])
            ->take($needed_blocks+1)
            ->pluck('time_id')
            ->toArray();

        $insert['end_time']         = end($time_blocks_ids);
        $insert['services']         = (is_array($insert['services'] ?? '')) ? implode(',', $insert['services']) : $insert['services'];
        $insert['time_blocks_ids']  = implode(',', $time_blocks_ids);
        $insert['platform']         = $request->header('platform');
        $barber_customer_mobile     = $request['barber_customer_mobile'];
        $customer_id                = DB::table('customers')
            ->where('customers.phone' , $barber_customer_mobile)
            ->orWhere('customers.phone2',$barber_customer_mobile)
            ->orWhere('customers.phone3',$barber_customer_mobile)
            ->orWhere('customers.phone4',$barber_customer_mobile)
            ->value('customer_id');

        if( !$customer_id ){
            $customer_id  = DB::table('customers')
                ->insertGetId([
                    'name_en'   => $request['barber_customer_name'] ,
                    'name_ar'   => $request['barber_customer_name'] ,
                    'phone'     => $request['barber_customer_mobile']
                ]);
        }

        // if (isset($request['coupon_code']) && !is_null($request['coupon_code'])){
        //     $coupon = DB::table('coupons')->where([
        //         ['coupon_code', $request['coupon_code']],
        //         ['active',1],
        //         ['allowed_count','>',0]
        //         ])
        //         ->whereDate('start_date', '<=', date('Y-m-d'))
        //         ->whereDate('end_date', '>=', date('Y-m-d'))
        //         ->first();
        //     $coupon->platforms_id = explode(',', $coupon->platforms);
        //     $coupon->customers_id = explode(',', $coupon->customers_id);
        //     $coupon->services     = explode(',', $coupon->services);

        //     if (is_null($coupon) || !in_array($insert['platform'], $coupon->platforms_id)){
        //         return $this->sendError(trans('error.Coupon Not Found'));
        //     }
        //     if($coupon->for_customer == 1 && !in_array($customer_id,$coupon->customers_id)){
        //         return $this->sendError(trans('error.Coupon Not Found'));
        //     }

        //     // If Isset Coupon Get Coupon Discount Value and Calc Total Without Vat
        //     if ($coupon->coupon_type == 1){
        //         $insert['coupon_discount'] = $coupon->discount;
        //         $insert['total_without_vat'] = $total_without_vat - $insert['coupon_discount'];
        //         $insert['total_vat'] = ($insert['total_without_vat'] * 0.15);
        //         $insert['total_with_vat'] = $insert['total_without_vat'] + $insert['total_vat'];
        //     }else{
        //         $discount_per = ($coupon->discount / 100);
        //         $insert['coupon_discount'] = ($total_without_vat * $discount_per);
        //         $insert['total_without_vat'] = $total_without_vat - $insert['coupon_discount'];
        //         $insert['total_vat'] = ($insert['total_without_vat'] * 0.15);
        //         $insert['total_with_vat'] = $insert['total_without_vat'] + $insert['total_vat'];
        //     }
        // }


        $id = DB::table('barber_bookings')->insertGetId([
            'barber_id'                => $insert['barber_id'] ,
            'barber_customer_id'       => $customer_id ,
            'services'                 => $insert['services'],
            'time_blocks_ids'          => $insert['time_blocks_ids'] ,
            'needed_blocks'            => $needed_blocks ,
            'branch_id'                => $insert['branch_id'] ,
            'barber_booking_date'      => $insert['barber_booking_date'] ,
            'start_time'               => $insert['start_time'] ,
            'end_time'                 => $insert['end_time'] ,
            'coupon_code'              => $insert['coupon_code'] ?? 0 ,
            'coupon_discount'          => $insert['coupon_discount'] ?? 0 ,
            'platform'                 => $insert['platform'] ?? null ,
            'total_price'              => $insert['total_without_vat'] ?? $total_without_vat ,
            'total_vat'                => $insert['total_vat'] ?? $total_vat ,
            'total_without_vat'        => $insert['total_without_vat'] ?? $total_without_vat ,
            'total_with_vat'           => $insert['total_with_vat'] ?? $total_with_vat ,
            'add_user'                 => $customer_id,
        ]);


        $time_title = DB::table('b_times')->where('time_id' , $insert['start_time'] )->first()->time_title ?? '';
        $day_title  = date("D" , strtotime($insert['barber_booking_date']));
        $message    = "ضيفنا العزيز نود تأكيد موعدكم  رقم ".$id."  يوم  ".$day_title." بتاريخ ".$insert['barber_booking_date']." الساعة ".$time_title." في فرع الرياض https://maps.app.goo.gl/wJ4RvLjnFdHCFbV3A?g_st=iw";

        (new SMS)->send("966".intval($request['barber_customer_mobile']) , $message );
        $added_booking = BarberBooking::get_barber_booking($id,$lang);
        $count = DB::table('barber_bookings')
        ->where([
            ['barber_booking_active',1],
            ['barber_booking_date',date('Y-m-d')],
            ['has_invoice',0],
        ])->count();
        (new NotificationHelper)->send_notifications($count);
        return $this->sendResponse([], trans('main.Your Booking Has Been Registered'));
    }

    public function get_coupon_data($lang, $coupon_code)
    {
        $this->return['coupon'] = DB::table('coupons')
            ->select('coupon_id', 'code', 'discount_type', 'discount_value')
            ->where('code', $coupon_code)
            ->first();

        if (is_null($this->return['coupon'])){
            return $this->sendError(trans('error.Coupon Not Found'));
        }

        return $this->sendResponse($this->return);
    }

    public function get_available_times($lang, Request $request)
    {
        $insert             = $request->only('services', 'booking_date' , 'barber_id');
        $chairs_number      = 1;
        $currentDate        = now()->toTimeString();
        $day_name           = date('l', strtotime($currentDate));
        $checkDateWorkTime  = DB::table('barber_shop_times')->where('day_name_en', $day_name)->first();
        $beginning_work     = $checkDateWorkTime->beginning_work;
        $end_work           = $checkDateWorkTime->end_work;
        $services           = DB::table('items')
            ->whereIn('item_id', $insert['services'])
            ->where('category_id',1)
            ->get();
        $needed_blocks      = collect($services)->sum('time_blocks');


        $times              = DB::table('b_times')
            ->where('time_title', '>', $currentDate)
            ->where('time_title', '>=', $beginning_work)
            ->where('time_title', '<=', $end_work)
            ->get();
        $bookings           = DB::table('barber_bookings')
            ->where('barber_booking_date', $insert['booking_date'])
            ->where('barber_id' , $insert['barber_id'] )
            ->where('barber_booking_status', 1)
            ->where('barber_booking_active', 1)
            ->get();

        if (count($bookings) > 0){
            foreach ($times as $key => $value){
                $bookingsCount = DB::table('barber_bookings')
                    ->where('barber_booking_date', $insert['booking_date'])
                    ->where('barber_id' , $insert['barber_id'] )
                    ->where('barber_booking_status', 1)
                    ->where('barber_booking_active', 1)
                    ->whereRaw('find_in_set('.$value->time_id.', time_blocks_ids)')
                    ->count();
                if ($bookingsCount >= $chairs_number){
                    unset($times[$key]);
                    for ($i=1; $i < $needed_blocks; $i++){
                        unset($times[$key-$i]);
                    }
                }
            }
        }

        return $this->sendResponse($times);
    }

    public function get_my_bookings($lang, Request $request)
    {
        $this->return['bookings'] = DB::table('barber_bookings')
            ->select(DB::raw("GROUP_CONCAT(items.name_ar) as services_names"))
            ->leftjoin("items",DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"),">",DB::raw("'0'"))
            ->leftjoin('b_branchs', 'barber_bookings.branch_id', '=', 'b_branchs.branch_id')
            ->leftjoin('b_times', 'barber_bookings.start_time', '=', 'b_times.time_id')
            ->where('barber_bookings.barber_customer_id', $request['customer_id'])
            ->selectRaw('
                barber_bookings.barber_booking_id as id ,
                barber_bookings.barber_booking_date ,
                barber_bookings.branch_id ,
                b_branchs.name_'.$lang.' as branch_name ,
                barber_bookings.total_with_vat
            ')
            ->orderBy('barber_bookings.barber_booking_id', 'desc')
            ->groupBy('barber_bookings.barber_booking_id')
            ->get();

        return $this->sendResponse($this->return);
    }

    public function get_booking_details($lang,$id , Request $request)
    {
        $this->return['bookings'] = BarberBooking::get_barber_booking($id , $lang);


        // if(!isset($this->return['bookings']->id) || $this->return['bookings']->user_id != auth()->user()->id ){
        //     return $this->sendError('Error in booking id', []);
        // }

        return $this->sendResponse($this->return);
    }

}
