<?php

namespace App\Classes\Sales;

use App\Classes\Sales\SalesGeneralHelper;
use DB;

class QuotationHelper
{

    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('quotation_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('quotation_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('quotation_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        $check = DB::table('quotation_m')
            ->where('quotation_m_id' , $id)
            ->value('quotation_status');

        return (in_array($check , [1,2,3])? true : false );
    }

    function prepare_details($m_id , $items , $price_include_vat , $stock_watch = 0){

        $rows   = ( new SalesGeneralHelper )->generate_items($items , $price_include_vat  , $stock_watch);
        $return = [] ;

        foreach ($rows as $key => $row){
            $return[$key]                       = $row;
            $return[$key]['d_id']               = $items[$key]['d_id'] ?? null ;
            $return[$key]['discount_per']       = $items[$key]['discount_per'] ?? 0 ;

            $return[$key]['width']              = $items[$key]['width'] ?? 0 ;
            $return[$key]['height']             = $items[$key]['height'] ?? 0 ;

            $return[$key]['area_width']         = $items[$key]['area_width'] ?? 0 ;
            $return[$key]['area_height']        = $items[$key]['area_height'] ?? 0 ;
            $return[$key]['area_quantity']      = $items[$key]['area_quantity'] ?? 0 ;
            $return[$key]['description']        = $items[$key]['description'] ?? '' ;

            $return[$key]['currency_id']        = $row['currency_id'] ;
            $return[$key]['foreign_currency']   = $row['foreign_currency'] ;
            $return[$key]['equivalent_value']   = $row['equivalent_value'] ;

            $return[$key]['quotation_m_id']     = $m_id ;
            $return[$key]['add_user']           = auth()->user()->id;
        }
        return $return;
    }

    function update_master_values($id)
    {
        $quotation      = DB::table('quotation_m')->where('quotation_m_id', $id)->first();
        $details        = DB::table('quotation_d')->where('quotation_m_id', $id)->get();

        DB::table('quotation_m')
            ->where('quotation_m.quotation_m_id', $id)
            ->update([
                'total_discount'             => $details->sum('total_discount') ,
                'total_vat'                  => $details->sum('total_vat') ,
                'total_without_vat'          => $details->sum('total_without_vat') ,
                'total_with_vat'             => $details->sum('total_with_vat') ,
                'total_price_after_discount' => $details->sum('total_without_vat') ,
            ]);
    }

    function generate_daily_journal($id)
    {
        return true;
    }
}
